/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.event.external.service.serialization.serializer.loan;

import java.util.List;
import org.apache.fineract.avro.generator.ByteBufferSerializable;
import org.apache.fineract.avro.loan.v1.LoanTransactionDataV1;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanChargeOffPostBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanTransactionBusinessEvent;
import org.apache.fineract.infrastructure.event.external.service.serialization.mapper.loan.LoanTransactionDataMapper;
import org.apache.fineract.infrastructure.event.external.service.serialization.mapper.loan.UnpaidChargeDataMapper;
import org.apache.fineract.infrastructure.event.external.service.serialization.serializer.ExternalEventCustomDataSerializer;
import org.apache.fineract.infrastructure.event.external.service.serialization.serializer.loan.LoanTransactionBusinessEventSerializer;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRepository;
import org.apache.fineract.portfolio.loanaccount.service.LoanChargePaidByReadService;
import org.apache.fineract.portfolio.loanaccount.service.LoanReadPlatformService;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=0x7FFFFFFE)
public class LoanChargeOffBusinessEventSerializer
extends LoanTransactionBusinessEventSerializer {
    private final UnpaidChargeDataMapper unpaidChargeDataMapper;
    private final LoanTransactionRepository loanTransactionRepository;

    public LoanChargeOffBusinessEventSerializer(LoanReadPlatformService loanReadPlatformService, LoanTransactionDataMapper loanTransactionMapper, LoanChargePaidByReadService loanChargePaidByReadService, UnpaidChargeDataMapper unpaidChargeDataMapper, LoanTransactionRepository loanTransactionRepository, List<ExternalEventCustomDataSerializer<LoanTransactionBusinessEvent>> externalEventCustomDataSerializers) {
        super(loanReadPlatformService, loanTransactionMapper, loanChargePaidByReadService, externalEventCustomDataSerializers);
        this.unpaidChargeDataMapper = unpaidChargeDataMapper;
        this.loanTransactionRepository = loanTransactionRepository;
    }

    public <T> boolean canSerialize(BusinessEvent<T> event) {
        return event instanceof LoanChargeOffPostBusinessEvent;
    }

    public <T> ByteBufferSerializable toAvroDTO(BusinessEvent<T> rawEvent) {
        LoanTransactionDataV1 transactionDataV1 = (LoanTransactionDataV1)super.toAvroDTO(rawEvent);
        LoanTransactionBusinessEvent event = (LoanTransactionBusinessEvent)rawEvent;
        List unpaidChargeDataList = this.loanTransactionRepository.fetchTotalUnpaidChargesForLoan(((LoanTransaction)event.get()).getLoan());
        transactionDataV1.setUnpaidCharges(this.unpaidChargeDataMapper.map(unpaidChargeDataList));
        return transactionDataV1;
    }
}

