/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.s3;

import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.condition.PropertiesCondition;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;

public class AmazonS3ConfigCondition
extends PropertiesCondition {
    protected boolean matches(FineractProperties properties) {
        FineractProperties.FineractExportS3Properties s3ReportExportProperties = properties.getReport().getExport().getS3();
        return s3ReportExportProperties.getEnabled() != false && StringUtils.isNotBlank((CharSequence)s3ReportExportProperties.getBucketName()) && this.isAwsCredentialValid();
    }

    private boolean isAwsCredentialValid() {
        try {
            DefaultCredentialsProvider.create().resolveCredentials();
            DefaultAwsRegionProviderChain.builder().build().getRegion();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

