/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.security.converter;

import java.util.Collection;
import lombok.Generated;
import org.apache.fineract.infrastructure.security.data.FineractJwtAuthenticationToken;
import org.apache.fineract.infrastructure.security.service.TenantAwareJpaPlatformUserDetailsService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.NonNull;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtGrantedAuthoritiesConverter;

public class FineractJwtAuthenticationTokenConverter
implements Converter<Jwt, FineractJwtAuthenticationToken> {
    private final TenantAwareJpaPlatformUserDetailsService userDetailsService;

    @NonNull
    public FineractJwtAuthenticationToken convert(@NonNull Jwt jwt) {
        try {
            UserDetails user = this.userDetailsService.loadUserByUsername(jwt.getSubject());
            Collection authorities = new JwtGrantedAuthoritiesConverter().convert(jwt);
            return new FineractJwtAuthenticationToken(jwt, authorities, user);
        }
        catch (UsernameNotFoundException ex) {
            throw new OAuth2AuthenticationException(new OAuth2Error("invalid_token"), (Throwable)ex);
        }
    }

    @Generated
    public FineractJwtAuthenticationTokenConverter(TenantAwareJpaPlatformUserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }
}

