/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.springbatch;

import lombok.Generated;
import org.apache.fineract.infrastructure.core.domain.ActionContext;
import org.apache.fineract.infrastructure.core.domain.FineractContext;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.infrastructure.springbatch.ContextualMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.integration.partition.StepExecutionRequest;
import org.springframework.lang.NonNull;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.support.ExecutorChannelInterceptor;
import org.springframework.messaging.support.GenericMessage;

public class InputChannelInterceptor
implements ExecutorChannelInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InputChannelInterceptor.class);

    public Message<StepExecutionRequest> beforeHandle(@NonNull Message<?> message, @NonNull MessageChannel channel, @NonNull MessageHandler handler) {
        return this.beforeHandleMessage(message);
    }

    public void afterMessageHandled(@NonNull Message<?> message, @NonNull MessageChannel channel, @NonNull MessageHandler handler, Exception ex) {
        log.debug("Cleaning up ThreadLocal context after message handling");
        ThreadLocalContextUtil.reset();
    }

    public Message<StepExecutionRequest> beforeHandleMessage(Message<?> message) {
        return new GenericMessage((Object)this.beforeHandleMessage((ContextualMessage)message.getPayload()));
    }

    public StepExecutionRequest beforeHandleMessage(ContextualMessage contextualMessage) {
        log.debug("Initializing ThreadLocal context for message handling");
        ThreadLocalContextUtil.init((FineractContext)contextualMessage.getContext());
        ThreadLocalContextUtil.setActionContext((ActionContext)ActionContext.COB);
        return contextualMessage.getStepExecutionRequest();
    }
}

