/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.springbatch.messagehandler;

import lombok.Generated;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobInterruptedException;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.StepLocator;
import org.springframework.batch.integration.partition.StepExecutionRequest;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"fineract.mode.batch-worker-enabled"}, havingValue="true")
public class StepExecutionRequestHandler {
    private final JobRepository jobRepository;
    private final StepLocator stepLocator;
    private final JobExplorer jobExplorer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(StepExecutionRequest request) {
        Long jobExecutionId = request.getJobExecutionId();
        Long stepExecutionId = request.getStepExecutionId();
        String stepName = request.getStepName();
        StepExecution stepExecution = this.jobExplorer.getStepExecution(jobExecutionId, stepExecutionId);
        if (stepExecution == null) {
            throw new IllegalStateException("stepExecution cannot be null");
        }
        Step step = this.stepLocator.getStep(stepName);
        try {
            step.execute(stepExecution);
        }
        catch (JobInterruptedException e) {
            stepExecution.addFailureException((Throwable)e);
            stepExecution.setStatus(BatchStatus.STOPPED);
        }
        catch (OptimisticLockingFailureException e) {
        }
        catch (Exception e) {
            stepExecution.addFailureException((Throwable)e);
            stepExecution.setStatus(BatchStatus.FAILED);
        }
        finally {
            this.jobRepository.update(stepExecution);
        }
    }

    @Generated
    public StepExecutionRequestHandler(JobRepository jobRepository, StepLocator stepLocator, JobExplorer jobExplorer) {
        this.jobRepository = jobRepository;
        this.stepLocator = stepLocator;
        this.jobExplorer = jobExplorer;
    }
}

