/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.springbatch.messagehandler.jms;

import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import lombok.Generated;
import org.apache.fineract.infrastructure.springbatch.InputChannelInterceptor;
import org.apache.fineract.infrastructure.springbatch.messagehandler.StepExecutionRequestHandler;
import org.apache.fineract.infrastructure.springbatch.messagehandler.conditions.jms.JmsWorkerCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.integration.partition.StepExecutionRequest;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Conditional;
import org.springframework.jms.support.converter.MessagingMessageConverter;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={JmsWorkerCondition.class})
public class JmsBatchWorkerMessageListener
implements MessageListener,
InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JmsBatchWorkerMessageListener.class);
    private final StepExecutionRequestHandler stepExecutionRequestHandler;
    private final InputChannelInterceptor inputInterceptor;
    private MessagingMessageConverter converter;

    public void afterPropertiesSet() throws Exception {
        this.converter = new MessagingMessageConverter();
    }

    public void onMessage(Message message) {
        try {
            org.springframework.messaging.Message msg = (org.springframework.messaging.Message)this.converter.fromMessage(message);
            log.debug("Received JMS partition message {}", (Object)msg);
            org.springframework.messaging.Message requestMessage = this.inputInterceptor.beforeHandleMessage(msg);
            this.stepExecutionRequestHandler.handle((StepExecutionRequest)requestMessage.getPayload());
        }
        catch (Exception e) {
            log.error("Exception while processing JMS message", (Throwable)e);
        }
        try {
            message.acknowledge();
        }
        catch (JMSException e) {
            throw new RuntimeException("Unable to acknowledge message", e);
        }
    }

    @Generated
    public JmsBatchWorkerMessageListener(StepExecutionRequestHandler stepExecutionRequestHandler, InputChannelInterceptor inputInterceptor) {
        this.stepExecutionRequestHandler = stepExecutionRequestHandler;
        this.inputInterceptor = inputInterceptor;
    }
}

