/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.notification.config;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.ExceptionListener;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.fineract.infrastructure.core.condition.EnableFineractEventsCondition;
import org.apache.fineract.notification.eventandlistener.NotificationEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.Environment;
import org.springframework.jms.connection.CachingConnectionFactory;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.listener.DefaultMessageListenerContainer;

@Configuration
@Profile(value={"activeMqEnabled"})
@Conditional(value={EnableFineractEventsCondition.class})
public class MessagingConfiguration {
    @Autowired
    private Environment env;
    @Autowired
    private NotificationEventListener notificationEventListener;
    private static final String DEFAULT_BROKER_URL = "tcp://localhost:61616";

    @Bean
    public Logger loggerBean() {
        return LoggerFactory.getLogger(MessagingConfiguration.class);
    }

    @Bean
    public ActiveMQConnectionFactory amqConnectionFactory() {
        ActiveMQConnectionFactory amqConnectionFactory = new ActiveMQConnectionFactory();
        try {
            amqConnectionFactory.setBrokerURL(DEFAULT_BROKER_URL);
        }
        catch (Exception e) {
            amqConnectionFactory.setBrokerURL(this.env.getProperty("brokerUrl"));
        }
        return amqConnectionFactory;
    }

    @Bean
    public CachingConnectionFactory connectionFactory() {
        return new CachingConnectionFactory((ConnectionFactory)this.amqConnectionFactory());
    }

    @Bean
    public JmsTemplate jmsTemplate() {
        JmsTemplate jmsTemplate = new JmsTemplate((ConnectionFactory)this.connectionFactory());
        jmsTemplate.setConnectionFactory((ConnectionFactory)this.connectionFactory());
        return jmsTemplate;
    }

    @Bean
    public DefaultMessageListenerContainer messageListenerContainer() {
        DefaultMessageListenerContainer messageListenerContainer = new DefaultMessageListenerContainer();
        messageListenerContainer.setConnectionFactory((ConnectionFactory)this.connectionFactory());
        messageListenerContainer.setDestinationName("NotificationQueue");
        messageListenerContainer.setMessageListener((Object)this.notificationEventListener);
        messageListenerContainer.setExceptionListener((ExceptionListener)new /* Unavailable Anonymous Inner Class!! */);
        return messageListenerContainer;
    }
}

