/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.notification.eventandlistener;

import lombok.Generated;
import org.apache.fineract.infrastructure.core.domain.FineractContext;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.notification.data.NotificationData;
import org.apache.fineract.notification.eventandlistener.NotificationEvent;
import org.apache.fineract.notification.eventandlistener.NotificationEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Profile;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"!activeMqEnabled"})
public class SpringNotificationEventListener
implements ApplicationListener<NotificationEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringNotificationEventListener.class);
    private final NotificationEventListener notificationEventListener;

    public void onApplicationEvent(@NonNull NotificationEvent event) {
        log.debug("Processing Spring notification event {}", (Object)event);
        try {
            ThreadLocalContextUtil.init((FineractContext)event.getContext());
            NotificationData notificationData = event.getNotificationData();
            this.notificationEventListener.receive(notificationData);
        }
        finally {
            ThreadLocalContextUtil.reset();
        }
    }

    @Generated
    public SpringNotificationEventListener(NotificationEventListener notificationEventListener) {
        this.notificationEventListener = notificationEventListener;
    }
}

