/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.holiday.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.organisation.holiday.domain.RescheduleType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HolidayDataValidator {
    private final FromJsonHelper fromApiJsonHelper;
    private static final Set<String> HOLIDAY_CREATE_OR_UPDATE_REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("locale", "dateFormat", "name", "fromDate", "toDate", "description", "offices", "repaymentsRescheduledTo", "reschedulingType"));

    @Autowired
    public HolidayDataValidator(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public void validateForCreate(String json) {
        JsonArray array;
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)HOLIDAY_CREATE_OR_UPDATE_REQUEST_DATA_PARAMETERS);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("holiday");
        String name = this.fromApiJsonHelper.extractStringNamed("name", element);
        baseDataValidator.reset().parameter("name").value((Object)name).notNull().notExceedingLengthOf(Integer.valueOf(100));
        LocalDate fromDate = this.fromApiJsonHelper.extractLocalDateNamed("fromDate", element);
        baseDataValidator.reset().parameter("fromDate").value((Object)fromDate).notNull();
        LocalDate toDate = this.fromApiJsonHelper.extractLocalDateNamed("toDate", element);
        baseDataValidator.reset().parameter("toDate").value((Object)toDate).notNull();
        Integer reschedulingType = null;
        if (this.fromApiJsonHelper.parameterExists("reschedulingType", element)) {
            reschedulingType = this.fromApiJsonHelper.extractIntegerNamed("reschedulingType", element, Locale.ENGLISH);
        }
        LocalDate repaymentsRescheduledTo = null;
        if (reschedulingType == null || reschedulingType.equals(RescheduleType.RESCHEDULETOSPECIFICDATE.getValue())) {
            repaymentsRescheduledTo = this.fromApiJsonHelper.extractLocalDateNamed("repaymentsRescheduledTo", element);
            baseDataValidator.reset().parameter("repaymentsRescheduledTo").value((Object)repaymentsRescheduledTo).notNull();
        }
        HashSet<Long> offices = null;
        JsonObject topLevelJsonElement = element.getAsJsonObject();
        if (topLevelJsonElement.has("offices") && topLevelJsonElement.get("offices").isJsonArray() && (array = topLevelJsonElement.get("offices").getAsJsonArray()).size() > 0) {
            offices = new HashSet<Long>(array.size());
            for (int i = 0; i < array.size(); ++i) {
                JsonObject officeElement = array.get(i).getAsJsonObject();
                Long officeId = this.fromApiJsonHelper.extractLongNamed("officeId", (JsonElement)officeElement);
                baseDataValidator.reset().parameter("offices").value((Object)officeId).notNull();
                offices.add(officeId);
            }
        }
        baseDataValidator.reset().parameter("offices").value(offices).notNull();
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForUpdate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)HOLIDAY_CREATE_OR_UPDATE_REQUEST_DATA_PARAMETERS);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("holiday");
        if (this.fromApiJsonHelper.parameterExists("name", element)) {
            String name = this.fromApiJsonHelper.extractStringNamed("name", element);
            baseDataValidator.reset().parameter("name").value((Object)name).notNull().notExceedingLengthOf(Integer.valueOf(100));
        }
        if (this.fromApiJsonHelper.parameterExists("fromDate", element)) {
            LocalDate fromDate = this.fromApiJsonHelper.extractLocalDateNamed("fromDate", element);
            baseDataValidator.reset().parameter("fromDate").value((Object)fromDate).notNull();
        }
        if (this.fromApiJsonHelper.parameterExists("toDate", element)) {
            LocalDate toDate = this.fromApiJsonHelper.extractLocalDateNamed("toDate", element);
            baseDataValidator.reset().parameter("toDate").value((Object)toDate).notNull();
        }
        if (this.fromApiJsonHelper.parameterExists("repaymentsRescheduledTo", element)) {
            LocalDate repaymentsRescheduledTo = this.fromApiJsonHelper.extractLocalDateNamed("repaymentsRescheduledTo", element);
            baseDataValidator.reset().parameter("repaymentsRescheduledTo").value((Object)repaymentsRescheduledTo).notNull();
        }
        HashSet<Long> offices = null;
        JsonObject topLevelJsonElement = element.getAsJsonObject();
        if (this.fromApiJsonHelper.parameterExists("offices", element)) {
            JsonArray array;
            if (topLevelJsonElement.has("offices") && topLevelJsonElement.get("offices").isJsonArray() && (array = topLevelJsonElement.get("offices").getAsJsonArray()).size() > 0) {
                offices = new HashSet<Long>(array.size());
                for (int i = 0; i < array.size(); ++i) {
                    JsonObject officeElement = array.get(i).getAsJsonObject();
                    Long officeId = this.fromApiJsonHelper.extractLongNamed("officeId", (JsonElement)officeElement);
                    baseDataValidator.reset().parameter("offices").value((Object)officeId).notNull();
                    offices.add(officeId);
                }
            }
            baseDataValidator.reset().parameter("offices").value(offices).notNull();
            this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
        }
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }
}

