/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.holiday.service;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.holiday.data.HolidayData;
import org.apache.fineract.organisation.holiday.domain.RescheduleType;
import org.apache.fineract.organisation.holiday.exception.HolidayNotFoundException;
import org.apache.fineract.organisation.holiday.service.HolidayEnumerations;
import org.apache.fineract.organisation.holiday.service.HolidayReadPlatformService;
import org.apache.fineract.organisation.holiday.service.HolidayReadPlatformServiceImpl;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class HolidayReadPlatformServiceImpl
implements HolidayReadPlatformService {
    private final PlatformSecurityContext context;
    private final JdbcTemplate jdbcTemplate;

    public Collection<HolidayData> retrieveAllHolidaysBySearchParamerters(Long officeId, LocalDate fromDate, LocalDate toDate) {
        this.context.authenticatedUser();
        DateTimeFormatter df = DateUtils.DEFAULT_DATE_FORMATTER;
        Object[] objectArray = new Object[3];
        int arrayPos = 0;
        HolidayMapper rm = new HolidayMapper();
        String sql = "select " + rm.schema() + " join m_holiday_office hf on h.id = hf.holiday_id and hf.office_id = ? ";
        objectArray[arrayPos] = officeId;
        ++arrayPos;
        if (fromDate != null || toDate != null) {
            sql = sql + "and ";
            if (fromDate != null) {
                sql = sql + "h.from_Date >= ? ";
                objectArray[arrayPos] = df.format(fromDate);
                ++arrayPos;
            }
            if (toDate != null) {
                sql = sql + (fromDate != null ? "and " : "");
                sql = sql + "h.to_date <= ? ";
                objectArray[arrayPos] = df.format(toDate);
                ++arrayPos;
            }
        }
        Object[] finalObjectArray = Arrays.copyOf(objectArray, arrayPos);
        return this.jdbcTemplate.query(sql, (RowMapper)rm, finalObjectArray);
    }

    public HolidayData retrieveHoliday(Long holidayId) {
        try {
            HolidayMapper rm = new HolidayMapper();
            String sql = " select " + rm.schema() + " where h.id = ?";
            return (HolidayData)this.jdbcTemplate.queryForObject(sql, (RowMapper)rm, new Object[]{holidayId});
        }
        catch (EmptyResultDataAccessException e) {
            throw new HolidayNotFoundException(holidayId, e);
        }
    }

    public List<EnumOptionData> retrieveRepaymentScheduleUpdationTyeOptions() {
        List<EnumOptionData> repSchUpdationTypeOptions = Arrays.asList(HolidayEnumerations.rescheduleType((RescheduleType)RescheduleType.RESCHEDULETOSPECIFICDATE), HolidayEnumerations.rescheduleType((RescheduleType)RescheduleType.RESCHEDULETONEXTREPAYMENTDATE));
        return repSchUpdationTypeOptions;
    }

    @Generated
    public HolidayReadPlatformServiceImpl(PlatformSecurityContext context, JdbcTemplate jdbcTemplate) {
        this.context = context;
        this.jdbcTemplate = jdbcTemplate;
    }
}

