/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.provisioning.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jakarta.persistence.PersistenceException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.fineract.accounting.glaccount.domain.GLAccount;
import org.apache.fineract.accounting.glaccount.domain.GLAccountRepository;
import org.apache.fineract.accounting.provisioning.service.ProvisioningEntriesReadPlatformService;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.organisation.provisioning.data.ProvisioningCriteriaDefinitionData;
import org.apache.fineract.organisation.provisioning.domain.ProvisioningCriteria;
import org.apache.fineract.organisation.provisioning.domain.ProvisioningCriteriaRepository;
import org.apache.fineract.organisation.provisioning.exception.ProvisioningCategoryNotFoundException;
import org.apache.fineract.organisation.provisioning.exception.ProvisioningCriteriaCannotBeDeletedException;
import org.apache.fineract.organisation.provisioning.exception.ProvisioningCriteriaNotFoundException;
import org.apache.fineract.organisation.provisioning.serialization.ProvisioningCriteriaDefinitionJsonDeserializer;
import org.apache.fineract.organisation.provisioning.service.ProvisioningCriteriaAssembler;
import org.apache.fineract.organisation.provisioning.service.ProvisioningCriteriaWritePlatformService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.jpa.JpaSystemException;

public class ProvisioningCriteriaWritePlatformServiceJpaRepositoryImpl
implements ProvisioningCriteriaWritePlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProvisioningCriteriaWritePlatformServiceJpaRepositoryImpl.class);
    private final ProvisioningCriteriaDefinitionJsonDeserializer fromApiJsonDeserializer;
    private final ProvisioningCriteriaAssembler provisioningCriteriaAssembler;
    private final ProvisioningCriteriaRepository provisioningCriteriaRepository;
    private final FromJsonHelper fromApiJsonHelper;
    private final GLAccountRepository glAccountRepository;
    private final ProvisioningEntriesReadPlatformService provisioningEntriesReadPlatformService;

    public CommandProcessingResult createProvisioningCriteria(JsonCommand command) {
        try {
            this.fromApiJsonDeserializer.validateForCreate(command.json());
            ProvisioningCriteria provisioningCriteria = this.provisioningCriteriaAssembler.fromParsedJson(command.parsedJson());
            this.provisioningCriteriaRepository.saveAndFlush((Object)provisioningCriteria);
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)provisioningCriteria.getId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    public CommandProcessingResult deleteProvisioningCriteria(Long criteriaId) {
        this.provisioningCriteriaRepository.findById((Object)criteriaId).orElseThrow(() -> new ProvisioningCriteriaNotFoundException(criteriaId));
        if (this.provisioningEntriesReadPlatformService.retrieveProvisioningEntryDataByCriteriaId(criteriaId) != null) {
            throw new ProvisioningCriteriaCannotBeDeletedException(criteriaId);
        }
        this.provisioningCriteriaRepository.deleteById((Object)criteriaId);
        return new CommandProcessingResultBuilder().withEntityId(criteriaId).build();
    }

    public CommandProcessingResult updateProvisioningCriteria(Long criteriaId, JsonCommand command) {
        try {
            this.fromApiJsonDeserializer.validateForUpdate(command.json());
            ProvisioningCriteria provisioningCriteria = this.provisioningCriteriaRepository.findById((Object)criteriaId).orElse(null);
            if (provisioningCriteria == null) {
                throw new ProvisioningCategoryNotFoundException(criteriaId);
            }
            List products = this.provisioningCriteriaAssembler.parseLoanProducts(command.parsedJson());
            Map changes = provisioningCriteria.update(command, products);
            if (!changes.isEmpty()) {
                this.updateProvisioningCriteriaDefinitions(provisioningCriteria, command);
                this.provisioningCriteriaRepository.saveAndFlush((Object)provisioningCriteria);
            }
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)provisioningCriteria.getId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    private void updateProvisioningCriteriaDefinitions(ProvisioningCriteria provisioningCriteria, JsonCommand command) {
        Locale locale = this.fromApiJsonHelper.extractLocaleParameter(command.parsedJson().getAsJsonObject());
        JsonArray jsonProvisioningCriteria = this.fromApiJsonHelper.extractJsonArrayNamed("definitions", command.parsedJson());
        for (JsonElement element : jsonProvisioningCriteria) {
            JsonObject jsonObject = element.getAsJsonObject();
            Long id = this.fromApiJsonHelper.extractLongNamed("id", (JsonElement)jsonObject);
            Long categoryId = this.fromApiJsonHelper.extractLongNamed("categoryId", (JsonElement)jsonObject);
            Long minimumAge = this.fromApiJsonHelper.extractLongNamed("minAge", (JsonElement)jsonObject);
            Long maximumAge = this.fromApiJsonHelper.extractLongNamed("maxAge", (JsonElement)jsonObject);
            BigDecimal provisioningpercentage = this.fromApiJsonHelper.extractBigDecimalNamed("provisioningPercentage", (JsonElement)jsonObject, locale);
            Long liabilityAccountId = this.fromApiJsonHelper.extractLongNamed("liabilityAccount", (JsonElement)jsonObject);
            Long expenseAccountId = this.fromApiJsonHelper.extractLongNamed("expenseAccount", (JsonElement)jsonObject);
            GLAccount liabilityAccount = this.glAccountRepository.findById((Object)liabilityAccountId).orElse(null);
            GLAccount expenseAccount = this.glAccountRepository.findById((Object)expenseAccountId).orElse(null);
            String categoryName = null;
            String liabilityAccountName = null;
            String expenseAccountName = null;
            ProvisioningCriteriaDefinitionData data = new ProvisioningCriteriaDefinitionData().setId(id).setCategoryId(categoryId).setCategoryName(categoryName).setMinAge(minimumAge).setMaxAge(maximumAge).setProvisioningPercentage(provisioningpercentage).setLiabilityAccount((Long)liabilityAccount.getId()).setLiabilityCode(liabilityAccount.getGlCode()).setLiabilityName(liabilityAccountName).setExpenseAccount((Long)expenseAccount.getId()).setExpenseCode(expenseAccount.getGlCode()).setExpenseName(expenseAccountName);
            provisioningCriteria.update(data, liabilityAccount, expenseAccount);
        }
    }

    private void handleDataIntegrityIssues(JsonCommand command, Throwable realCause, Exception dve) {
        if (realCause.getMessage().contains("criteria_name")) {
            String name = command.stringValueOfParameterNamed("criteria_name");
            throw new PlatformDataIntegrityException("error.msg.provisioning.duplicate.criterianame", "Provisioning Criteria with name `" + name + "` already exists", "category name", new Object[]{name});
        }
        if (realCause.getMessage().contains("product_id")) {
            throw new PlatformDataIntegrityException("error.msg.provisioning.product.id(s).already.associated.existing.criteria", "The selected products already associated with another Provisioning Criteria", new Object[0]);
        }
        log.error("Error occured.", (Throwable)dve);
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.provisioning.unknown.data.integrity.issue", (String)("Unknown data integrity issue with resource: " + realCause.getMessage()));
    }

    @Generated
    public ProvisioningCriteriaWritePlatformServiceJpaRepositoryImpl(ProvisioningCriteriaDefinitionJsonDeserializer fromApiJsonDeserializer, ProvisioningCriteriaAssembler provisioningCriteriaAssembler, ProvisioningCriteriaRepository provisioningCriteriaRepository, FromJsonHelper fromApiJsonHelper, GLAccountRepository glAccountRepository, ProvisioningEntriesReadPlatformService provisioningEntriesReadPlatformService) {
        this.fromApiJsonDeserializer = fromApiJsonDeserializer;
        this.provisioningCriteriaAssembler = provisioningCriteriaAssembler;
        this.provisioningCriteriaRepository = provisioningCriteriaRepository;
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.glAccountRepository = glAccountRepository;
        this.provisioningEntriesReadPlatformService = provisioningEntriesReadPlatformService;
    }
}

