/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.account.domain;

public enum AccountAssociationType {
    INVALID(Integer.valueOf(0), "accountAssociationType.invalid"),
    LINKED_ACCOUNT_ASSOCIATION(Integer.valueOf(1), "accountAssociationType.loan.account.association"),
    GUARANTOR_ACCOUNT_ASSOCIATION(Integer.valueOf(2), "accountAssociationType.guarantor.account.association");

    private final Integer value;
    private final String code;

    public static AccountAssociationType fromInt(Integer statusValue) {
        AccountAssociationType enumeration = INVALID;
        switch (statusValue) {
            case 1: {
                enumeration = LINKED_ACCOUNT_ASSOCIATION;
                break;
            }
            case 2: {
                enumeration = GUARANTOR_ACCOUNT_ASSOCIATION;
            }
        }
        return enumeration;
    }

    private AccountAssociationType(Integer value, String code) {
        this.value = value;
        this.code = code;
    }

    public boolean hasStateOf(AccountAssociationType state) {
        return this.value.equals(state.getValue());
    }

    public Integer getValue() {
        return this.value;
    }

    public String getCode() {
        return this.code;
    }

    public boolean isLinkedAccountAssociation() {
        return this.value.equals(LINKED_ACCOUNT_ASSOCIATION.getValue());
    }

    public boolean isGuarantorAccountAssociation() {
        return this.value.equals(GUARANTOR_ACCOUNT_ASSOCIATION.getValue());
    }
}

