/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.account.service;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.exception.GeneralPlatformDomainRuleException;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.portfolio.account.PortfolioAccountType;
import org.apache.fineract.portfolio.account.data.AccountTransferDTO;
import org.apache.fineract.portfolio.account.data.AccountTransfersDataValidator;
import org.apache.fineract.portfolio.account.domain.AccountTransferAssembler;
import org.apache.fineract.portfolio.account.domain.AccountTransferDetailRepository;
import org.apache.fineract.portfolio.account.domain.AccountTransferDetails;
import org.apache.fineract.portfolio.account.domain.AccountTransferRepository;
import org.apache.fineract.portfolio.account.domain.AccountTransferTransaction;
import org.apache.fineract.portfolio.account.domain.AccountTransferType;
import org.apache.fineract.portfolio.account.exception.DifferentCurrenciesException;
import org.apache.fineract.portfolio.account.service.AccountTransfersWritePlatformService;
import org.apache.fineract.portfolio.loanaccount.data.HolidayDetailDTO;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanAccountDomainService;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionType;
import org.apache.fineract.portfolio.loanaccount.exception.InvalidPaidInAdvanceAmountException;
import org.apache.fineract.portfolio.loanaccount.service.LoanAssembler;
import org.apache.fineract.portfolio.loanaccount.service.LoanReadPlatformService;
import org.apache.fineract.portfolio.paymentdetail.domain.PaymentDetail;
import org.apache.fineract.portfolio.savings.SavingsTransactionBooleanValues;
import org.apache.fineract.portfolio.savings.domain.GSIMRepositoy;
import org.apache.fineract.portfolio.savings.domain.GroupSavingsIndividualMonitoring;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountAssembler;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountTransaction;
import org.apache.fineract.portfolio.savings.service.SavingsAccountDomainService;
import org.apache.fineract.portfolio.savings.service.SavingsAccountWritePlatformService;
import org.springframework.transaction.annotation.Transactional;

public class AccountTransfersWritePlatformServiceImpl
implements AccountTransfersWritePlatformService {
    private final AccountTransfersDataValidator accountTransfersDataValidator;
    private final AccountTransferAssembler accountTransferAssembler;
    private final AccountTransferRepository accountTransferRepository;
    private final SavingsAccountAssembler savingsAccountAssembler;
    private final SavingsAccountDomainService savingsAccountDomainService;
    private final LoanAssembler loanAccountAssembler;
    private final LoanAccountDomainService loanAccountDomainService;
    private final SavingsAccountWritePlatformService savingsAccountWritePlatformService;
    private final AccountTransferDetailRepository accountTransferDetailRepository;
    private final LoanReadPlatformService loanReadPlatformService;
    private final GSIMRepositoy gsimRepository;
    private final ConfigurationDomainService configurationDomainService;
    private final ExternalIdFactory externalIdFactory;
    private final FineractProperties fineractProperties;

    @Transactional
    public CommandProcessingResult create(JsonCommand command) {
        boolean isRegularTransaction = true;
        this.accountTransfersDataValidator.validate(command);
        LocalDate transactionDate = command.localDateValueOfParameterNamed("transferDate");
        BigDecimal transactionAmount = command.bigDecimalValueOfParameterNamed("transferAmount");
        Locale locale = command.extractLocale();
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
        Integer fromAccountTypeId = command.integerValueSansLocaleOfParameterNamed("fromAccountType");
        PortfolioAccountType fromAccountType = PortfolioAccountType.fromInt((Integer)fromAccountTypeId);
        Integer toAccountTypeId = command.integerValueSansLocaleOfParameterNamed("toAccountType");
        PortfolioAccountType toAccountType = PortfolioAccountType.fromInt((Integer)toAccountTypeId);
        PaymentDetail paymentDetail = null;
        Long fromSavingsAccountId = null;
        Long transferDetailId = null;
        boolean isInterestTransfer = false;
        boolean isAccountTransfer = true;
        Long fromLoanAccountId = null;
        boolean isWithdrawBalance = false;
        boolean backdatedTxnsAllowedTill = false;
        if (this.isSavingsToSavingsAccountTransfer(fromAccountType, toAccountType)) {
            fromSavingsAccountId = command.longValueOfParameterNamed("fromAccountId");
            fromSavingsAccount = this.savingsAccountAssembler.assembleFrom(fromSavingsAccountId, false);
            SavingsTransactionBooleanValues transactionBooleanValues = new SavingsTransactionBooleanValues(isAccountTransfer, isRegularTransaction, fromSavingsAccount.isWithdrawalFeeApplicableForTransfer(), isInterestTransfer, isWithdrawBalance);
            SavingsAccountTransaction withdrawal = this.savingsAccountDomainService.handleWithdrawal(fromSavingsAccount, fmt, transactionDate, transactionAmount, paymentDetail, transactionBooleanValues, false);
            Long toSavingsId = command.longValueOfParameterNamed("toAccountId");
            SavingsAccount toSavingsAccount = this.savingsAccountAssembler.assembleFrom(toSavingsId, false);
            SavingsAccountTransaction deposit = this.savingsAccountDomainService.handleDeposit(toSavingsAccount, fmt, transactionDate, transactionAmount, paymentDetail, isAccountTransfer, isRegularTransaction, false);
            if (!fromSavingsAccount.getCurrency().getCode().equals(toSavingsAccount.getCurrency().getCode())) {
                throw new DifferentCurrenciesException(fromSavingsAccount.getCurrency().getCode(), toSavingsAccount.getCurrency().getCode());
            }
            AccountTransferDetails accountTransferDetails = this.accountTransferAssembler.assembleSavingsToSavingsTransfer(command, fromSavingsAccount, toSavingsAccount, withdrawal, deposit);
            this.accountTransferDetailRepository.saveAndFlush((Object)accountTransferDetails);
            transferDetailId = (Long)accountTransferDetails.getId();
        } else if (this.isSavingsToLoanAccountTransfer(fromAccountType, toAccountType)) {
            fromSavingsAccountId = command.longValueOfParameterNamed("fromAccountId");
            fromSavingsAccount = this.savingsAccountAssembler.assembleFrom(fromSavingsAccountId, false);
            SavingsTransactionBooleanValues transactionBooleanValues = new SavingsTransactionBooleanValues(isAccountTransfer, isRegularTransaction, fromSavingsAccount.isWithdrawalFeeApplicableForTransfer(), isInterestTransfer, isWithdrawBalance);
            SavingsAccountTransaction withdrawal = this.savingsAccountDomainService.handleWithdrawal(fromSavingsAccount, fmt, transactionDate, transactionAmount, paymentDetail, transactionBooleanValues, false);
            Long toLoanAccountId = command.longValueOfParameterNamed("toAccountId");
            Loan toLoanAccount = this.loanAccountAssembler.assembleFrom(toLoanAccountId);
            Boolean isHolidayValidationDone = false;
            HolidayDetailDTO holidayDetailDto = null;
            boolean isRecoveryRepayment = false;
            String chargeRefundChargeType = null;
            ExternalId externalId = this.externalIdFactory.create();
            LoanTransaction loanRepaymentTransaction = this.loanAccountDomainService.makeRepayment(LoanTransactionType.REPAYMENT, toLoanAccount, transactionDate, transactionAmount, paymentDetail, null, externalId, false, chargeRefundChargeType, isAccountTransfer, holidayDetailDto, isHolidayValidationDone);
            toLoanAccount = loanRepaymentTransaction.getLoan();
            AccountTransferDetails accountTransferDetails = this.accountTransferAssembler.assembleSavingsToLoanTransfer(command, fromSavingsAccount, toLoanAccount, withdrawal, loanRepaymentTransaction);
            this.accountTransferDetailRepository.saveAndFlush((Object)accountTransferDetails);
            transferDetailId = (Long)accountTransferDetails.getId();
        } else if (this.isLoanToSavingsAccountTransfer(fromAccountType, toAccountType)) {
            fromLoanAccountId = command.longValueOfParameterNamed("fromAccountId");
            Loan fromLoanAccount = this.loanAccountAssembler.assembleFrom(fromLoanAccountId);
            ExternalId externalId = this.externalIdFactory.create();
            LoanTransaction loanRefundTransaction = this.loanAccountDomainService.makeRefund(fromLoanAccountId, new CommandProcessingResultBuilder(), transactionDate, transactionAmount, paymentDetail, null, externalId);
            Long toSavingsAccountId = command.longValueOfParameterNamed("toAccountId");
            SavingsAccount toSavingsAccount = this.savingsAccountAssembler.assembleFrom(toSavingsAccountId, false);
            SavingsAccountTransaction deposit = this.savingsAccountDomainService.handleDeposit(toSavingsAccount, fmt, transactionDate, transactionAmount, paymentDetail, isAccountTransfer, isRegularTransaction, false);
            AccountTransferDetails accountTransferDetails = this.accountTransferAssembler.assembleLoanToSavingsTransfer(command, fromLoanAccount, toSavingsAccount, deposit, loanRefundTransaction);
            this.accountTransferDetailRepository.saveAndFlush((Object)accountTransferDetails);
            transferDetailId = (Long)accountTransferDetails.getId();
        }
        CommandProcessingResultBuilder builder = new CommandProcessingResultBuilder().withEntityId(transferDetailId);
        if (fromAccountType.isSavingsAccount()) {
            builder.withSavingsId(fromSavingsAccountId);
        }
        if (fromAccountType.isLoanAccount()) {
            builder.withLoanId(fromLoanAccountId);
        }
        return builder.build();
    }

    @Transactional
    public void reverseTransfersWithFromAccountType(Long accountNumber, PortfolioAccountType accountTypeId) {
        List accountTransfers = null;
        if (accountTypeId.isLoanAccount()) {
            accountTransfers = this.accountTransferRepository.findByFromLoanId(accountNumber);
        }
        if (accountTransfers != null && !accountTransfers.isEmpty()) {
            this.undoTransactions(accountTransfers);
        }
    }

    @Transactional
    public void reverseTransfersWithFromAccountTransactions(Collection<Long> fromTransactionIds, PortfolioAccountType accountTypeId) {
        ArrayList accountTransfers = new ArrayList();
        if (accountTypeId.isLoanAccount()) {
            List partitions = Lists.partition(fromTransactionIds.stream().toList(), (int)this.fineractProperties.getQuery().getInClauseParameterSizeLimit());
            partitions.forEach(partition -> accountTransfers.addAll(this.accountTransferRepository.findByFromLoanTransactions((Collection)partition)));
        }
        if (!accountTransfers.isEmpty()) {
            this.undoTransactions(accountTransfers);
        }
    }

    @Transactional
    public void reverseAllTransactions(Long accountId, PortfolioAccountType accountTypeId) {
        List accountTransfers = null;
        if (accountTypeId.isLoanAccount()) {
            accountTransfers = this.accountTransferRepository.findAllByLoanId(accountId);
        }
        if (accountTransfers != null && !accountTransfers.isEmpty()) {
            this.undoTransactions(accountTransfers);
        }
    }

    private void undoTransactions(List<AccountTransferTransaction> accountTransfers) {
        for (AccountTransferTransaction accountTransfer : accountTransfers) {
            if (accountTransfer.getFromLoanTransaction() != null) {
                this.loanAccountDomainService.reverseTransfer(accountTransfer.getFromLoanTransaction());
            }
            if (accountTransfer.getToLoanTransaction() != null) {
                this.loanAccountDomainService.reverseTransfer(accountTransfer.getToLoanTransaction());
            }
            if (accountTransfer.getFromTransaction() != null) {
                this.savingsAccountWritePlatformService.undoTransaction((Long)accountTransfer.accountTransferDetails().fromSavingsAccount().getId(), (Long)accountTransfer.getFromTransaction().getId(), true);
            }
            if (accountTransfer.getToSavingsTransaction() != null) {
                this.savingsAccountWritePlatformService.undoTransaction((Long)accountTransfer.accountTransferDetails().toSavingsAccount().getId(), (Long)accountTransfer.getToSavingsTransaction().getId(), true);
            }
            accountTransfer.reverse();
            this.accountTransferRepository.save((Object)accountTransfer);
        }
    }

    @Transactional
    public Long transferFunds(AccountTransferDTO accountTransferDTO) {
        Long transferTransactionId = null;
        boolean isAccountTransfer = true;
        boolean isRegularTransaction = accountTransferDTO.isRegularTransaction();
        boolean backdatedTxnsAllowedTill = false;
        AccountTransferDetails accountTransferDetails = accountTransferDTO.getAccountTransferDetails();
        if (this.isSavingsToLoanAccountTransfer(accountTransferDTO.getFromAccountType(), accountTransferDTO.getToAccountType())) {
            LoanTransaction loanTransaction;
            SavingsAccount fromSavingsAccount = null;
            Loan toLoanAccount = null;
            if (accountTransferDetails == null) {
                if (accountTransferDTO.getFromSavingsAccount() == null) {
                    fromSavingsAccount = this.savingsAccountAssembler.assembleFrom(accountTransferDTO.getFromAccountId(), false);
                } else {
                    fromSavingsAccount = accountTransferDTO.getFromSavingsAccount();
                    this.savingsAccountAssembler.setHelpers(fromSavingsAccount);
                }
                toLoanAccount = accountTransferDTO.getLoan() == null ? this.loanAccountAssembler.assembleFrom(accountTransferDTO.getToAccountId()) : accountTransferDTO.getLoan();
            } else {
                fromSavingsAccount = accountTransferDetails.fromSavingsAccount();
                this.savingsAccountAssembler.setHelpers(fromSavingsAccount);
                toLoanAccount = accountTransferDetails.toLoanAccount();
            }
            SavingsTransactionBooleanValues transactionBooleanValues = new SavingsTransactionBooleanValues(true, isRegularTransaction, fromSavingsAccount.isWithdrawalFeeApplicableForTransfer(), AccountTransferType.fromInt((Integer)accountTransferDTO.getTransferType()).isInterestTransfer(), accountTransferDTO.isExceptionForBalanceCheck().booleanValue());
            SavingsAccountTransaction withdrawal = this.savingsAccountDomainService.handleWithdrawal(fromSavingsAccount, accountTransferDTO.getFmt(), accountTransferDTO.getTransactionDate(), accountTransferDTO.getTransactionAmount(), accountTransferDTO.getPaymentDetail(), transactionBooleanValues, false);
            ExternalId txnExternalId = accountTransferDTO.getTxnExternalId();
            ExternalId externalId = this.externalIdFactory.create(txnExternalId.getValue());
            if (AccountTransferType.fromInt((Integer)accountTransferDTO.getTransferType()).isChargePayment()) {
                loanTransaction = this.loanAccountDomainService.makeChargePayment(toLoanAccount, accountTransferDTO.getChargeId(), accountTransferDTO.getTransactionDate(), accountTransferDTO.getTransactionAmount(), accountTransferDTO.getPaymentDetail(), null, externalId, accountTransferDTO.getToTransferType(), accountTransferDTO.getLoanInstallmentNumber());
            } else if (AccountTransferType.fromInt((Integer)accountTransferDTO.getTransferType()).isLoanDownPayment()) {
                boolean isRecoveryRepayment = false;
                Boolean isHolidayValidationDone = false;
                HolidayDetailDTO holidayDetailDto = null;
                String chargeRefundChargeType = null;
                loanTransaction = this.loanAccountDomainService.makeRepayment(LoanTransactionType.DOWN_PAYMENT, toLoanAccount, accountTransferDTO.getTransactionDate(), accountTransferDTO.getTransactionAmount(), accountTransferDTO.getPaymentDetail(), null, externalId, false, chargeRefundChargeType, true, holidayDetailDto, isHolidayValidationDone);
                toLoanAccount = loanTransaction.getLoan();
            } else {
                boolean isRecoveryRepayment = false;
                Boolean isHolidayValidationDone = false;
                HolidayDetailDTO holidayDetailDto = null;
                String chargeRefundChargeType = null;
                loanTransaction = this.loanAccountDomainService.makeRepayment(LoanTransactionType.REPAYMENT, toLoanAccount, accountTransferDTO.getTransactionDate(), accountTransferDTO.getTransactionAmount(), accountTransferDTO.getPaymentDetail(), null, externalId, false, chargeRefundChargeType, true, holidayDetailDto, isHolidayValidationDone);
                toLoanAccount = loanTransaction.getLoan();
            }
            accountTransferDetails = this.accountTransferAssembler.assembleSavingsToLoanTransfer(accountTransferDTO, fromSavingsAccount, toLoanAccount, withdrawal, loanTransaction);
            this.accountTransferDetailRepository.saveAndFlush((Object)accountTransferDetails);
            transferTransactionId = (Long)accountTransferDetails.getId();
        } else if (this.isSavingsToSavingsAccountTransfer(accountTransferDTO.getFromAccountType(), accountTransferDTO.getToAccountType())) {
            SavingsAccount toSavingsAccount;
            SavingsAccount fromSavingsAccount;
            if (accountTransferDetails == null) {
                if (accountTransferDTO.getFromSavingsAccount() == null) {
                    fromSavingsAccount = this.savingsAccountAssembler.assembleFrom(accountTransferDTO.getFromAccountId(), false);
                } else {
                    fromSavingsAccount = accountTransferDTO.getFromSavingsAccount();
                    this.savingsAccountAssembler.setHelpers(fromSavingsAccount);
                }
                if (accountTransferDTO.getToSavingsAccount() == null) {
                    toSavingsAccount = this.savingsAccountAssembler.assembleFrom(accountTransferDTO.getToAccountId(), false);
                } else {
                    toSavingsAccount = accountTransferDTO.getToSavingsAccount();
                    this.savingsAccountAssembler.setHelpers(toSavingsAccount);
                }
            } else {
                fromSavingsAccount = accountTransferDetails.fromSavingsAccount();
                this.savingsAccountAssembler.setHelpers(fromSavingsAccount);
                toSavingsAccount = accountTransferDetails.toSavingsAccount();
                this.savingsAccountAssembler.setHelpers(toSavingsAccount);
            }
            SavingsTransactionBooleanValues transactionBooleanValues = new SavingsTransactionBooleanValues(true, isRegularTransaction, fromSavingsAccount.isWithdrawalFeeApplicableForTransfer(), AccountTransferType.fromInt((Integer)accountTransferDTO.getTransferType()).isInterestTransfer(), accountTransferDTO.isExceptionForBalanceCheck().booleanValue());
            LocalDate transactionDate = accountTransferDTO.getTransactionDate();
            if (this.configurationDomainService.isSavingsInterestPostingAtCurrentPeriodEnd() && this.configurationDomainService.isNextDayFixedDepositInterestTransferEnabledForPeriodEnd() && AccountTransferType.fromInt((Integer)accountTransferDTO.getTransferType()).isInterestTransfer()) {
                transactionDate = transactionDate.plusDays(1L);
            }
            SavingsAccountTransaction withdrawal = this.savingsAccountDomainService.handleWithdrawal(fromSavingsAccount, accountTransferDTO.getFmt(), transactionDate, accountTransferDTO.getTransactionAmount(), accountTransferDTO.getPaymentDetail(), transactionBooleanValues, false);
            SavingsAccountTransaction deposit = this.savingsAccountDomainService.handleDeposit(toSavingsAccount, accountTransferDTO.getFmt(), transactionDate, accountTransferDTO.getTransactionAmount(), accountTransferDTO.getPaymentDetail(), true, isRegularTransaction, false);
            accountTransferDetails = this.accountTransferAssembler.assembleSavingsToSavingsTransfer(accountTransferDTO, fromSavingsAccount, toSavingsAccount, withdrawal, deposit);
            this.accountTransferDetailRepository.saveAndFlush((Object)accountTransferDetails);
            transferTransactionId = (Long)accountTransferDetails.getId();
        } else if (this.isLoanToSavingsAccountTransfer(accountTransferDTO.getFromAccountType(), accountTransferDTO.getToAccountType())) {
            Loan fromLoanAccount = null;
            SavingsAccount toSavingsAccount = null;
            if (accountTransferDetails == null) {
                fromLoanAccount = accountTransferDTO.getLoan() == null ? this.loanAccountAssembler.assembleFrom(accountTransferDTO.getFromAccountId()) : accountTransferDTO.getLoan();
                toSavingsAccount = this.savingsAccountAssembler.assembleFrom(accountTransferDTO.getToAccountId(), false);
            } else {
                fromLoanAccount = accountTransferDetails.fromLoanAccount();
                toSavingsAccount = accountTransferDetails.toSavingsAccount();
                this.savingsAccountAssembler.setHelpers(toSavingsAccount);
            }
            LoanTransaction loanTransaction = null;
            ExternalId txnExternalId = accountTransferDTO.getTxnExternalId();
            ExternalId externalId = this.externalIdFactory.create(txnExternalId.getValue());
            loanTransaction = LoanTransactionType.DISBURSEMENT.getValue().equals(accountTransferDTO.getFromTransferType()) ? this.loanAccountDomainService.makeDisburseTransaction(accountTransferDTO.getFromAccountId(), accountTransferDTO.getTransactionDate(), accountTransferDTO.getTransactionAmount(), accountTransferDTO.getPaymentDetail(), accountTransferDTO.getNoteText(), externalId) : this.loanAccountDomainService.makeRefund(accountTransferDTO.getFromAccountId(), new CommandProcessingResultBuilder(), accountTransferDTO.getTransactionDate(), accountTransferDTO.getTransactionAmount(), accountTransferDTO.getPaymentDetail(), accountTransferDTO.getNoteText(), externalId);
            SavingsAccountTransaction deposit = this.savingsAccountDomainService.handleDeposit(toSavingsAccount, accountTransferDTO.getFmt(), accountTransferDTO.getTransactionDate(), accountTransferDTO.getTransactionAmount(), accountTransferDTO.getPaymentDetail(), true, isRegularTransaction, false);
            accountTransferDetails = this.accountTransferAssembler.assembleLoanToSavingsTransfer(accountTransferDTO, fromLoanAccount, toSavingsAccount, deposit, loanTransaction);
            this.accountTransferDetailRepository.saveAndFlush((Object)accountTransferDetails);
            transferTransactionId = (Long)accountTransferDetails.getId();
            if (toSavingsAccount.getGsim() != null) {
                GroupSavingsIndividualMonitoring gsim = (GroupSavingsIndividualMonitoring)this.gsimRepository.findById((Object)((Long)toSavingsAccount.getGsim().getId())).orElseThrow();
                BigDecimal currentBalance = gsim.getParentDeposit();
                BigDecimal newBalance = currentBalance.add(accountTransferDTO.getTransactionAmount());
                gsim.setParentDeposit(newBalance);
                this.gsimRepository.save((Object)gsim);
            }
        } else {
            throw new GeneralPlatformDomainRuleException("error.msg.accounttransfer.loan.to.loan.not.supported", "Account transfer from loan to another loan is not supported", new Object[0]);
        }
        return transferTransactionId;
    }

    public AccountTransferDetails repayLoanWithTopup(AccountTransferDTO accountTransferDTO) {
        boolean isAccountTransfer = true;
        Loan fromLoanAccount = null;
        fromLoanAccount = accountTransferDTO.getFromLoan() == null ? this.loanAccountAssembler.assembleFrom(accountTransferDTO.getFromAccountId()) : accountTransferDTO.getFromLoan();
        Loan toLoanAccount = null;
        toLoanAccount = accountTransferDTO.getToLoan() == null ? this.loanAccountAssembler.assembleFrom(accountTransferDTO.getToAccountId()) : accountTransferDTO.getToLoan();
        ExternalId externalIdForDisbursement = accountTransferDTO.getTxnExternalId();
        LoanTransaction disburseTransaction = this.loanAccountDomainService.makeDisburseTransaction(accountTransferDTO.getFromAccountId(), accountTransferDTO.getTransactionDate(), accountTransferDTO.getTransactionAmount(), accountTransferDTO.getPaymentDetail(), accountTransferDTO.getNoteText(), externalIdForDisbursement, true);
        String chargeRefundChargeType = null;
        ExternalId externalIdForRepayment = this.externalIdFactory.create();
        LoanTransaction repayTransaction = this.loanAccountDomainService.makeRepayment(LoanTransactionType.REPAYMENT, toLoanAccount, accountTransferDTO.getTransactionDate(), accountTransferDTO.getTransactionAmount(), accountTransferDTO.getPaymentDetail(), null, externalIdForRepayment, false, chargeRefundChargeType, true, null, Boolean.valueOf(false), true);
        AccountTransferDetails accountTransferDetails = this.accountTransferAssembler.assembleLoanToLoanTransfer(accountTransferDTO, fromLoanAccount, toLoanAccount, disburseTransaction, repayTransaction);
        this.accountTransferDetailRepository.saveAndFlush((Object)accountTransferDetails);
        return accountTransferDetails;
    }

    private boolean isLoanToSavingsAccountTransfer(PortfolioAccountType fromAccountType, PortfolioAccountType toAccountType) {
        return fromAccountType.isLoanAccount() && toAccountType.isSavingsAccount();
    }

    private boolean isSavingsToLoanAccountTransfer(PortfolioAccountType fromAccountType, PortfolioAccountType toAccountType) {
        return fromAccountType.isSavingsAccount() && toAccountType.isLoanAccount();
    }

    private boolean isSavingsToSavingsAccountTransfer(PortfolioAccountType fromAccountType, PortfolioAccountType toAccountType) {
        return fromAccountType.isSavingsAccount() && toAccountType.isSavingsAccount();
    }

    @Transactional
    public CommandProcessingResult refundByTransfer(JsonCommand command) {
        this.accountTransfersDataValidator.validate(command);
        LocalDate transactionDate = command.localDateValueOfParameterNamed("transferDate");
        BigDecimal transactionAmount = command.bigDecimalValueOfParameterNamed("transferAmount");
        Locale locale = command.extractLocale();
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
        PaymentDetail paymentDetail = null;
        Long transferTransactionId = null;
        Long fromLoanAccountId = command.longValueOfParameterNamed("fromAccountId");
        Loan fromLoanAccount = this.loanAccountAssembler.assembleFrom(fromLoanAccountId);
        BigDecimal overpaid = this.loanReadPlatformService.retrieveTotalPaidInAdvance(fromLoanAccountId).getPaidInAdvance();
        boolean backdatedTxnsAllowedTill = false;
        if (overpaid == null || overpaid.compareTo(BigDecimal.ZERO) == 0 || transactionAmount.floatValue() > overpaid.floatValue()) {
            if (overpaid == null) {
                overpaid = BigDecimal.ZERO;
            }
            throw new InvalidPaidInAdvanceAmountException(overpaid.toPlainString());
        }
        ExternalId externalId = this.externalIdFactory.create();
        LoanTransaction loanRefundTransaction = this.loanAccountDomainService.makeRefundForActiveLoan(fromLoanAccountId, new CommandProcessingResultBuilder(), transactionDate, transactionAmount, paymentDetail, null, externalId);
        Long toSavingsAccountId = command.longValueOfParameterNamed("toAccountId");
        SavingsAccount toSavingsAccount = this.savingsAccountAssembler.assembleFrom(toSavingsAccountId, false);
        SavingsAccountTransaction deposit = this.savingsAccountDomainService.handleDeposit(toSavingsAccount, fmt, transactionDate, transactionAmount, paymentDetail, true, true, false);
        AccountTransferDetails accountTransferDetails = this.accountTransferAssembler.assembleLoanToSavingsTransfer(command, fromLoanAccount, toSavingsAccount, deposit, loanRefundTransaction);
        this.accountTransferDetailRepository.saveAndFlush((Object)accountTransferDetails);
        transferTransactionId = (Long)accountTransferDetails.getId();
        CommandProcessingResultBuilder builder = new CommandProcessingResultBuilder().withEntityId(transferTransactionId);
        builder.withSavingsId(toSavingsAccountId);
        return builder.build();
    }

    @Generated
    public AccountTransfersWritePlatformServiceImpl(AccountTransfersDataValidator accountTransfersDataValidator, AccountTransferAssembler accountTransferAssembler, AccountTransferRepository accountTransferRepository, SavingsAccountAssembler savingsAccountAssembler, SavingsAccountDomainService savingsAccountDomainService, LoanAssembler loanAccountAssembler, LoanAccountDomainService loanAccountDomainService, SavingsAccountWritePlatformService savingsAccountWritePlatformService, AccountTransferDetailRepository accountTransferDetailRepository, LoanReadPlatformService loanReadPlatformService, GSIMRepositoy gsimRepository, ConfigurationDomainService configurationDomainService, ExternalIdFactory externalIdFactory, FineractProperties fineractProperties) {
        this.accountTransfersDataValidator = accountTransfersDataValidator;
        this.accountTransferAssembler = accountTransferAssembler;
        this.accountTransferRepository = accountTransferRepository;
        this.savingsAccountAssembler = savingsAccountAssembler;
        this.savingsAccountDomainService = savingsAccountDomainService;
        this.loanAccountAssembler = loanAccountAssembler;
        this.loanAccountDomainService = loanAccountDomainService;
        this.savingsAccountWritePlatformService = savingsAccountWritePlatformService;
        this.accountTransferDetailRepository = accountTransferDetailRepository;
        this.loanReadPlatformService = loanReadPlatformService;
        this.gsimRepository = gsimRepository;
        this.configurationDomainService = configurationDomainService;
        this.externalIdFactory = externalIdFactory;
        this.fineractProperties = fineractProperties;
    }
}

