/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.client.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.bulkimport.service.BulkImportWorkbookPopulatorService;
import org.apache.fineract.infrastructure.bulkimport.service.BulkImportWorkbookService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.UploadRequest;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.exception.UnrecognizedQueryParamException;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.ToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.service.CommandParameterUtil;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.service.SqlValidator;
import org.apache.fineract.portfolio.accountdetails.data.AccountSummaryCollectionData;
import org.apache.fineract.portfolio.accountdetails.service.AccountDetailsReadPlatformService;
import org.apache.fineract.portfolio.client.api.ClientApiConstants;
import org.apache.fineract.portfolio.client.api.ClientsApiResourceSwagger;
import org.apache.fineract.portfolio.client.data.ClientData;
import org.apache.fineract.portfolio.client.exception.ClientNotFoundException;
import org.apache.fineract.portfolio.client.service.ClientReadPlatformService;
import org.apache.fineract.portfolio.client.service.ClientTemplateReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.guarantor.service.GuarantorReadPlatformService;
import org.apache.fineract.portfolio.savings.service.SavingsAccountReadPlatformService;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.springframework.stereotype.Component;

@Path(value="/v1/clients")
@Component
@Tag(name="Client", description="Clients are people and businesses that have applied (or may apply) to an MFI for loans.\n\nClients can be created in Pending or straight into Active state.")
public class ClientsApiResource {
    private final PlatformSecurityContext context;
    private final ClientReadPlatformService clientReadPlatformService;
    private final ClientTemplateReadPlatformService clientTemplateReadPlatformService;
    private final ToApiJsonSerializer<ClientData> toApiJsonSerializer;
    private final ToApiJsonSerializer<AccountSummaryCollectionData> clientAccountSummaryToApiJsonSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final AccountDetailsReadPlatformService accountDetailsReadPlatformService;
    private final SavingsAccountReadPlatformService savingsAccountReadPlatformService;
    private final BulkImportWorkbookService bulkImportWorkbookService;
    private final BulkImportWorkbookPopulatorService bulkImportWorkbookPopulatorService;
    private final GuarantorReadPlatformService guarantorReadPlatformService;
    private final SqlValidator sqlValidator;

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Client Details Template", description="This is a convenience resource. It can be useful when building maintenance user interface screens for client applications. The template data returned consists of any or all of:\n\nField Defaults\nAllowed Value Lists\n\nExample Request:\n\nclients/template")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientsApiResourceSwagger.GetClientsTemplateResponse.class))})})
    public String retrieveTemplate(@Context UriInfo uriInfo, @Parameter(description="officeId") @QueryParam(value="officeId") Long officeId, @QueryParam(value="commandParam") @Parameter(description="commandParam") String commandParam, @DefaultValue(value="false") @QueryParam(value="staffInSelectedOfficeOnly") @Parameter(description="staffInSelectedOfficeOnly") boolean staffInSelectedOfficeOnly) {
        this.context.authenticatedUser().validateHasReadPermission("client");
        ClientData clientData = null;
        this.context.authenticatedUser().validateHasReadPermission("client");
        clientData = CommandParameterUtil.is((String)commandParam, (String)"close") ? this.clientReadPlatformService.retrieveAllNarrations("ClientClosureReason") : (CommandParameterUtil.is((String)commandParam, (String)"acceptTransfer") ? this.clientReadPlatformService.retrieveAllNarrations("ClientClosureReason") : (CommandParameterUtil.is((String)commandParam, (String)"reject") ? this.clientReadPlatformService.retrieveAllNarrations("ClientRejectReason") : (CommandParameterUtil.is((String)commandParam, (String)"withdraw") ? this.clientReadPlatformService.retrieveAllNarrations("ClientWithdrawReason") : this.clientTemplateReadPlatformService.retrieveTemplate(officeId, staffInSelectedOfficeOnly))));
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)clientData, ClientApiConstants.CLIENT_RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Clients", description="The list capability of clients can support pagination and sorting.\n\nExample Requests:\n\nclients\n\nclients?fields=displayName,officeName,timeline\n\nclients?offset=10&limit=50\n\nclients?orderBy=displayName&sortOrder=DESC")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientsApiResourceSwagger.GetClientsResponse.class))})})
    public String retrieveAll(@Context UriInfo uriInfo, @QueryParam(value="officeId") @Parameter(description="officeId") Long officeId, @QueryParam(value="externalId") @Parameter(description="externalId") String externalId, @QueryParam(value="displayName") @Parameter(description="displayName") String displayName, @QueryParam(value="firstName") @Parameter(description="firstName") String firstname, @QueryParam(value="lastName") @Parameter(description="lastName") String lastname, @QueryParam(value="status") @Parameter(description="status") String status, @QueryParam(value="underHierarchy") @Parameter(description="underHierarchy") String hierarchy, @QueryParam(value="offset") @Parameter(description="offset") Integer offset, @QueryParam(value="limit") @Parameter(description="limit") Integer limit, @QueryParam(value="orderBy") @Parameter(description="orderBy") String orderBy, @QueryParam(value="sortOrder") @Parameter(description="sortOrder") String sortOrder, @QueryParam(value="orphansOnly") @Parameter(description="orphansOnly") Boolean orphansOnly, @QueryParam(value="legalForm") Integer legalForm) {
        return this.retrieveAll(uriInfo, officeId, externalId, displayName, firstname, lastname, status, legalForm, hierarchy, offset, limit, orderBy, sortOrder, orphansOnly, false);
    }

    @GET
    @Path(value="{clientId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Client", description="Example Requests:\n\nclients/1\n\n\nclients/1?template=true\n\n\nclients/1?fields=id,displayName,officeName")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientsApiResourceSwagger.GetClientsClientIdResponse.class))})})
    public String retrieveOne(@PathParam(value="clientId") @Parameter(description="clientId") Long clientId, @Context UriInfo uriInfo, @DefaultValue(value="false") @QueryParam(value="staffInSelectedOfficeOnly") @Parameter(description="staffInSelectedOfficeOnly") boolean staffInSelectedOfficeOnly) {
        return this.retrieveClient(clientId, null, staffInSelectedOfficeOnly, uriInfo);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a Client", description="Note:\n\n1. You can enter either:firstname/middlename/lastname - for a person (middlename is optional) OR fullname - for a business or organisation (or person known by one name).\n\n2.If address is enable(enable-address=true), then additional field called address has to be passed.\n\nMandatory Fields: firstname and lastname OR fullname, officeId, active=true and activationDate OR active=false, if(address enabled) address\n\nOptional Fields: groupId, externalId, accountNo, staffId, mobileNo, savingsProductId, genderId, clientTypeId, clientClassificationId")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=ClientsApiResourceSwagger.PostClientsRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientsApiResourceSwagger.PostClientsResponse.class))})})
    public String create(@Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createClient().withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @PUT
    @Path(value="{clientId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a Client", description="Note: You can update any of the basic attributes of a client (but not its associations) using this API.\n\nChanging the relationship between a client and its office is not supported through this API. An API specific to handling transfers of clients between offices is available for the same.\n\nThe relationship between a client and a group must be removed through the Groups API.")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=ClientsApiResourceSwagger.PutClientsClientIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientsApiResourceSwagger.PutClientsClientIdResponse.class))})})
    public String update(@Parameter(description="clientId") @PathParam(value="clientId") Long clientId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        return this.updateClient(clientId, null, apiRequestBodyAsJson);
    }

    @DELETE
    @Path(value="{clientId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Delete a Client", description="If a client is in Pending state, you are allowed to Delete it. The delete is a 'hard delete' and cannot be recovered from. Once clients become active or have loans or savings associated with them, you cannot delete the client but you may Close the client if they have left the program.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientsApiResourceSwagger.DeleteClientsClientIdResponse.class))})})
    public String delete(@PathParam(value="clientId") @Parameter(description="clientId") Long clientId) {
        return this.deleteClient(clientId, null);
    }

    @POST
    @Path(value="{clientId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Activate a Client | Close a Client | Reject a Client | Withdraw a Client | Reactivate a Client | UndoReject a Client | UndoWithdraw a Client | Assign a Staff | Unassign a Staff | Update Default Savings Account | Propose a Client Transfer | Withdraw a Client Transfer | Reject a Client Transfer | Accept a Client Transfer | Propose and Accept a Client Transfer", description="Activate a Client:\n\nClients can be created in a Pending state. This API exists to enable client activation (for when a client becomes an approved member of the financial Institution).\n\nIf the client happens to be already active this API will result in an error.\n\nClose a Client:\n\nClients can be closed if they do not have any non-closed loans/savingsAccount. This API exists to close a client .\n\nIf the client have any active loans/savingsAccount this API will result in an error.\n\nReject a Client:\n\nClients can be rejected when client is in pending for activation status.\n\nIf the client is any other status, this API throws an error.\n\nMandatory Fields: rejectionDate, rejectionReasonId\n\nWithdraw a Client:\n\nClient applications can be withdrawn when client is in a pending for activation status.\n\nIf the client is any other status, this API throws an error.\n\nMandatory Fields: withdrawalDate, withdrawalReasonId\n\nReactivate a Client: Clients can be reactivated after they have been closed.\n\nTrying to reactivate a client in any other state throws an error.\n\nMandatory Fields: reactivationDate\n\nUndoReject a Client:\n\nClients can be reactivated after they have been rejected.\n\nTrying to reactivate a client in any other state throws an error.\n\nMandatory Fields: reopenedDateUndoWithdraw a Client:\n\nClients can be reactivated after they have been withdrawn.\n\nTrying to reactivate a client in any other state throws an error.\n\nMandatory Fields: reopenedDate\n\nAssign a Staff:\n\nAllows you to assign a Staff for existed Client.\n\nThe selected Staff should belong to the same office (or an officer higher up in the hierarchy) as the Client he manages.\n\nUnassign a Staff:\n\nAllows you to unassign the Staff assigned to a Client.\n\nUpdate Default Savings Account:\n\nAllows you to modify or assign a default savings account for an existing Client.\n\nThe selected savings account should be one among the existing savings account for a particular customer.\n\nPropose a Client Transfer:\n\nAllows you to propose the transfer of a Client to a different Office.\n\nWithdraw a Client Transfer:\n\nAllows you to withdraw the proposed transfer of a Client to a different Office.\n\nWithdrawal can happen only if the destination Branch (to which the transfer was proposed) has not already accepted the transfer proposal\n\nReject a Client Transfer:\n\nAllows the Destination Branch to reject the proposed Client Transfer.\n\nAccept a Client Transfer:\n\nAllows the Destination Branch to accept the proposed Client Transfer.\n\nThe destination branch may also choose to link this client to a group (in which case, any existing active JLG loan of the client is rescheduled to match the meeting frequency of the group) and loan Officer at the time of accepting the transfer\n\nPropose and Accept a Client Transfer:\n\nAbstraction over the Propose and Accept Client Transfer API's which enable a user with Data Scope over both the Target and Destination Branches to directly transfer a Client to the destination Office.\n\nShowing request/response for 'Reject a Client Transfer'")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=ClientsApiResourceSwagger.PostClientsClientIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientsApiResourceSwagger.PostClientsClientIdResponse.class))})})
    public String activate(@PathParam(value="clientId") @Parameter(description="clientId") Long clientId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        return this.applyCommandOverClient(clientId, null, commandParam, apiRequestBodyAsJson);
    }

    @GET
    @Path(value="{clientId}/accounts")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve client accounts overview", description="An example of how a loan portfolio summary can be provided. This is requested in a specific use case of the community application.\nIt is quite reasonable to add resources like this to simplify User Interface development.\n\nExample Requests:\n \nclients/1/accounts\n\nclients/1/accounts?fields=loanAccounts,savingsAccounts")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientsApiResourceSwagger.GetClientsClientIdAccountsResponse.class))}), @ApiResponse(responseCode="400", description="Bad Request")})
    public String retrieveAssociatedAccounts(@PathParam(value="clientId") @Parameter(description="clientId") Long clientId, @Context UriInfo uriInfo) {
        return this.retrieveClientAccounts(clientId, null, uriInfo);
    }

    @GET
    @Path(value="downloadtemplate")
    @Produces(value={"application/vnd.ms-excel"})
    public Response getClientTemplate(@QueryParam(value="legalFormType") String legalFormType, @QueryParam(value="officeId") Long officeId, @QueryParam(value="staffId") Long staffId, @QueryParam(value="dateFormat") String dateFormat) {
        return this.bulkImportWorkbookPopulatorService.getTemplate(legalFormType, officeId, staffId, dateFormat);
    }

    @POST
    @Path(value="uploadtemplate")
    @Consumes(value={"multipart/form-data"})
    @RequestBody(description="Upload client template", content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=UploadRequest.class))})
    public String postClientTemplate(@QueryParam(value="legalFormType") String legalFormType, @FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetail, @FormDataParam(value="locale") String locale, @FormDataParam(value="dateFormat") String dateFormat) {
        Long importDocumentId = this.bulkImportWorkbookService.importWorkbook(legalFormType, uploadedInputStream, fileDetail, locale, dateFormat);
        return this.toApiJsonSerializer.serialize((Object)importDocumentId);
    }

    @GET
    @Path(value="{clientId}/obligeedetails")
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve client obligee details", description="Retrieve client obligee details")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientsApiResourceSwagger.GetClientObligeeDetailsResponse.class))}), @ApiResponse(responseCode="400", description="Bad Request")})
    public String retrieveObligeeDetails(@PathParam(value="clientId") Long clientId, @Context UriInfo uriInfo) {
        return this.retrieveClientObligeeDetails(clientId, null);
    }

    @GET
    @Path(value="{clientId}/transferproposaldate")
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve client transfer template", description="Retrieve client transfer template")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientsApiResourceSwagger.GetClientTransferProposalDateResponse.class))}), @ApiResponse(responseCode="400", description="Bad Request")})
    public String retrieveTransferTemplate(@PathParam(value="clientId") Long clientId, @Context UriInfo uriInfo) {
        return this.retrieveClientTransferTemplate(clientId, null);
    }

    @GET
    @Path(value="/external-id/{externalId}")
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Client by External Id", description="Example Requests:\n\nclients/123-456\n\n\nclients/123-456?template=true\n\n\nclients/123-456?fields=id,displayName,officeName")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientsApiResourceSwagger.GetClientsClientIdResponse.class))})})
    public String retrieveOne(@PathParam(value="externalId") @Parameter(description="externalId") String externalId, @Context UriInfo uriInfo, @DefaultValue(value="false") @QueryParam(value="staffInSelectedOfficeOnly") @Parameter(description="staffInSelectedOfficeOnly") boolean staffInSelectedOfficeOnly) {
        return this.retrieveClient(null, externalId, staffInSelectedOfficeOnly, uriInfo);
    }

    @GET
    @Path(value="/external-id/{externalId}/accounts")
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve client accounts overview", description="An example of how a loan portfolio summary can be provided. This is requested in a specific use case of the community application.\nIt is quite reasonable to add resources like this to simplify User Interface development.\n\nExample Requests:\n \nclients/123-456/accounts\n\nclients/123-456/accounts?fields=loanAccounts,savingsAccounts")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientsApiResourceSwagger.GetClientsClientIdAccountsResponse.class))}), @ApiResponse(responseCode="400", description="Bad Request")})
    public String retrieveAssociatedAccounts(@PathParam(value="externalId") @Parameter(description="externalId") String externalId, @Context UriInfo uriInfo) {
        return this.retrieveClientAccounts(null, externalId, uriInfo);
    }

    @PUT
    @Path(value="/external-id/{externalId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a Client using the External Id", description="Note: You can update any of the basic attributes of a client (but not its associations) using this API.\n\nChanging the relationship between a client and its office is not supported through this API. An API specific to handling transfers of clients between offices is available for the same.\n\nThe relationship between a client and a group must be removed through the Groups API.")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=ClientsApiResourceSwagger.PutClientsClientIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientsApiResourceSwagger.PutClientsClientIdResponse.class))})})
    public String update(@Parameter(description="externalId") @PathParam(value="externalId") String externalId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        return this.updateClient(null, externalId, apiRequestBodyAsJson);
    }

    @POST
    @Path(value="/external-id/{externalId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Activate a Client | Close a Client | Reject a Client | Withdraw a Client | Reactivate a Client | UndoReject a Client | UndoWithdraw a Client | Assign a Staff | Unassign a Staff | Update Default Savings Account | Propose a Client Transfer | Withdraw a Client Transfer | Reject a Client Transfer | Accept a Client Transfer | Propose and Accept a Client Transfer", description="Activate a Client:\n\nClients can be created in a Pending state. This API exists to enable client activation (for when a client becomes an approved member of the financial Institution).\n\nIf the client happens to be already active this API will result in an error.\n\nClose a Client:\n\nClients can be closed if they do not have any non-closed loans/savingsAccount. This API exists to close a client .\n\nIf the client have any active loans/savingsAccount this API will result in an error.\n\nReject a Client:\n\nClients can be rejected when client is in pending for activation status.\n\nIf the client is any other status, this API throws an error.\n\nMandatory Fields: rejectionDate, rejectionReasonId\n\nWithdraw a Client:\n\nClient applications can be withdrawn when client is in a pending for activation status.\n\nIf the client is any other status, this API throws an error.\n\nMandatory Fields: withdrawalDate, withdrawalReasonId\n\nReactivate a Client: Clients can be reactivated after they have been closed.\n\nTrying to reactivate a client in any other state throws an error.\n\nMandatory Fields: reactivationDate\n\nUndoReject a Client:\n\nClients can be reactivated after they have been rejected.\n\nTrying to reactivate a client in any other state throws an error.\n\nMandatory Fields: reopenedDateUndoWithdraw a Client:\n\nClients can be reactivated after they have been withdrawn.\n\nTrying to reactivate a client in any other state throws an error.\n\nMandatory Fields: reopenedDate\n\nAssign a Staff:\n\nAllows you to assign a Staff for existed Client.\n\nThe selected Staff should belong to the same office (or an officer higher up in the hierarchy) as the Client he manages.\n\nUnassign a Staff:\n\nAllows you to unassign the Staff assigned to a Client.\n\nUpdate Default Savings Account:\n\nAllows you to modify or assign a default savings account for an existing Client.\n\nThe selected savings account should be one among the existing savings account for a particular customer.\n\nPropose a Client Transfer:\n\nAllows you to propose the transfer of a Client to a different Office.\n\nWithdraw a Client Transfer:\n\nAllows you to withdraw the proposed transfer of a Client to a different Office.\n\nWithdrawal can happen only if the destination Branch (to which the transfer was proposed) has not already accepted the transfer proposal\n\nReject a Client Transfer:\n\nAllows the Destination Branch to reject the proposed Client Transfer.\n\nAccept a Client Transfer:\n\nAllows the Destination Branch to accept the proposed Client Transfer.\n\nThe destination branch may also choose to link this client to a group (in which case, any existing active JLG loan of the client is rescheduled to match the meeting frequency of the group) and loan Officer at the time of accepting the transfer\n\nPropose and Accept a Client Transfer:\n\nAbstraction over the Propose and Accept Client Transfer API's which enable a user with Data Scope over both the Target and Destination Branches to directly transfer a Client to the destination Office.\n\nShowing request/response for 'Reject a Client Transfer'")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=ClientsApiResourceSwagger.PostClientsClientIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientsApiResourceSwagger.PostClientsClientIdResponse.class))})})
    public String applyCommand(@PathParam(value="externalId") @Parameter(description="externalId") String externalId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        return this.applyCommandOverClient(null, externalId, commandParam, apiRequestBodyAsJson);
    }

    @DELETE
    @Path(value="/external-id/{externalId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Delete a Client", description="If a client is in Pending state, you are allowed to Delete it. The delete is a 'hard delete' and cannot be recovered from. Once clients become active or have loans or savings associated with them, you cannot delete the client but you may Close the client if they have left the program.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientsApiResourceSwagger.DeleteClientsClientIdResponse.class))})})
    public String delete(@PathParam(value="externalId") @Parameter(description="externalId") String externalId) {
        return this.deleteClient(null, externalId);
    }

    @GET
    @Path(value="/external-id/{externalId}/obligeedetails")
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve client obligee details", description="Retrieve client obligee details using the client external Id")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientsApiResourceSwagger.GetClientObligeeDetailsResponse.class))}), @ApiResponse(responseCode="400", description="Bad Request")})
    public String retrieveObligeeDetails(@PathParam(value="externalId") String externalId, @Context UriInfo uriInfo) {
        return this.retrieveClientObligeeDetails(null, externalId);
    }

    @GET
    @Path(value="/external-id/{externalId}/transferproposaldate")
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve client transfer template", description="Retrieve client transfer template using the client external Id")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ClientsApiResourceSwagger.GetClientTransferProposalDateResponse.class))}), @ApiResponse(responseCode="400", description="Bad Request")})
    public String retrieveTransferTemplate(@PathParam(value="externalId") String externalId, @Context UriInfo uriInfo) {
        return this.retrieveClientTransferTemplate(null, externalId);
    }

    public String retrieveAll(UriInfo uriInfo, Long officeId, String externalId, String displayName, String firstname, String lastname, String status, Integer legalForm, String hierarchy, Integer offset, Integer limit, String orderBy, String sortOrder, Boolean orphansOnly, boolean isSelfUser) {
        this.context.authenticatedUser().validateHasReadPermission("client");
        this.sqlValidator.validate(orderBy);
        this.sqlValidator.validate(sortOrder);
        this.sqlValidator.validate(externalId);
        this.sqlValidator.validate(hierarchy);
        SearchParameters searchParameters = SearchParameters.builder().limit(limit).officeId(officeId).externalId(externalId).name(displayName).hierarchy(hierarchy).firstname(firstname).lastname(lastname).status(status).orphansOnly(orphansOnly).isSelfUser(Boolean.valueOf(isSelfUser)).offset(offset).orderBy(orderBy).sortOrder(sortOrder).legalForm(legalForm).build();
        Page clientData = this.clientReadPlatformService.retrieveAll(searchParameters);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, clientData, ClientApiConstants.CLIENT_RESPONSE_DATA_PARAMETERS);
    }

    private ClientData retrieveClientData(Long clientId, boolean staffInSelectedOfficeOnly, boolean isTemplate) {
        ClientData clientData = this.clientReadPlatformService.retrieveOne(clientId);
        if (isTemplate) {
            ClientData templateData = this.clientTemplateReadPlatformService.retrieveTemplate(clientData.getOfficeId(), staffInSelectedOfficeOnly);
            clientData = ClientData.templateOnTop((ClientData)clientData, (ClientData)templateData);
            Collection savingAccountOptions = this.savingsAccountReadPlatformService.retrieveForLookup(clientId, null);
            if (savingAccountOptions != null && savingAccountOptions.size() > 0) {
                clientData = ClientData.templateWithSavingAccountOptions((ClientData)clientData, (Collection)savingAccountOptions);
            }
        }
        return clientData;
    }

    private Long getResolvedClientId(Long clientId, ExternalId clientExternalId) {
        Long resolvedClientId = clientId;
        if (resolvedClientId == null) {
            clientExternalId.throwExceptionIfEmpty();
            resolvedClientId = this.clientReadPlatformService.retrieveClientIdByExternalId(clientExternalId);
            if (resolvedClientId == null) {
                throw new ClientNotFoundException(resolvedClientId);
            }
        }
        return resolvedClientId;
    }

    private CommandWrapper evaluateCommand(Long clientId, String commandParam, CommandWrapperBuilder builder) {
        CommandWrapper commandRequest = null;
        if (CommandParameterUtil.is((String)commandParam, (String)"activate")) {
            commandRequest = builder.activateClient(clientId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"assignStaff")) {
            commandRequest = builder.assignClientStaff(clientId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"unassignStaff")) {
            commandRequest = builder.unassignClientStaff(clientId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"close")) {
            commandRequest = builder.closeClient(clientId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"proposeTransfer")) {
            commandRequest = builder.proposeClientTransfer(clientId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"proposeAndAcceptTransfer")) {
            commandRequest = builder.proposeAndAcceptClientTransfer(clientId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"withdrawTransfer")) {
            commandRequest = builder.withdrawClientTransferRequest(clientId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"acceptTransfer")) {
            commandRequest = builder.acceptClientTransfer(clientId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"rejectTransfer")) {
            commandRequest = builder.rejectClientTransfer(clientId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"updateSavingsAccount")) {
            commandRequest = builder.updateClientSavingsAccount(clientId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"reject")) {
            commandRequest = builder.rejectClient(clientId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"withdraw")) {
            commandRequest = builder.withdrawClient(clientId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"reactivate")) {
            commandRequest = builder.reActivateClient(clientId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"undoRejection")) {
            commandRequest = builder.undoRejection(clientId).build();
        } else if (CommandParameterUtil.is((String)commandParam, (String)"undoWithdrawal")) {
            commandRequest = builder.undoWithdrawal(clientId).build();
        }
        if (commandRequest == null) {
            throw new UnrecognizedQueryParamException("command", commandParam, new Object[]{"activate", "unassignStaff", "assignStaff", "close", "proposeTransfer", "withdrawTransfer", "acceptTransfer", "rejectTransfer", "updateSavingsAccount", "reject", "withdraw", "reactivate"});
        }
        return commandRequest;
    }

    private String retrieveClient(Long clientId, String externalId, boolean staffInSelectedOfficeOnly, UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("client");
        ExternalId clientExternalId = ExternalIdFactory.produce((String)externalId);
        clientId = this.getResolvedClientId(clientId, clientExternalId);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        ClientData clientData = this.retrieveClientData(clientId, staffInSelectedOfficeOnly, settings.isTemplate());
        return this.toApiJsonSerializer.serialize(settings, (Object)clientData, ClientApiConstants.CLIENT_RESPONSE_DATA_PARAMETERS);
    }

    private String updateClient(Long clientId, String externalId, String jsonPayload) {
        ExternalId clientExternalId = ExternalIdFactory.produce((String)externalId);
        clientId = this.getResolvedClientId(clientId, clientExternalId);
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateClient(clientId).withJson(jsonPayload).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    private String deleteClient(Long clientId, String externalId) {
        ExternalId clientExternalId = ExternalIdFactory.produce((String)externalId);
        clientId = this.getResolvedClientId(clientId, clientExternalId);
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteClient(clientId).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    private String retrieveClientAccounts(Long clientId, String externalId, UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("client");
        ExternalId clientExternalId = ExternalIdFactory.produce((String)externalId);
        clientId = this.getResolvedClientId(clientId, clientExternalId);
        AccountSummaryCollectionData clientAccount = this.accountDetailsReadPlatformService.retrieveClientAccountDetails(clientId);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.clientAccountSummaryToApiJsonSerializer.serialize(settings, (Object)clientAccount, ClientApiConstants.CLIENT_ACCOUNTS_DATA_PARAMETERS);
    }

    private String applyCommandOverClient(Long clientId, String externalId, String command, String jsonPayload) {
        ExternalId clientExternalId = ExternalIdFactory.produce((String)externalId);
        clientId = this.getResolvedClientId(clientId, clientExternalId);
        CommandWrapperBuilder builder = new CommandWrapperBuilder().withJson(jsonPayload);
        CommandWrapper commandRequest = this.evaluateCommand(clientId, command, builder);
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    private String retrieveClientObligeeDetails(Long clientId, String externalId) {
        this.context.authenticatedUser().validateHasReadPermission("client");
        ExternalId clientExternalId = ExternalIdFactory.produce((String)externalId);
        clientId = this.getResolvedClientId(clientId, clientExternalId);
        List ObligeeList = this.guarantorReadPlatformService.retrieveObligeeDetails(clientId);
        return this.toApiJsonSerializer.serialize((Object)ObligeeList);
    }

    private String retrieveClientTransferTemplate(Long clientId, String externalId) {
        this.context.authenticatedUser().validateHasReadPermission("client");
        ExternalId clientExternalId = ExternalIdFactory.produce((String)externalId);
        clientId = this.getResolvedClientId(clientId, clientExternalId);
        LocalDate transferDate = this.clientReadPlatformService.retrieveClientTransferProposalDate(clientId);
        return this.toApiJsonSerializer.serialize((Object)transferDate);
    }

    @Generated
    public ClientsApiResource(PlatformSecurityContext context, ClientReadPlatformService clientReadPlatformService, ClientTemplateReadPlatformService clientTemplateReadPlatformService, ToApiJsonSerializer<ClientData> toApiJsonSerializer, ToApiJsonSerializer<AccountSummaryCollectionData> clientAccountSummaryToApiJsonSerializer, ApiRequestParameterHelper apiRequestParameterHelper, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, AccountDetailsReadPlatformService accountDetailsReadPlatformService, SavingsAccountReadPlatformService savingsAccountReadPlatformService, BulkImportWorkbookService bulkImportWorkbookService, BulkImportWorkbookPopulatorService bulkImportWorkbookPopulatorService, GuarantorReadPlatformService guarantorReadPlatformService, SqlValidator sqlValidator) {
        this.context = context;
        this.clientReadPlatformService = clientReadPlatformService;
        this.clientTemplateReadPlatformService = clientTemplateReadPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.clientAccountSummaryToApiJsonSerializer = clientAccountSummaryToApiJsonSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.accountDetailsReadPlatformService = accountDetailsReadPlatformService;
        this.savingsAccountReadPlatformService = savingsAccountReadPlatformService;
        this.bulkImportWorkbookService = bulkImportWorkbookService;
        this.bulkImportWorkbookPopulatorService = bulkImportWorkbookPopulatorService;
        this.guarantorReadPlatformService = guarantorReadPlatformService;
        this.sqlValidator = sqlValidator;
    }
}

