/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.client.domain;

import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.client.domain.ClientNonPerson;
import org.apache.fineract.portfolio.client.domain.ClientNonPersonRepository;
import org.apache.fineract.portfolio.client.exception.ClientNonPersonNotFoundByClientIdException;
import org.apache.fineract.portfolio.client.exception.ClientNonPersonNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClientNonPersonRepositoryWrapper {
    private final ClientNonPersonRepository repository;
    private final PlatformSecurityContext context;

    @Autowired
    public ClientNonPersonRepositoryWrapper(ClientNonPersonRepository repository, PlatformSecurityContext context) {
        this.repository = repository;
        this.context = context;
    }

    public ClientNonPerson findOneWithNotFoundDetection(Long id) {
        return (ClientNonPerson)this.repository.findById((Object)id).orElseThrow(() -> new ClientNonPersonNotFoundException(id));
    }

    public ClientNonPerson findOneByClientId(Long clientId) {
        return this.repository.findByClientId(clientId);
    }

    public ClientNonPerson findOneByClientIdWithNotFoundDetection(Long clientId) {
        ClientNonPerson clientNonPerson = this.repository.findByClientId(clientId);
        if (clientNonPerson == null) {
            throw new ClientNonPersonNotFoundByClientIdException(clientId);
        }
        return clientNonPerson;
    }

    public void save(ClientNonPerson clientNonPerson) {
        this.repository.save((Object)clientNonPerson);
    }

    public void saveAndFlush(ClientNonPerson clientNonPerson) {
        this.repository.saveAndFlush((Object)clientNonPerson);
    }

    public void delete(ClientNonPerson clientNonPerson) {
        this.repository.delete((Object)clientNonPerson);
    }
}

