/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.client.service;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.codes.service.CodeValueReadPlatformService;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.dataqueries.data.EntityTables;
import org.apache.fineract.infrastructure.dataqueries.data.StatusEnum;
import org.apache.fineract.infrastructure.dataqueries.service.EntityDatatableChecksReadService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.office.service.OfficeReadPlatformService;
import org.apache.fineract.organisation.staff.service.StaffReadPlatformService;
import org.apache.fineract.portfolio.address.data.AddressData;
import org.apache.fineract.portfolio.address.service.AddressReadPlatformService;
import org.apache.fineract.portfolio.client.data.ClientData;
import org.apache.fineract.portfolio.client.data.ClientFamilyMembersData;
import org.apache.fineract.portfolio.client.domain.ClientEnumerations;
import org.apache.fineract.portfolio.client.domain.LegalForm;
import org.apache.fineract.portfolio.client.service.ClientFamilyMembersReadPlatformService;
import org.apache.fineract.portfolio.client.service.ClientTemplateReadPlatformService;
import org.apache.fineract.portfolio.savings.service.SavingsProductReadPlatformService;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ClientTemplateReadPlatformServiceImpl
implements ClientTemplateReadPlatformService {
    private final PlatformSecurityContext context;
    private final OfficeReadPlatformService officeReadPlatformService;
    private final StaffReadPlatformService staffReadPlatformService;
    private final CodeValueReadPlatformService codeValueReadPlatformService;
    private final SavingsProductReadPlatformService savingsProductReadPlatformService;
    private final EntityDatatableChecksReadService entityDatatableChecksReadService;
    private final AddressReadPlatformService addressReadPlatformService;
    private final ClientFamilyMembersReadPlatformService clientFamilyMembersReadPlatformService;
    private final ConfigurationDomainService configurationDomainService;

    public ClientData retrieveTemplate(Long officeId, boolean staffInSelectedOfficeOnly) {
        this.context.authenticatedUser();
        Long defaultOfficeId = this.defaultToUsersOfficeIfNull(officeId);
        AddressData address = null;
        Collection offices = this.officeReadPlatformService.retrieveAllOfficesForDropdown();
        Collection savingsProductDatas = this.savingsProductReadPlatformService.retrieveAllForLookupByType(null);
        Boolean isAddressEnabled = this.configurationDomainService.isAddressEnabled();
        if (isAddressEnabled.booleanValue()) {
            address = this.addressReadPlatformService.retrieveTemplate();
        }
        ClientFamilyMembersData familyMemberOptions = this.clientFamilyMembersReadPlatformService.retrieveTemplate();
        List staffOptions = null;
        boolean loanOfficersOnly = false;
        staffOptions = staffInSelectedOfficeOnly ? this.staffReadPlatformService.retrieveAllStaffForDropdown(defaultOfficeId) : this.staffReadPlatformService.retrieveAllStaffInOfficeAndItsParentOfficeHierarchy(defaultOfficeId, false);
        if (CollectionUtils.isEmpty((Collection)staffOptions)) {
            staffOptions = null;
        }
        ArrayList genderOptions = new ArrayList(this.codeValueReadPlatformService.retrieveCodeValuesByCode("Gender"));
        ArrayList clientTypeOptions = new ArrayList(this.codeValueReadPlatformService.retrieveCodeValuesByCode("ClientType"));
        ArrayList clientClassificationOptions = new ArrayList(this.codeValueReadPlatformService.retrieveCodeValuesByCode("ClientClassification"));
        ArrayList clientNonPersonConstitutionOptions = new ArrayList(this.codeValueReadPlatformService.retrieveCodeValuesByCode("Constitution"));
        ArrayList clientNonPersonMainBusinessLineOptions = new ArrayList(this.codeValueReadPlatformService.retrieveCodeValuesByCode("Main Business Line"));
        List clientLegalFormOptions = ClientEnumerations.legalForm((LegalForm[])LegalForm.values());
        List datatableTemplates = this.entityDatatableChecksReadService.retrieveTemplates(StatusEnum.CREATE.getValue(), EntityTables.CLIENT.getName(), null);
        return ClientData.template((Long)defaultOfficeId, (LocalDate)LocalDate.now(DateUtils.getDateTimeZoneOfTenant()), (Collection)offices, (Collection)staffOptions, null, genderOptions, (Collection)savingsProductDatas, clientTypeOptions, clientClassificationOptions, clientNonPersonConstitutionOptions, clientNonPersonMainBusinessLineOptions, (List)clientLegalFormOptions, (ClientFamilyMembersData)familyMemberOptions, new ArrayList<AddressData>(Arrays.asList(address)), (Boolean)isAddressEnabled, (List)datatableTemplates);
    }

    private Long defaultToUsersOfficeIfNull(Long officeId) {
        Long defaultOfficeId = officeId;
        if (defaultOfficeId == null) {
            defaultOfficeId = (Long)this.context.authenticatedUser().getOffice().getId();
        }
        return defaultOfficeId;
    }

    @Generated
    public ClientTemplateReadPlatformServiceImpl(PlatformSecurityContext context, OfficeReadPlatformService officeReadPlatformService, StaffReadPlatformService staffReadPlatformService, CodeValueReadPlatformService codeValueReadPlatformService, SavingsProductReadPlatformService savingsProductReadPlatformService, EntityDatatableChecksReadService entityDatatableChecksReadService, AddressReadPlatformService addressReadPlatformService, ClientFamilyMembersReadPlatformService clientFamilyMembersReadPlatformService, ConfigurationDomainService configurationDomainService) {
        this.context = context;
        this.officeReadPlatformService = officeReadPlatformService;
        this.staffReadPlatformService = staffReadPlatformService;
        this.codeValueReadPlatformService = codeValueReadPlatformService;
        this.savingsProductReadPlatformService = savingsProductReadPlatformService;
        this.entityDatatableChecksReadService = entityDatatableChecksReadService;
        this.addressReadPlatformService = addressReadPlatformService;
        this.clientFamilyMembersReadPlatformService = clientFamilyMembersReadPlatformService;
        this.configurationDomainService = configurationDomainService;
    }
}

