/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.fund.starter;

import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.fund.domain.FundRepository;
import org.apache.fineract.portfolio.fund.serialization.FundCommandFromApiJsonDeserializer;
import org.apache.fineract.portfolio.fund.service.FundReadPlatformService;
import org.apache.fineract.portfolio.fund.service.FundReadPlatformServiceImpl;
import org.apache.fineract.portfolio.fund.service.FundWritePlatformService;
import org.apache.fineract.portfolio.fund.service.FundWritePlatformServiceJpaRepositoryImpl;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;

@Configuration
public class FundConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={FundReadPlatformService.class})
    public FundReadPlatformService fundReadPlatformService(JdbcTemplate jdbcTemplate, PlatformSecurityContext context) {
        return new FundReadPlatformServiceImpl(jdbcTemplate, context);
    }

    @Bean
    @ConditionalOnMissingBean(value={FundWritePlatformService.class})
    public FundWritePlatformService fundWritePlatformService(PlatformSecurityContext context, FundCommandFromApiJsonDeserializer fromApiJsonDeserializer, FundRepository fundRepository) {
        return new FundWritePlatformServiceJpaRepositoryImpl(context, fromApiJsonDeserializer, fundRepository);
    }
}

