/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.group.api;

import com.google.gson.JsonElement;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.bulkimport.data.GlobalEntityType;
import org.apache.fineract.infrastructure.bulkimport.service.BulkImportWorkbookPopulatorService;
import org.apache.fineract.infrastructure.bulkimport.service.BulkImportWorkbookService;
import org.apache.fineract.infrastructure.core.api.ApiParameterHelper;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.api.JsonQuery;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.PaginationParameters;
import org.apache.fineract.infrastructure.core.data.UploadRequest;
import org.apache.fineract.infrastructure.core.exception.UnrecognizedQueryParamException;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.serialization.ToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.dataqueries.data.EntityTables;
import org.apache.fineract.infrastructure.dataqueries.data.StatusEnum;
import org.apache.fineract.infrastructure.dataqueries.service.EntityDatatableChecksReadService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.service.SqlValidator;
import org.apache.fineract.portfolio.accountdetails.data.AccountSummaryCollectionData;
import org.apache.fineract.portfolio.accountdetails.service.AccountDetailsReadPlatformService;
import org.apache.fineract.portfolio.calendar.data.CalendarData;
import org.apache.fineract.portfolio.calendar.domain.CalendarEntityType;
import org.apache.fineract.portfolio.calendar.service.CalendarReadPlatformService;
import org.apache.fineract.portfolio.calendar.service.CalendarUtils;
import org.apache.fineract.portfolio.client.service.ClientReadPlatformService;
import org.apache.fineract.portfolio.collectionsheet.data.JLGCollectionSheetData;
import org.apache.fineract.portfolio.collectionsheet.service.CollectionSheetReadPlatformService;
import org.apache.fineract.portfolio.group.api.GroupingTypesApiConstants;
import org.apache.fineract.portfolio.group.api.GroupsApiResourceSwagger;
import org.apache.fineract.portfolio.group.data.GroupGeneralData;
import org.apache.fineract.portfolio.group.data.GroupRoleData;
import org.apache.fineract.portfolio.group.service.CenterReadPlatformService;
import org.apache.fineract.portfolio.group.service.GroupReadPlatformService;
import org.apache.fineract.portfolio.group.service.GroupRolesReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.data.GLIMContainer;
import org.apache.fineract.portfolio.loanaccount.service.GLIMAccountInfoReadPlatformService;
import org.apache.fineract.portfolio.meeting.data.MeetingData;
import org.apache.fineract.portfolio.meeting.service.MeetingReadPlatformService;
import org.apache.fineract.portfolio.savings.data.GSIMContainer;
import org.apache.fineract.portfolio.savings.service.GSIMReadPlatformService;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Path(value="/v1/groups")
@Component
@Tag(name="Groups", description="Groups are used to provide a distinctive banking distribution channel used in microfinances throughout the world. The Group is an administrative unit. It can contain as few as 5 people or as many as 40 depending on how its used.\n\nDifferent styles of group lending - Joint-Liability Group, Grameen Model (Center-Group), Self-Help Groups, Village/Communal Banks)")
public class GroupsApiResource {
    private final PlatformSecurityContext context;
    private final GroupReadPlatformService groupReadPlatformService;
    private final CenterReadPlatformService centerReadPlatformService;
    private final ClientReadPlatformService clientReadPlatformService;
    private final ToApiJsonSerializer<Object> toApiJsonSerializer;
    private final ToApiJsonSerializer<GroupGeneralData> groupGeneralApiJsonSerializer;
    private final ToApiJsonSerializer<AccountSummaryCollectionData> groupSummaryToApiJsonSerializer;
    private final ToApiJsonSerializer<GLIMContainer> glimContainerToApiJsonSerializer;
    private final ToApiJsonSerializer<GSIMContainer> gsimContainerToApiJsonSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final CollectionSheetReadPlatformService collectionSheetReadPlatformService;
    private final FromJsonHelper fromJsonHelper;
    private final GroupRolesReadPlatformService groupRolesReadPlatformService;
    private final AccountDetailsReadPlatformService accountDetailsReadPlatformService;
    private final CalendarReadPlatformService calendarReadPlatformService;
    private final MeetingReadPlatformService meetingReadPlatformService;
    private final EntityDatatableChecksReadService entityDatatableChecksReadService;
    private final BulkImportWorkbookService bulkImportWorkbookService;
    private final BulkImportWorkbookPopulatorService bulkImportWorkbookPopulatorService;
    private final GLIMAccountInfoReadPlatformService glimAccountInfoReadPlatformService;
    private final GSIMReadPlatformService gsimReadPlatformService;
    private final SqlValidator sqlValidator;

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Group Template", description="This is a convenience resource. It can be useful when building maintenance user interface screens for client applications. The template data returned consists of any or all of:\n\n\n\nField Defaults\n\nAllowed Value Lists\n\nExample Requests:\n\n\n\ngroups/template\n\n\n\ngroups/template?officeId=2\n\n\n\ngroups/template?centerId=1\n\n\n\ngroups/template?centerId=1&staffInSelectedOfficeOnly=true")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=GroupsApiResourceSwagger.GetGroupsTemplateResponse.class))})})
    public String retrieveTemplate(@Context UriInfo uriInfo, @QueryParam(value="officeId") @Parameter(description="officeId") Long officeId, @QueryParam(value="center") @Parameter(description="center") boolean isCenterGroup, @QueryParam(value="centerId") @Parameter(description="centerId") Long centerId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @DefaultValue(value="false") @QueryParam(value="staffInSelectedOfficeOnly") @Parameter(description="staffInSelectedOfficeOnly") boolean staffInSelectedOfficeOnly) {
        this.context.authenticatedUser().validateHasReadPermission("group");
        if (this.is(commandParam, "close")) {
            GroupGeneralData groupClosureTemplate = this.groupReadPlatformService.retrieveGroupWithClosureReasons();
            ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
            return this.groupGeneralApiJsonSerializer.serialize(settings, (Object)groupClosureTemplate, GroupingTypesApiConstants.GROUP_RESPONSE_DATA_PARAMETERS);
        }
        List datatableTemplates = this.entityDatatableChecksReadService.retrieveTemplates(StatusEnum.CREATE.getValue(), EntityTables.GROUP.getName(), null);
        if (centerId != null) {
            GroupGeneralData centerGroupTemplate = this.centerReadPlatformService.retrieveCenterGroupTemplate(centerId);
            centerGroupTemplate.setDatatables(datatableTemplates);
            ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
            return this.groupGeneralApiJsonSerializer.serialize(settings, (Object)centerGroupTemplate, GroupingTypesApiConstants.CENTER_GROUP_RESPONSE_DATA_PARAMETERS);
        }
        GroupGeneralData groupTemplate = this.groupReadPlatformService.retrieveTemplate(officeId, isCenterGroup, staffInSelectedOfficeOnly);
        groupTemplate.setDatatables(datatableTemplates);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.groupGeneralApiJsonSerializer.serialize(settings, (Object)groupTemplate, GroupingTypesApiConstants.GROUP_RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Groups", description="The default implementation of listing Groups returns 200 entries with support for pagination and sorting. Using the parameter limit with description -1 returns all entries.\n\nExample Requests:\n\n\n\ngroups\n\n\n\ngroups?fields=name,officeName,joinedDate\n\n\n\ngroups?offset=10&limit=50\n\n\n\ngroups?orderBy=name&sortOrder=DESC")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=GroupsApiResourceSwagger.GetGroupsResponse.class))})})
    public String retrieveAll(@Context UriInfo uriInfo, @QueryParam(value="officeId") @Parameter(description="officeId") Long officeId, @QueryParam(value="staffId") @Parameter(description="staffId") Long staffId, @QueryParam(value="externalId") @Parameter(description="externalId") String externalId, @QueryParam(value="name") @Parameter(description="name") String name, @QueryParam(value="underHierarchy") @Parameter(description="underHierarchy") String hierarchy, @QueryParam(value="paged") @Parameter(description="paged") Boolean paged, @QueryParam(value="offset") @Parameter(description="offset") Integer offset, @QueryParam(value="limit") @Parameter(description="limit") Integer limit, @QueryParam(value="orderBy") @Parameter(description="orderBy") String orderBy, @QueryParam(value="sortOrder") @Parameter(description="sortOrder") String sortOrder, @QueryParam(value="orphansOnly") @Parameter(description="orphansOnly") Boolean orphansOnly) {
        this.context.authenticatedUser().validateHasReadPermission("group");
        this.sqlValidator.validate(orderBy);
        this.sqlValidator.validate(sortOrder);
        this.sqlValidator.validate(externalId);
        this.sqlValidator.validate(hierarchy);
        PaginationParameters parameters = PaginationParameters.builder().paged(Boolean.TRUE.equals(paged)).limit(limit).offset(offset).orderBy(orderBy).sortOrder(sortOrder).build();
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        SearchParameters searchParameters = SearchParameters.builder().limit(limit).isSelfUser(Boolean.valueOf(false)).officeId(officeId).externalId(externalId).name(name).hierarchy(hierarchy).offset(offset).orderBy(orderBy).sortOrder(sortOrder).staffId(staffId).orphansOnly(orphansOnly).build();
        if (parameters.isPaged()) {
            Page groups = this.groupReadPlatformService.retrievePagedAll(searchParameters, parameters);
            return this.toApiJsonSerializer.serialize(settings, (Object)groups, GroupingTypesApiConstants.GROUP_RESPONSE_DATA_PARAMETERS);
        }
        Collection groups = this.groupReadPlatformService.retrieveAll(searchParameters, parameters);
        return this.toApiJsonSerializer.serialize(settings, (Object)groups, GroupingTypesApiConstants.GROUP_RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="{groupId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Group", description="Retrieve group information.\n\nExample Requests:\n\n\n\ngroups/1\n\n\n\ngroups/1?associations=clientMembers")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=GroupsApiResourceSwagger.GetGroupsGroupIdResponse.class))})})
    public String retrieveOne(@Context UriInfo uriInfo, @PathParam(value="groupId") @Parameter(description="groupId") Long groupId, @DefaultValue(value="false") @QueryParam(value="staffInSelectedOfficeOnly") @Parameter(description="staffInSelectedOfficeOnly") boolean staffInSelectedOfficeOnly, @QueryParam(value="roleId") @Parameter(description="roleId") Long roleId) {
        boolean template;
        this.context.authenticatedUser().validateHasReadPermission("group");
        Set associationParameters = ApiParameterHelper.extractAssociationsForResponseIfProvided((MultivaluedMap)uriInfo.getQueryParameters());
        GroupGeneralData group = this.groupReadPlatformService.retrieveOne(groupId);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        Collection membersOfGroup = null;
        Collection activeClientMembers = null;
        Collection groupRoles = null;
        GroupRoleData selectedRole = null;
        Collection calendars = null;
        CalendarData collectionMeetingCalendar = null;
        if (!associationParameters.isEmpty()) {
            if (associationParameters.contains("all")) {
                associationParameters.addAll(Arrays.asList("clientMembers", "activeClientMembers", "groupRoles", "calendars", "collectionMeetingCalendar"));
            }
            if (associationParameters.contains("clientMembers") && CollectionUtils.isEmpty((Collection)(membersOfGroup = this.clientReadPlatformService.retrieveClientMembersOfGroup(groupId)))) {
                membersOfGroup = null;
            }
            if (associationParameters.contains("activeClientMembers") && CollectionUtils.isEmpty((Collection)(activeClientMembers = this.clientReadPlatformService.retrieveActiveClientMembersOfGroup(groupId)))) {
                activeClientMembers = null;
            }
            if (associationParameters.contains("groupRoles") && CollectionUtils.isEmpty((Collection)(groupRoles = this.groupRolesReadPlatformService.retrieveGroupRoles(groupId)))) {
                groupRoles = null;
            }
            if (associationParameters.contains("parentCalendars")) {
                List calendarTypeOptions = CalendarUtils.createIntegerListFromQueryParameter((String)"all");
                calendars = this.calendarReadPlatformService.retrieveParentCalendarsByEntity(groupId, CalendarEntityType.GROUPS.getValue(), calendarTypeOptions);
                if (CollectionUtils.isEmpty((Collection)calendars)) {
                    calendars = null;
                }
            }
            if (associationParameters.contains("collectionMeetingCalendar") && (collectionMeetingCalendar = group.isChildGroup() ? this.calendarReadPlatformService.retrieveCollctionCalendarByEntity(group.getParentId(), CalendarEntityType.CENTERS.getValue()) : this.calendarReadPlatformService.retrieveCollctionCalendarByEntity(groupId, CalendarEntityType.GROUPS.getValue())) != null) {
                boolean withHistory = true;
                LocalDate tillDate = null;
                Collection recurringDates = this.calendarReadPlatformService.generateRecurringDates(collectionMeetingCalendar, true, tillDate);
                Collection nextTenRecurringDates = this.calendarReadPlatformService.generateNextTenRecurringDates(collectionMeetingCalendar);
                MeetingData lastMeeting = this.meetingReadPlatformService.retrieveLastMeeting(collectionMeetingCalendar.getCalendarInstanceId());
                LocalDate recentEligibleMeetingDate = this.calendarReadPlatformService.generateNextEligibleMeetingDateForCollection(collectionMeetingCalendar, lastMeeting);
                collectionMeetingCalendar = CalendarData.withRecurringDates((CalendarData)collectionMeetingCalendar, (Collection)recurringDates, (Collection)nextTenRecurringDates, (LocalDate)recentEligibleMeetingDate);
            }
            group = GroupGeneralData.withAssocations((GroupGeneralData)group, (Collection)membersOfGroup, (Collection)activeClientMembers, (Collection)groupRoles, (Collection)calendars, collectionMeetingCalendar);
        }
        if (roleId != null && (selectedRole = this.groupRolesReadPlatformService.retrieveGroupRole(groupId, roleId)) != null) {
            group = GroupGeneralData.updateSelectedRole((GroupGeneralData)group, (GroupRoleData)selectedRole);
        }
        if (template = ApiParameterHelper.template((MultivaluedMap)uriInfo.getQueryParameters())) {
            GroupGeneralData templateGroup = this.groupReadPlatformService.retrieveTemplate(group.getOfficeId(), false, staffInSelectedOfficeOnly);
            group = GroupGeneralData.withTemplate((GroupGeneralData)templateGroup, (GroupGeneralData)group);
        }
        return this.groupGeneralApiJsonSerializer.serialize(settings, (Object)group, GroupingTypesApiConstants.GROUP_RESPONSE_DATA_PARAMETERS);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a Group", description="Creates a Group\n\nMandatory Fields: name, officeId, active, activationDate (if active=true)\n\nOptional Fields: externalId, staffId, clientMembers")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=GroupsApiResourceSwagger.PostGroupsRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=GroupsApiResourceSwagger.PostGroupsResponse.class))})})
    public String create(@Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createGroup().withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @POST
    @Path(value="{groupId}/command/unassign_staff")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Unassign a Staff", description="Allows you to unassign the Staff.\n\nMandatory Fields: staffId")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=GroupsApiResourceSwagger.PostGroupsGroupIdCommandUnassignStaffRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=GroupsApiResourceSwagger.PostGroupsGroupIdCommandUnassignStaffResponse.class))})})
    public String unassignLoanOfficer(@PathParam(value="groupId") @Parameter(description="groupId") Long groupId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().unassignGroupStaff(groupId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @PUT
    @Path(value="{groupId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a Group", description="Updates a Group")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=GroupsApiResourceSwagger.PutGroupsGroupIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=GroupsApiResourceSwagger.PutGroupsGroupIdResponse.class))})})
    public String update(@PathParam(value="groupId") @Parameter(description="groupId") Long groupId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateGroup(groupId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @DELETE
    @Path(value="{groupId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Delete a Group", description="A group can be deleted if it is in pending state and has no associations - clients, loans or savings")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=GroupsApiResourceSwagger.DeleteGroupsGroupIdResponse.class))})})
    public String delete(@PathParam(value="groupId") @Parameter(description="groupId") Long groupId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteGroup(groupId).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @POST
    @Path(value="{groupId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Activate a Group | Associate Clients | Disassociate Clients | Transfer Clients across groups | Generate Collection Sheet | Save Collection Sheet | Unassign a Staff | Assign a Staff | Close a Group | Unassign a Role | Update a Role", description="Activate a Group:\n\nGroups can be created in a Pending state. This API exists to enable group activation.\n\n\n\nIf the group happens to be already active this API will result in an error.\n\nMandatory Fields: activationDate\n\nAssociate Clients:\n\nThis API allows to associate existing clients to a group.\n\n\n\nThe clients are listed from the office to which the group is associated.\n\n\n\nIf client(s) is already associated with group then API will result in an error.\n\nMandatory Fields: clientMembers\n\nDisassociate Clients:\n\nThis API allows to disassociate clients from a group.\n\n\n\nDisassociating a client with active joint liability group loans results in an error.\n\nMandatory Fields: clientMembers\n\nTransfer Clients across groups:\n\nThis API allows to transfer clients from one group to another\n\nMandatory Fields: destinationGroupId and clients\n\nOptional Fields: inheritDestinationGroupLoanOfficer (defaults to true) and transferActiveLoans (defaults to true)\n\nGenerate Collection Sheet:\n\nThis API retrieves repayment details of all jlg loans of all members of a group on a specified meeting date.\n\nMandatory Fields: calendarId and transactionDate\n\nSave Collection Sheet:\n\nThis api allows the loan officer to perform bulk repayments of JLG loans for a group on its meeting date.\n\nMandatory Fields: calendarId, transactionDate, actualDisbursementDate\n\nOptional Fields: clientsAttendance, bulkRepaymentTransaction, bulkDisbursementTransactions\n\nUnassign a Staff:\n\nAllows you to unassign the Staff.\n\nMandatory Fields: staffId\n\nAssign a Staff:\n\nAllows you to assign Staff to an existing Group.\n\n\n\nThe selected Staff should be belong to the same office (or an office higher up in the hierarchy) as this groupMandatory Fields: staffId\n\nOptional Fields: inheritStaffForClientAccounts (Optional: Boolean if true all members of the group (i.e all clients with active loans and savings ) will inherit the staffId)\n\nClose a Group:\n\nThis API exists to close a group. Groups can be closed if they don't have any non-closed clients/loans/savingsAccounts.\n\n\n\nIf the group has any active clients/loans/savingsAccount, this API will result in an error.Assign a Role:\n\nAllows you to assign a Role to an existing member of a group.\n\n\n\nWe can define the different roles applicable to group members by adding code values to the pre-defined system code GROUPROLE. Example:Group leader etc.\n\nMandatory Fields: clientId, role\n\nUnassign a Role:\n\nAllows you to unassign Roles associated tp Group members.\n\nUpdate a Role:\n\nAllows you to update the member Role.\n\nMandatory Fields: role\n\nShowing request/response for Transfer Clients across groups")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=GroupsApiResourceSwagger.PostGroupsGroupIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=GroupsApiResourceSwagger.PostGroupsGroupIdResponse.class))})})
    public String activateOrGenerateCollectionSheet(@PathParam(value="groupId") @Parameter(description="groupId") Long groupId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @QueryParam(value="roleId") @Parameter(description="roleId") Long roleId, @Parameter(hidden=true) String apiRequestBodyAsJson, @Context UriInfo uriInfo) {
        CommandWrapperBuilder builder = new CommandWrapperBuilder().withJson(apiRequestBodyAsJson);
        CommandProcessingResult result = null;
        if (this.is(commandParam, "activate")) {
            CommandWrapper commandRequest = builder.activateGroup(groupId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
            return this.toApiJsonSerializer.serialize((Object)result);
        }
        if (this.is(commandParam, "associateClients")) {
            CommandWrapper commandRequest = builder.associateClientsToGroup(groupId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
            return this.toApiJsonSerializer.serialize((Object)result);
        }
        if (this.is(commandParam, "disassociateClients")) {
            CommandWrapper commandRequest = builder.disassociateClientsFromGroup(groupId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
            return this.toApiJsonSerializer.serialize((Object)result);
        }
        if (this.is(commandParam, "generateCollectionSheet")) {
            JsonElement parsedQuery = this.fromJsonHelper.parse(apiRequestBodyAsJson);
            JsonQuery query = JsonQuery.from((String)apiRequestBodyAsJson, (JsonElement)parsedQuery, (FromJsonHelper)this.fromJsonHelper);
            JLGCollectionSheetData collectionSheet = this.collectionSheetReadPlatformService.generateGroupCollectionSheet(groupId, query);
            ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
            return this.toApiJsonSerializer.serialize(settings, (Object)collectionSheet, GroupingTypesApiConstants.COLLECTIONSHEET_DATA_PARAMETERS);
        }
        if (this.is(commandParam, "saveCollectionSheet")) {
            CommandWrapper commandRequest = builder.saveGroupCollectionSheet(groupId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
            return this.toApiJsonSerializer.serialize((Object)result);
        }
        if (this.is(commandParam, "unassignStaff")) {
            CommandWrapper commandRequest = builder.unassignGroupStaff(groupId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
            return this.toApiJsonSerializer.serialize((Object)result);
        }
        if (this.is(commandParam, "assignStaff")) {
            CommandWrapper commandRequest = builder.assignGroupStaff(groupId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
            return this.toApiJsonSerializer.serialize((Object)result);
        }
        if (this.is(commandParam, "assignRole")) {
            CommandWrapper commandRequest = builder.assignRole(groupId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
            return this.toApiJsonSerializer.serialize((Object)result);
        }
        if (this.is(commandParam, "unassignRole")) {
            CommandWrapper commandRequest = builder.unassignRole(groupId, roleId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
            return this.toApiJsonSerializer.serialize((Object)result);
        }
        if (this.is(commandParam, "updateRole")) {
            CommandWrapper commandRequest = builder.updateRole(groupId, roleId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
            return this.toApiJsonSerializer.serialize((Object)result);
        }
        if (this.is(commandParam, "transferClients")) {
            CommandWrapper commandRequest = builder.transferClientsBetweenGroups(groupId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
            return this.toApiJsonSerializer.serialize((Object)result);
        }
        if (this.is(commandParam, "close")) {
            CommandWrapper commandRequest = builder.closeGroup(groupId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
            return this.toApiJsonSerializer.serialize((Object)result);
        }
        throw new UnrecognizedQueryParamException("command", commandParam, new Object[]{"activate", "generateCollectionSheet", "saveCollectionSheet", "unassignStaff", "assignRole", "unassignRole", "updateassignRole"});
    }

    private boolean is(String commandParam, String commandValue) {
        return StringUtils.isNotBlank((CharSequence)commandParam) && commandParam.trim().equalsIgnoreCase(commandValue);
    }

    @GET
    @Path(value="{groupId}/accounts")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Group accounts overview", description="Retrieves details of all Loan and Savings accounts associated with this group.\n\n\n\nExample Requests:\n\n\n\ngroups/1/accounts\n\n\n\n\n\ngroups/1/accounts?fields=loanAccounts,savingsAccounts,memberLoanAccounts,\n\nmemberSavingsAccounts")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=GroupsApiResourceSwagger.GetGroupsGroupIdAccountsResponse.class))})})
    public String retrieveAccounts(@PathParam(value="groupId") @Parameter(description="groupId") Long groupId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("GROUP");
        AccountSummaryCollectionData groupAccount = this.accountDetailsReadPlatformService.retrieveGroupAccountDetails(groupId);
        HashSet<String> GROUP_ACCOUNTS_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("loanAccounts", "groupLoanIndividualMonitoringAccounts", "savingsAccounts", "memberLoanAccounts", "memberSavingsAccounts"));
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.groupSummaryToApiJsonSerializer.serialize(settings, (Object)groupAccount, GROUP_ACCOUNTS_DATA_PARAMETERS);
    }

    @GET
    @Path(value="downloadtemplate")
    @Produces(value={"application/vnd.ms-excel"})
    public Response getGroupsTemplate(@QueryParam(value="officeId") Long officeId, @QueryParam(value="staffId") Long staffId, @QueryParam(value="dateFormat") String dateFormat) {
        return this.bulkImportWorkbookPopulatorService.getTemplate(GlobalEntityType.GROUPS.toString(), officeId, staffId, dateFormat);
    }

    @POST
    @Path(value="uploadtemplate")
    @Consumes(value={"multipart/form-data"})
    @RequestBody(description="Upload group template", content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=UploadRequest.class))})
    public String postGroupTemplate(@FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetail, @FormDataParam(value="locale") String locale, @FormDataParam(value="dateFormat") String dateFormat) {
        Long importDocumentId = this.bulkImportWorkbookService.importWorkbook(GlobalEntityType.GROUPS.toString(), uploadedInputStream, fileDetail, locale, dateFormat);
        return this.toApiJsonSerializer.serialize((Object)importDocumentId);
    }

    @GET
    @Path(value="{groupId}/glimaccounts")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveglimAccounts(@PathParam(value="groupId") Long groupId, @QueryParam(value="parentLoanAccountNo") String parentLoanAccountNo, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("GROUP");
        List glimContainer = Collections.emptyList();
        glimContainer = parentLoanAccountNo == null ? (List)this.glimAccountInfoReadPlatformService.findGlimAccount(groupId) : (List)this.glimAccountInfoReadPlatformService.findGlimAccountbyGroupAndAccount(groupId, parentLoanAccountNo);
        HashSet<String> GLIM_ACCOUNTS_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("groupId", "accountNumber", "childGLIMAccounts", "memberLoanAccounts", "parentPrincipalAmount"));
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.glimContainerToApiJsonSerializer.serialize(settings, (Collection)glimContainer, GLIM_ACCOUNTS_DATA_PARAMETERS);
    }

    @GET
    @Path(value="{groupId}/gsimaccounts")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveGsimAccounts(@PathParam(value="groupId") Long groupId, @QueryParam(value="parentGSIMAccountNo") String parentGSIMAccountNo, @QueryParam(value="parentGSIMId") Long parentGSIMId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("GROUP");
        List gsimContainer = parentGSIMAccountNo == null && parentGSIMId != null ? this.gsimReadPlatformService.findGsimAccountContainerbyGsimAccountId(parentGSIMId) : (parentGSIMAccountNo != null && parentGSIMId == null ? (List)this.gsimReadPlatformService.findGsimAccountContainerbyGsimAccountNumber(parentGSIMAccountNo) : (List)this.gsimReadPlatformService.findGSIMAccountContainerByGroupId(groupId));
        HashSet<String> GSIM_ACCOUNTS_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("gsimId", "groupId", "accountNumber", "childGSIMAccounts", "parentBalance", "savingsStatus"));
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.gsimContainerToApiJsonSerializer.serialize(settings, (Collection)gsimContainer, GSIM_ACCOUNTS_DATA_PARAMETERS);
    }

    @Generated
    public GroupsApiResource(PlatformSecurityContext context, GroupReadPlatformService groupReadPlatformService, CenterReadPlatformService centerReadPlatformService, ClientReadPlatformService clientReadPlatformService, ToApiJsonSerializer<Object> toApiJsonSerializer, ToApiJsonSerializer<GroupGeneralData> groupGeneralApiJsonSerializer, ToApiJsonSerializer<AccountSummaryCollectionData> groupSummaryToApiJsonSerializer, ToApiJsonSerializer<GLIMContainer> glimContainerToApiJsonSerializer, ToApiJsonSerializer<GSIMContainer> gsimContainerToApiJsonSerializer, ApiRequestParameterHelper apiRequestParameterHelper, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, CollectionSheetReadPlatformService collectionSheetReadPlatformService, FromJsonHelper fromJsonHelper, GroupRolesReadPlatformService groupRolesReadPlatformService, AccountDetailsReadPlatformService accountDetailsReadPlatformService, CalendarReadPlatformService calendarReadPlatformService, MeetingReadPlatformService meetingReadPlatformService, EntityDatatableChecksReadService entityDatatableChecksReadService, BulkImportWorkbookService bulkImportWorkbookService, BulkImportWorkbookPopulatorService bulkImportWorkbookPopulatorService, GLIMAccountInfoReadPlatformService glimAccountInfoReadPlatformService, GSIMReadPlatformService gsimReadPlatformService, SqlValidator sqlValidator) {
        this.context = context;
        this.groupReadPlatformService = groupReadPlatformService;
        this.centerReadPlatformService = centerReadPlatformService;
        this.clientReadPlatformService = clientReadPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.groupGeneralApiJsonSerializer = groupGeneralApiJsonSerializer;
        this.groupSummaryToApiJsonSerializer = groupSummaryToApiJsonSerializer;
        this.glimContainerToApiJsonSerializer = glimContainerToApiJsonSerializer;
        this.gsimContainerToApiJsonSerializer = gsimContainerToApiJsonSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.collectionSheetReadPlatformService = collectionSheetReadPlatformService;
        this.fromJsonHelper = fromJsonHelper;
        this.groupRolesReadPlatformService = groupRolesReadPlatformService;
        this.accountDetailsReadPlatformService = accountDetailsReadPlatformService;
        this.calendarReadPlatformService = calendarReadPlatformService;
        this.meetingReadPlatformService = meetingReadPlatformService;
        this.entityDatatableChecksReadService = entityDatatableChecksReadService;
        this.bulkImportWorkbookService = bulkImportWorkbookService;
        this.bulkImportWorkbookPopulatorService = bulkImportWorkbookPopulatorService;
        this.glimAccountInfoReadPlatformService = glimAccountInfoReadPlatformService;
        this.gsimReadPlatformService = gsimReadPlatformService;
        this.sqlValidator = sqlValidator;
    }
}

