/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.api;

import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.office.service.OfficeReadPlatformService;
import org.apache.fineract.organisation.staff.data.BulkTransferLoanOfficerData;
import org.apache.fineract.organisation.staff.data.StaffAccountSummaryCollectionData;
import org.apache.fineract.organisation.staff.service.StaffReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.service.BulkLoansReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/loans/loanreassignment")
@Component
@Tag(name="Bulk Loans", description="")
public class BulkLoansApiResource {
    public static final String OFFICE_ID = "officeId";
    public static final String FROM_LOAN_OFFICER_ID = "fromLoanOfficerId";
    public static final String ASSIGNMENT_DATE = "assignmentDate";
    public static final String OFFICE_OPTIONS = "officeOptions";
    public static final String LOAN_OFFICER_OPTIONS = "loanOfficerOptions";
    public static final String ACCOUNT_SUMMARY_COLLECTION = "accountSummaryCollection";
    private static final Set<String> RESPONSE_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("officeId", "fromLoanOfficerId", "assignmentDate", "officeOptions", "loanOfficerOptions", "accountSummaryCollection"));
    private static final String RESOURCE_NAME_FOR_PERMISSIONS = "LOAN";
    private final PlatformSecurityContext context;
    private final StaffReadPlatformService staffReadPlatformService;
    private final OfficeReadPlatformService officeReadPlatformService;
    private final BulkLoansReadPlatformService bulkLoansReadPlatformService;
    private final DefaultToApiJsonSerializer<BulkTransferLoanOfficerData> toApiJsonSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String loanReassignmentTemplate(@QueryParam(value="officeId") Long officeId, @QueryParam(value="fromLoanOfficerId") Long loanOfficerId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        Collection offices = this.officeReadPlatformService.retrieveAllOfficesForDropdown();
        List loanOfficers = null;
        StaffAccountSummaryCollectionData staffAccountSummaryCollectionData = null;
        if (officeId != null) {
            loanOfficers = this.staffReadPlatformService.retrieveAllLoanOfficersInOfficeById(officeId);
        }
        if (loanOfficerId != null) {
            staffAccountSummaryCollectionData = this.bulkLoansReadPlatformService.retrieveLoanOfficerAccountSummary(loanOfficerId);
        }
        BulkTransferLoanOfficerData loanReassignmentData = BulkTransferLoanOfficerData.templateForBulk((Long)officeId, (Long)loanOfficerId, (LocalDate)LocalDate.now(DateUtils.getDateTimeZoneOfTenant()), (Collection)offices, (Collection)loanOfficers, (StaffAccountSummaryCollectionData)staffAccountSummaryCollectionData);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)loanReassignmentData, RESPONSE_DATA_PARAMETERS);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String loanReassignment(String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().assignLoanOfficersInBulk().withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @Generated
    public BulkLoansApiResource(PlatformSecurityContext context, StaffReadPlatformService staffReadPlatformService, OfficeReadPlatformService officeReadPlatformService, BulkLoansReadPlatformService bulkLoansReadPlatformService, DefaultToApiJsonSerializer<BulkTransferLoanOfficerData> toApiJsonSerializer, ApiRequestParameterHelper apiRequestParameterHelper, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService) {
        this.context = context;
        this.staffReadPlatformService = staffReadPlatformService;
        this.officeReadPlatformService = officeReadPlatformService;
        this.bulkLoansReadPlatformService = bulkLoansReadPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
    }
}

