/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.shareproducts.api;

import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.exception.UnrecognizedQueryParamException;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.service.SqlValidator;
import org.apache.fineract.portfolio.shareaccounts.data.ShareAccountDividendData;
import org.apache.fineract.portfolio.shareaccounts.service.ShareAccountDividendReadPlatformService;
import org.apache.fineract.portfolio.shareproducts.data.ShareProductDividendPayOutData;
import org.apache.fineract.portfolio.shareproducts.service.ShareProductDividendReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/shareproduct/{productId}/dividend")
@Component
@Tag(name="Self Dividend", description="")
public class ShareDividendApiResource {
    public static final String APPROVE = "approve";
    private static final String RESOURCE_NAME_FOR_PERMISSIONS = "DIVIDEND_SHAREPRODUCT";
    private final DefaultToApiJsonSerializer<ShareProductDividendPayOutData> toApiJsonSerializer;
    private final DefaultToApiJsonSerializer<ShareAccountDividendData> toApiAccountDetailJsonSerializer;
    private final PlatformSecurityContext platformSecurityContext;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final ShareAccountDividendReadPlatformService shareAccountDividendReadPlatformService;
    private final ShareProductDividendReadPlatformService shareProductDividendReadPlatformService;
    private final SqlValidator sqlValidator;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveAll(@PathParam(value="productId") Long productId, @QueryParam(value="offset") Integer offset, @QueryParam(value="limit") Integer limit, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="sortOrder") String sortOrder, @QueryParam(value="status") Integer status) {
        this.platformSecurityContext.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        this.sqlValidator.validate(orderBy);
        this.sqlValidator.validate(sortOrder);
        SearchParameters searchParameters = SearchParameters.builder().limit(limit).offset(offset).orderBy(orderBy).sortOrder(sortOrder).build();
        Page dividendPayoutDetails = this.shareProductDividendReadPlatformService.retriveAll(productId, status, searchParameters);
        return this.toApiJsonSerializer.serialize((Object)dividendPayoutDetails);
    }

    @GET
    @Path(value="{dividendId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveDividendDetails(@PathParam(value="dividendId") Long dividendId, @QueryParam(value="offset") Integer offset, @QueryParam(value="limit") Integer limit, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="sortOrder") String sortOrder, @QueryParam(value="accountNo") String accountNo, @PathParam(value="productId") Long productId) {
        this.platformSecurityContext.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        this.sqlValidator.validate(orderBy);
        this.sqlValidator.validate(sortOrder);
        this.sqlValidator.validate(accountNo);
        SearchParameters searchParameters = SearchParameters.builder().limit(limit).offset(offset).orderBy(orderBy).sortOrder(sortOrder).accountNo(accountNo).build();
        Page dividendDetails = this.shareAccountDividendReadPlatformService.retriveAll(dividendId, searchParameters);
        return this.toApiAccountDetailJsonSerializer.serialize((Object)dividendDetails);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String createDividendDetail(@PathParam(value="productId") Long productId, String apiRequestBodyAsJson) {
        this.platformSecurityContext.authenticatedUser();
        CommandWrapper commandWrapper = new CommandWrapperBuilder().createShareProductDividendPayoutCommand(productId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult commandProcessingResult = this.commandsSourceWritePlatformService.logCommandSource(commandWrapper);
        return this.toApiJsonSerializer.serialize((Object)commandProcessingResult);
    }

    @PUT
    @Path(value="{dividendId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String updateDividendDetail(@PathParam(value="productId") Long productId, @PathParam(value="dividendId") Long dividendId, @QueryParam(value="command") String commandParam, String apiRequestBodyAsJson) {
        this.platformSecurityContext.authenticatedUser();
        if (!this.is(commandParam, APPROVE)) {
            throw new UnrecognizedQueryParamException("command", commandParam, new Object[0]);
        }
        CommandWrapper commandWrapper = new CommandWrapperBuilder().approveShareProductDividendPayoutCommand(productId, dividendId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult commandProcessingResult = this.commandsSourceWritePlatformService.logCommandSource(commandWrapper);
        return this.toApiJsonSerializer.serialize((Object)commandProcessingResult);
    }

    @DELETE
    @Path(value="{dividendId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String deleteDividendDetail(@PathParam(value="productId") Long productId, @PathParam(value="dividendId") Long dividendId) {
        this.platformSecurityContext.authenticatedUser();
        CommandWrapper commandWrapper = new CommandWrapperBuilder().deleteShareProductDividendPayoutCommand(productId, dividendId).build();
        CommandProcessingResult commandProcessingResult = this.commandsSourceWritePlatformService.logCommandSource(commandWrapper);
        return this.toApiJsonSerializer.serialize((Object)commandProcessingResult);
    }

    private boolean is(String commandParam, String commandValue) {
        return StringUtils.isNotBlank((CharSequence)commandParam) && commandParam.trim().equalsIgnoreCase(commandValue);
    }

    @Generated
    public ShareDividendApiResource(DefaultToApiJsonSerializer<ShareProductDividendPayOutData> toApiJsonSerializer, DefaultToApiJsonSerializer<ShareAccountDividendData> toApiAccountDetailJsonSerializer, PlatformSecurityContext platformSecurityContext, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, ShareAccountDividendReadPlatformService shareAccountDividendReadPlatformService, ShareProductDividendReadPlatformService shareProductDividendReadPlatformService, SqlValidator sqlValidator) {
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.toApiAccountDetailJsonSerializer = toApiAccountDetailJsonSerializer;
        this.platformSecurityContext = platformSecurityContext;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.shareAccountDividendReadPlatformService = shareAccountDividendReadPlatformService;
        this.shareProductDividendReadPlatformService = shareProductDividendReadPlatformService;
        this.sqlValidator = sqlValidator;
    }
}

