/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.spm.service;

import jakarta.persistence.EntityExistsException;
import jakarta.persistence.PersistenceException;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.spm.domain.Survey;
import org.apache.fineract.spm.domain.SurveyRepository;
import org.apache.fineract.spm.domain.SurveyValidator;
import org.apache.fineract.spm.exception.SurveyNotFoundException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.jpa.JpaSystemException;

/*
 * Exception performing whole class analysis ignored.
 */
public class SpmService {
    private final PlatformSecurityContext securityContext;
    private final SurveyRepository surveyRepository;
    private final SurveyValidator surveyValidator;

    public List<Survey> fetchValidSurveys() {
        this.securityContext.authenticatedUser();
        return this.surveyRepository.fetchActiveSurveys(DateUtils.getLocalDateOfTenant());
    }

    public List<Survey> fetchAllSurveys() {
        this.securityContext.authenticatedUser();
        return this.surveyRepository.fetchAllSurveys();
    }

    public Survey findById(Long id) {
        this.securityContext.authenticatedUser();
        return (Survey)this.surveyRepository.findById((Object)id).orElseThrow(() -> new SurveyNotFoundException(id));
    }

    public Survey createSurvey(Survey survey) {
        this.securityContext.authenticatedUser();
        this.surveyValidator.validate(survey);
        Survey previousSurvey = this.surveyRepository.findByKey(survey.getKey(), DateUtils.getLocalDateOfTenant());
        if (previousSurvey != null) {
            this.deactivateSurvey((Long)previousSurvey.getId());
        }
        LocalDate validFrom = SpmService.getStartOfToday();
        survey.setValidFrom(validFrom);
        survey.setValidTo(validFrom.plusYears(100L));
        try {
            this.surveyRepository.saveAndFlush((Object)survey);
        }
        catch (EntityExistsException dve) {
            this.handleDataIntegrityIssues((Throwable)dve, (Exception)((Object)dve), survey.getKey());
        }
        catch (DataIntegrityViolationException dve) {
            this.handleDataIntegrityIssues(dve.getMostSpecificCause(), (Exception)((Object)dve), survey.getKey());
        }
        catch (JpaSystemException dve) {
            this.handleDataIntegrityIssues(dve.getMostSpecificCause(), (Exception)((Object)dve), survey.getKey());
        }
        catch (PersistenceException dve) {
            this.handleDataIntegrityIssues((Throwable)dve, (Exception)((Object)dve), survey.getKey());
        }
        return survey;
    }

    public Survey updateSurvey(Survey survey) {
        try {
            this.surveyValidator.validate(survey);
            this.surveyRepository.saveAndFlush((Object)survey);
        }
        catch (EntityExistsException dve) {
            this.handleDataIntegrityIssues((Throwable)dve, (Exception)((Object)dve), survey.getKey());
        }
        catch (DataIntegrityViolationException dve) {
            this.handleDataIntegrityIssues(dve.getMostSpecificCause(), (Exception)((Object)dve), survey.getKey());
        }
        catch (JpaSystemException dve) {
            this.handleDataIntegrityIssues(dve.getMostSpecificCause(), (Exception)((Object)dve), survey.getKey());
        }
        catch (PersistenceException dve) {
            this.handleDataIntegrityIssues((Throwable)dve, (Exception)((Object)dve), survey.getKey());
        }
        return survey;
    }

    public void deactivateSurvey(Long id) {
        this.securityContext.authenticatedUser();
        Survey survey = this.findById(id);
        LocalDate dateTime = SpmService.getStartOfToday().minusDays(1L);
        survey.setValidTo(dateTime);
        this.surveyRepository.saveAndFlush((Object)survey);
    }

    public void activateSurvey(Long id) {
        this.securityContext.authenticatedUser();
        Survey survey = this.findById(id);
        LocalDate validFrom = SpmService.getStartOfToday();
        survey.setValidFrom(validFrom);
        survey.setValidTo(validFrom.plusYears(100L));
        this.surveyRepository.saveAndFlush((Object)survey);
    }

    public static LocalDate getStartOfToday() {
        return DateUtils.getLocalDateOfTenant();
    }

    private void handleDataIntegrityIssues(Throwable realCause, Exception dve, String key) {
        if (realCause.getMessage().contains("m_survey_scorecards")) {
            throw new PlatformDataIntegrityException("error.msg.survey.cannot.be.modified.as.used.in.client.survey", "Survey can not be edited as it is already used in client survey", "name", new Object[]{key});
        }
        if (realCause.getMessage().contains("key")) {
            throw new PlatformDataIntegrityException("error.msg.survey.duplicate.key", "Survey with key already exists", "name", new Object[]{key});
        }
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.survey.unknown.data.integrity.issue", (String)("Unknown data integrity issue with resource: " + realCause.getMessage()));
    }

    @Generated
    public SpmService(PlatformSecurityContext securityContext, SurveyRepository surveyRepository, SurveyValidator surveyValidator) {
        this.securityContext = securityContext;
        this.surveyRepository = surveyRepository;
        this.surveyValidator = surveyValidator;
    }
}

