/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.spm.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.fineract.spm.data.LookupTableData;
import org.apache.fineract.spm.data.LookupTableEntry;
import org.apache.fineract.spm.domain.LookupTable;
import org.apache.fineract.spm.domain.Survey;

public final class LookupTableMapper {
    private LookupTableMapper() {
    }

    public static List<LookupTableData> map(List<LookupTable> lookupTables) {
        HashMap<String, LookupTableData> lookupTableDataMap = new HashMap<String, LookupTableData>();
        LookupTableData lookupTableData = null;
        if (lookupTables != null && !lookupTables.isEmpty()) {
            for (LookupTable lookupTable : lookupTables) {
                lookupTableData = (LookupTableData)lookupTableDataMap.get(lookupTable.getKey());
                if (lookupTableData == null) {
                    lookupTableData = new LookupTableData();
                    lookupTableDataMap.put(lookupTable.getKey(), lookupTableData);
                    lookupTableData.setKey(lookupTable.getKey());
                    lookupTableData.setDescription(lookupTable.getDescription());
                    lookupTableData.setEntries(new ArrayList());
                }
                lookupTableData.getEntries().add(new LookupTableEntry(lookupTable.getValueFrom(), lookupTable.getValueTo(), lookupTable.getScore()));
            }
            return List.copyOf(lookupTableDataMap.values());
        }
        return List.of();
    }

    public static List<LookupTable> map(LookupTableData lookupTableData, Survey survey) {
        ArrayList<LookupTable> lookupTables = new ArrayList<LookupTable>();
        List entries = lookupTableData.getEntries();
        if (entries != null) {
            for (LookupTableEntry entry : entries) {
                LookupTable lookupTable = new LookupTable();
                lookupTables.add(lookupTable);
                lookupTable.setSurvey(survey);
                lookupTable.setKey(lookupTableData.getKey());
                lookupTable.setDescription(lookupTableData.getDescription());
                lookupTable.setValueFrom(entry.getValueFrom());
                lookupTable.setValueTo(entry.getValueTo());
                lookupTable.setScore(entry.getScore());
            }
        }
        return lookupTables;
    }
}

