/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.template.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.template.api.TemplatesApiResourcesSwagger;
import org.apache.fineract.template.data.TemplateData;
import org.apache.fineract.template.domain.Template;
import org.apache.fineract.template.domain.TemplateEntity;
import org.apache.fineract.template.domain.TemplateType;
import org.apache.fineract.template.service.TemplateDomainService;
import org.apache.fineract.template.service.TemplateMergeService;
import org.springframework.stereotype.Component;

@Path(value="/v1/templates")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Component
@Tag(name="User Generated Documents", description="User Generated Documents(alternatively, Templates) are used for end-user features such as custom user defined document generation (AKA UGD). They are based on {{ moustache }} templates. Think of them as a sort of built-in \"mail merge\" functionality.\n\nUser Generated Documents (and other types of templates) can aggregate data from several Apache Fineract back-end API calls via mappers. Mappers can even access non-Apache Fineract REST services from other servers. UGDs can render such data in tables, show images, etc. TBD: Please have a look at some of the Example UGDs included in Apache Fineract (or the Wiki page, for now.).\n\nUGDs can be assigned to an entity like client or loan and be of a type like Document or SMS. The entity and type of a UGD is only there for the convenience of user agents (UIs), in order to know where to show UGDs for the user (i.e. which tab). The Template Engine back-end runner does not actually need this metadata.")
public class TemplatesApiResource {
    public static final String ID = "id";
    public static final String ENTITIES = "entities";
    public static final String TYPES = "types";
    public static final String PARAM_TEMPLATE = "template";
    private static final Set<String> RESPONSE_TEMPLATES_DATA_PARAMETERS = new HashSet<String>(List.of("id"));
    private static final Set<String> RESPONSE_TEMPLATE_DATA_PARAMETERS = new HashSet<String>(List.of("id", "entities", "types", "template"));
    private static final String RESOURCE_NAME_FOR_PERMISSION = "template";
    private final PlatformSecurityContext context;
    private final DefaultToApiJsonSerializer<Template> toApiJsonSerializer;
    private final DefaultToApiJsonSerializer<TemplateData> templateDataApiJsonSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final TemplateDomainService templateService;
    private final TemplateMergeService templateMergeService;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;

    @GET
    @Operation(summary="Retrieve all UGDs", description="Example Requests:\n\ntemplates\n\nIt is also possible to get specific UGDs by entity and type:\n\ntemplates?type=0&entity=0\n[Entity: Id]\n\n\n\n\n\nclient: 0, loan: 1\n\n[Type: Id]\n\n\n\nDocument: 0, E-Mail (not yet): 1,  SMS: 2")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=TemplatesApiResourcesSwagger.GetTemplatesResponse.class))})})
    public String retrieveAll(@DefaultValue(value="-1") @QueryParam(value="typeId") @Parameter(description="typeId") int typeId, @DefaultValue(value="-1") @QueryParam(value="entityId") @Parameter(description="entityId") int entityId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("template");
        List templates = typeId != -1 && entityId != -1 ? this.templateService.getAllByEntityAndType(TemplateEntity.values()[entityId], TemplateType.values()[typeId]) : this.templateService.getAll();
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Collection)templates, RESPONSE_TEMPLATES_DATA_PARAMETERS);
    }

    @GET
    @Path(value="template")
    @Operation(summary="Retrieve UGD Details Template", description="This is a convenience resource. It can be useful when building maintenance user interface screens for UGDs. The UGD data returned consists of any or all of:\n\nARGUMENTS\nname String entity String type String text String optional mappers Mapper optional\nExample Request:\n\ntemplates/template")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=TemplatesApiResourcesSwagger.GetTemplatesTemplateResponse.class))})})
    public String template(@Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("template");
        TemplateData templateData = TemplateData.template();
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.templateDataApiJsonSerializer.serialize(settings, (Object)templateData, RESPONSE_TEMPLATES_DATA_PARAMETERS);
    }

    @POST
    @Operation(summary="Add a UGD", description="Adds a new UGD.\n\nMandatory Fields\nname\n\n\n\nExample Requests:\n\ntemplates/1")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=TemplatesApiResourcesSwagger.PostTemplatesRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=TemplatesApiResourcesSwagger.PostTemplatesResponse.class))})})
    public String createTemplate(@Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createTemplate().withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @GET
    @Path(value="{templateId}")
    @Operation(summary="Retrieve a UGD", description="Example Requests:\n\ntemplates/1")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=TemplatesApiResourcesSwagger.GetTemplatesTemplateIdResponse.class))})})
    public String retrieveOne(@PathParam(value="templateId") @Parameter(description="templateId") Long templateId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("template");
        Template template = this.templateService.findOneById(templateId);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)template, RESPONSE_TEMPLATES_DATA_PARAMETERS);
    }

    @GET
    @Path(value="{templateId}/template")
    public String getTemplateByTemplate(@PathParam(value="templateId") Long templateId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("template");
        TemplateData template = TemplateData.template((Template)this.templateService.findOneById(templateId));
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.templateDataApiJsonSerializer.serialize(settings, (Object)template, RESPONSE_TEMPLATE_DATA_PARAMETERS);
    }

    @PUT
    @Path(value="{templateId}")
    @Operation(summary="Update a UGD", description="")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=TemplatesApiResourcesSwagger.PutTemplatesTemplateIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=TemplatesApiResourcesSwagger.PutTemplatesTemplateIdResponse.class))})})
    public String saveTemplate(@PathParam(value="templateId") @Parameter(description="templateId") Long templateId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateTemplate(templateId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @DELETE
    @Path(value="{templateId}")
    @Operation(summary="Delete a UGD", description="")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=TemplatesApiResourcesSwagger.DeleteTemplatesTemplateIdResponse.class))})})
    public String deleteTemplate(@PathParam(value="templateId") @Parameter(description="templateId") Long templateId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteTemplate(templateId).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @POST
    @Path(value="{templateId}")
    @Produces(value={"text/html"})
    public String mergeTemplate(@PathParam(value="templateId") Long templateId, @Context UriInfo uriInfo, String apiRequestBodyAsJson) throws IOException {
        Template template = this.templateService.findOneById(templateId);
        HashMap result = (HashMap)new ObjectMapper().readValue(apiRequestBodyAsJson, HashMap.class);
        MultivaluedMap parameters = uriInfo.getQueryParameters();
        HashMap<String, Object> parametersMap = new HashMap<String, Object>();
        for (Map.Entry entry : parameters.entrySet()) {
            if (((List)entry.getValue()).size() == 1) {
                parametersMap.put((String)entry.getKey(), ((List)entry.getValue()).get(0));
                continue;
            }
            parametersMap.put((String)entry.getKey(), entry.getValue());
        }
        parametersMap.put("BASE_URI", uriInfo.getBaseUri());
        parametersMap.putAll(result);
        return this.templateMergeService.compile(template, parametersMap);
    }

    @Generated
    public TemplatesApiResource(PlatformSecurityContext context, DefaultToApiJsonSerializer<Template> toApiJsonSerializer, DefaultToApiJsonSerializer<TemplateData> templateDataApiJsonSerializer, ApiRequestParameterHelper apiRequestParameterHelper, TemplateDomainService templateService, TemplateMergeService templateMergeService, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService) {
        this.context = context;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.templateDataApiJsonSerializer = templateDataApiJsonSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.templateService = templateService;
        this.templateMergeService = templateMergeService;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
    }
}

