/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.useradministration.service;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.useradministration.command.PermissionsCommand;
import org.apache.fineract.useradministration.domain.Permission;
import org.apache.fineract.useradministration.domain.PermissionRepository;
import org.apache.fineract.useradministration.exception.PermissionNotFoundException;
import org.apache.fineract.useradministration.serialization.PermissionsCommandFromApiJsonDeserializer;
import org.apache.fineract.useradministration.service.PermissionWritePlatformService;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Caching;
import org.springframework.transaction.annotation.Transactional;

public class PermissionWritePlatformServiceJpaRepositoryImpl
implements PermissionWritePlatformService {
    private final PlatformSecurityContext context;
    private final PermissionRepository permissionRepository;
    private final PermissionsCommandFromApiJsonDeserializer fromApiJsonDeserializer;

    @Caching(evict={@CacheEvict(value={"users"}, allEntries=true), @CacheEvict(value={"usersByUsername"}, allEntries=true)})
    @Transactional
    public CommandProcessingResult updateMakerCheckerPermissions(JsonCommand command) {
        this.context.authenticatedUser();
        List allPermissions = this.permissionRepository.findAll();
        PermissionsCommand permissionsCommand = this.fromApiJsonDeserializer.commandFromApiJson(command.json());
        Map commandPermissions = permissionsCommand.getPermissions();
        HashMap changes = new HashMap();
        HashMap<String, Boolean> changedPermissions = new HashMap<String, Boolean>();
        for (Map.Entry entry : commandPermissions.entrySet()) {
            Permission permission = this.findPermissionInCollectionByCode((Collection)allPermissions, (String)entry.getKey());
            if (permission.getCode().endsWith("_CHECKER") || permission.getCode().startsWith("READ_") || permission.getGrouping().equalsIgnoreCase("special")) {
                throw new PermissionNotFoundException((String)entry.getKey());
            }
            boolean isSelected = (Boolean)entry.getValue();
            boolean changed = permission.enableMakerChecker(isSelected);
            if (!changed) continue;
            changedPermissions.put((String)entry.getKey(), isSelected);
            this.permissionRepository.saveAndFlush((Object)permission);
        }
        if (!changedPermissions.isEmpty()) {
            changes.put("permissions", changedPermissions);
        }
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).with(changes).build();
    }

    private Permission findPermissionInCollectionByCode(Collection<Permission> allPermissions, String permissionCode) {
        if (allPermissions != null) {
            for (Permission permission : allPermissions) {
                if (!permission.hasCode(permissionCode)) continue;
                return permission;
            }
        }
        throw new PermissionNotFoundException(permissionCode);
    }

    @Generated
    public PermissionWritePlatformServiceJpaRepositoryImpl(PlatformSecurityContext context, PermissionRepository permissionRepository, PermissionsCommandFromApiJsonDeserializer fromApiJsonDeserializer) {
        this.context = context;
        this.permissionRepository = permissionRepository;
        this.fromApiJsonDeserializer = fromApiJsonDeserializer;
    }
}

