/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.13.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fineract.client.models.FinancialActivityData;
import org.apache.fineract.client.models.GLAccountData;

/**
 * FinancialActivityAccountData
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class FinancialActivityAccountData {
  public static final String SERIALIZED_NAME_FINANCIAL_ACTIVITY_DATA = "financialActivityData";
  @SerializedName(SERIALIZED_NAME_FINANCIAL_ACTIVITY_DATA)
  private FinancialActivityData financialActivityData;

  public static final String SERIALIZED_NAME_FINANCIAL_ACTIVITY_OPTIONS = "financialActivityOptions";
  @SerializedName(SERIALIZED_NAME_FINANCIAL_ACTIVITY_OPTIONS)
  private List<FinancialActivityData> financialActivityOptions;

  public static final String SERIALIZED_NAME_GL_ACCOUNT_DATA = "glAccountData";
  @SerializedName(SERIALIZED_NAME_GL_ACCOUNT_DATA)
  private GLAccountData glAccountData;

  public static final String SERIALIZED_NAME_GL_ACCOUNT_OPTIONS = "glAccountOptions";
  @SerializedName(SERIALIZED_NAME_GL_ACCOUNT_OPTIONS)
  private Map<String, List<GLAccountData>> glAccountOptions;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Long id;

  public FinancialActivityAccountData() {
  }

  public FinancialActivityAccountData financialActivityData(FinancialActivityData financialActivityData) {
    
    this.financialActivityData = financialActivityData;
    return this;
  }

  /**
   * Get financialActivityData
   * @return financialActivityData
   */
  @javax.annotation.Nullable

  public FinancialActivityData getFinancialActivityData() {
    return financialActivityData;
  }


  public void setFinancialActivityData(FinancialActivityData financialActivityData) {
    this.financialActivityData = financialActivityData;
  }

  public FinancialActivityAccountData financialActivityOptions(List<FinancialActivityData> financialActivityOptions) {
    
    this.financialActivityOptions = financialActivityOptions;
    return this;
  }

  public FinancialActivityAccountData addFinancialActivityOptionsItem(FinancialActivityData financialActivityOptionsItem) {
    if (this.financialActivityOptions == null) {
      this.financialActivityOptions = new ArrayList<>();
    }
    this.financialActivityOptions.add(financialActivityOptionsItem);
    return this;
  }

  /**
   * Get financialActivityOptions
   * @return financialActivityOptions
   */
  @javax.annotation.Nullable

  public List<FinancialActivityData> getFinancialActivityOptions() {
    return financialActivityOptions;
  }


  public void setFinancialActivityOptions(List<FinancialActivityData> financialActivityOptions) {
    this.financialActivityOptions = financialActivityOptions;
  }

  public FinancialActivityAccountData glAccountData(GLAccountData glAccountData) {
    
    this.glAccountData = glAccountData;
    return this;
  }

  /**
   * Get glAccountData
   * @return glAccountData
   */
  @javax.annotation.Nullable

  public GLAccountData getGlAccountData() {
    return glAccountData;
  }


  public void setGlAccountData(GLAccountData glAccountData) {
    this.glAccountData = glAccountData;
  }

  public FinancialActivityAccountData glAccountOptions(Map<String, List<GLAccountData>> glAccountOptions) {
    
    this.glAccountOptions = glAccountOptions;
    return this;
  }

  public FinancialActivityAccountData putGlAccountOptionsItem(String key, List<GLAccountData> glAccountOptionsItem) {
    if (this.glAccountOptions == null) {
      this.glAccountOptions = new HashMap<>();
    }
    this.glAccountOptions.put(key, glAccountOptionsItem);
    return this;
  }

  /**
   * Get glAccountOptions
   * @return glAccountOptions
   */
  @javax.annotation.Nullable

  public Map<String, List<GLAccountData>> getGlAccountOptions() {
    return glAccountOptions;
  }


  public void setGlAccountOptions(Map<String, List<GLAccountData>> glAccountOptions) {
    this.glAccountOptions = glAccountOptions;
  }

  public FinancialActivityAccountData id(Long id) {
    
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   */
  @javax.annotation.Nullable

  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FinancialActivityAccountData financialActivityAccountData = (FinancialActivityAccountData) o;
    return Objects.equals(this.financialActivityData, financialActivityAccountData.financialActivityData) &&
        Objects.equals(this.financialActivityOptions, financialActivityAccountData.financialActivityOptions) &&
        Objects.equals(this.glAccountData, financialActivityAccountData.glAccountData) &&
        Objects.equals(this.glAccountOptions, financialActivityAccountData.glAccountOptions) &&
        Objects.equals(this.id, financialActivityAccountData.id);
  }

  @Override
  public int hashCode() {
    return Objects.hash(financialActivityData, financialActivityOptions, glAccountData, glAccountOptions, id);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FinancialActivityAccountData {\n");
    sb.append("    financialActivityData: ").append(toIndentedString(financialActivityData)).append("\n");
    sb.append("    financialActivityOptions: ").append(toIndentedString(financialActivityOptions)).append("\n");
    sb.append("    glAccountData: ").append(toIndentedString(glAccountData)).append("\n");
    sb.append("    glAccountOptions: ").append(toIndentedString(glAccountOptions)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

