/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.13.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.fineract.client.models.AccountTransferData;
import org.apache.fineract.client.models.CodeValueData;
import org.apache.fineract.client.models.CurrencyData;
import org.apache.fineract.client.models.ExternalId;
import org.apache.fineract.client.models.LoanChargePaidByData;
import org.apache.fineract.client.models.LoanRepaymentScheduleInstallmentData;
import org.apache.fineract.client.models.LoanTransactionEnumData;
import org.apache.fineract.client.models.LoanTransactionRelationData;
import org.apache.fineract.client.models.PaymentDetailData;
import org.apache.fineract.client.models.PaymentTypeData;

/**
 * LoanTransactionData
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class LoanTransactionData {
  public static final String SERIALIZED_NAME_ACCOUNT_ID = "accountId";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_ID)
  private Long accountId;

  public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "accountNumber";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_NUMBER)
  private String accountNumber;

  public static final String SERIALIZED_NAME_AMOUNT = "amount";
  @SerializedName(SERIALIZED_NAME_AMOUNT)
  private BigDecimal amount;

  public static final String SERIALIZED_NAME_AVAILABLE_DISBURSEMENT_AMOUNT_WITH_OVER_APPLIED = "availableDisbursementAmountWithOverApplied";
  @SerializedName(SERIALIZED_NAME_AVAILABLE_DISBURSEMENT_AMOUNT_WITH_OVER_APPLIED)
  private BigDecimal availableDisbursementAmountWithOverApplied;

  public static final String SERIALIZED_NAME_BANK_NUMBER = "bankNumber";
  @SerializedName(SERIALIZED_NAME_BANK_NUMBER)
  private Integer bankNumber;

  public static final String SERIALIZED_NAME_CHARGE_OFF_REASON_OPTIONS = "chargeOffReasonOptions";
  @SerializedName(SERIALIZED_NAME_CHARGE_OFF_REASON_OPTIONS)
  private List<CodeValueData> chargeOffReasonOptions;

  public static final String SERIALIZED_NAME_CHECK_NUMBER = "checkNumber";
  @SerializedName(SERIALIZED_NAME_CHECK_NUMBER)
  private Integer checkNumber;

  public static final String SERIALIZED_NAME_CLASSIFICATION = "classification";
  @SerializedName(SERIALIZED_NAME_CLASSIFICATION)
  private CodeValueData classification;

  public static final String SERIALIZED_NAME_CLASSIFICATION_OPTIONS = "classificationOptions";
  @SerializedName(SERIALIZED_NAME_CLASSIFICATION_OPTIONS)
  private List<CodeValueData> classificationOptions;

  public static final String SERIALIZED_NAME_CURRENCY = "currency";
  @SerializedName(SERIALIZED_NAME_CURRENCY)
  private CurrencyData currency;

  public static final String SERIALIZED_NAME_DATE = "date";
  @SerializedName(SERIALIZED_NAME_DATE)
  private LocalDate date;

  public static final String SERIALIZED_NAME_DATE_FORMAT = "dateFormat";
  @SerializedName(SERIALIZED_NAME_DATE_FORMAT)
  private String dateFormat;

  public static final String SERIALIZED_NAME_EXTERNAL_ID = "externalId";
  @SerializedName(SERIALIZED_NAME_EXTERNAL_ID)
  private ExternalId externalId;

  public static final String SERIALIZED_NAME_EXTERNAL_LOAN_ID = "externalLoanId";
  @SerializedName(SERIALIZED_NAME_EXTERNAL_LOAN_ID)
  private ExternalId externalLoanId;

  public static final String SERIALIZED_NAME_FEE_CHARGES_PORTION = "feeChargesPortion";
  @SerializedName(SERIALIZED_NAME_FEE_CHARGES_PORTION)
  private BigDecimal feeChargesPortion;

  public static final String SERIALIZED_NAME_FIXED_EMI_AMOUNT = "fixedEmiAmount";
  @SerializedName(SERIALIZED_NAME_FIXED_EMI_AMOUNT)
  private BigDecimal fixedEmiAmount;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Long id;

  public static final String SERIALIZED_NAME_INTEREST_PORTION = "interestPortion";
  @SerializedName(SERIALIZED_NAME_INTEREST_PORTION)
  private BigDecimal interestPortion;

  public static final String SERIALIZED_NAME_LOAN_CHARGE_PAID_BY_LIST = "loanChargePaidByList";
  @SerializedName(SERIALIZED_NAME_LOAN_CHARGE_PAID_BY_LIST)
  private List<LoanChargePaidByData> loanChargePaidByList;

  public static final String SERIALIZED_NAME_LOAN_ID = "loanId";
  @SerializedName(SERIALIZED_NAME_LOAN_ID)
  private Long loanId;

  public static final String SERIALIZED_NAME_LOAN_REPAYMENT_SCHEDULE_INSTALLMENTS = "loanRepaymentScheduleInstallments";
  @SerializedName(SERIALIZED_NAME_LOAN_REPAYMENT_SCHEDULE_INSTALLMENTS)
  private List<LoanRepaymentScheduleInstallmentData> loanRepaymentScheduleInstallments;

  public static final String SERIALIZED_NAME_LOCALE = "locale";
  @SerializedName(SERIALIZED_NAME_LOCALE)
  private String locale;

  public static final String SERIALIZED_NAME_MANUALLY_REVERSED = "manuallyReversed";
  @SerializedName(SERIALIZED_NAME_MANUALLY_REVERSED)
  private Boolean manuallyReversed;

  public static final String SERIALIZED_NAME_NET_DISBURSAL_AMOUNT = "netDisbursalAmount";
  @SerializedName(SERIALIZED_NAME_NET_DISBURSAL_AMOUNT)
  private BigDecimal netDisbursalAmount;

  public static final String SERIALIZED_NAME_NUMBER_OF_REPAYMENTS = "numberOfRepayments";
  @SerializedName(SERIALIZED_NAME_NUMBER_OF_REPAYMENTS)
  private Integer numberOfRepayments;

  public static final String SERIALIZED_NAME_OFFICE_ID = "officeId";
  @SerializedName(SERIALIZED_NAME_OFFICE_ID)
  private Long officeId;

  public static final String SERIALIZED_NAME_OFFICE_NAME = "officeName";
  @SerializedName(SERIALIZED_NAME_OFFICE_NAME)
  private String officeName;

  public static final String SERIALIZED_NAME_OUTSTANDING_LOAN_BALANCE = "outstandingLoanBalance";
  @SerializedName(SERIALIZED_NAME_OUTSTANDING_LOAN_BALANCE)
  private BigDecimal outstandingLoanBalance;

  public static final String SERIALIZED_NAME_OVERPAYMENT_PORTION = "overpaymentPortion";
  @SerializedName(SERIALIZED_NAME_OVERPAYMENT_PORTION)
  private BigDecimal overpaymentPortion;

  public static final String SERIALIZED_NAME_PAYMENT_DETAIL_DATA = "paymentDetailData";
  @SerializedName(SERIALIZED_NAME_PAYMENT_DETAIL_DATA)
  private PaymentDetailData paymentDetailData;

  public static final String SERIALIZED_NAME_PAYMENT_TYPE_ID = "paymentTypeId";
  @SerializedName(SERIALIZED_NAME_PAYMENT_TYPE_ID)
  private Long paymentTypeId;

  public static final String SERIALIZED_NAME_PAYMENT_TYPE_OPTIONS = "paymentTypeOptions";
  @SerializedName(SERIALIZED_NAME_PAYMENT_TYPE_OPTIONS)
  private List<PaymentTypeData> paymentTypeOptions;

  public static final String SERIALIZED_NAME_PENALTY_CHARGES_PORTION = "penaltyChargesPortion";
  @SerializedName(SERIALIZED_NAME_PENALTY_CHARGES_PORTION)
  private BigDecimal penaltyChargesPortion;

  public static final String SERIALIZED_NAME_POSSIBLE_NEXT_REPAYMENT_DATE = "possibleNextRepaymentDate";
  @SerializedName(SERIALIZED_NAME_POSSIBLE_NEXT_REPAYMENT_DATE)
  private LocalDate possibleNextRepaymentDate;

  public static final String SERIALIZED_NAME_PRINCIPAL_PORTION = "principalPortion";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL_PORTION)
  private BigDecimal principalPortion;

  public static final String SERIALIZED_NAME_RECEIPT_NUMBER = "receiptNumber";
  @SerializedName(SERIALIZED_NAME_RECEIPT_NUMBER)
  private Integer receiptNumber;

  public static final String SERIALIZED_NAME_REVERSAL_EXTERNAL_ID = "reversalExternalId";
  @SerializedName(SERIALIZED_NAME_REVERSAL_EXTERNAL_ID)
  private ExternalId reversalExternalId;

  public static final String SERIALIZED_NAME_REVERSED_ON_DATE = "reversedOnDate";
  @SerializedName(SERIALIZED_NAME_REVERSED_ON_DATE)
  private LocalDate reversedOnDate;

  public static final String SERIALIZED_NAME_ROUTING_CODE = "routingCode";
  @SerializedName(SERIALIZED_NAME_ROUTING_CODE)
  private Integer routingCode;

  public static final String SERIALIZED_NAME_ROW_INDEX = "rowIndex";
  @SerializedName(SERIALIZED_NAME_ROW_INDEX)
  private Integer rowIndex;

  public static final String SERIALIZED_NAME_SUBMITTED_ON_DATE = "submittedOnDate";
  @SerializedName(SERIALIZED_NAME_SUBMITTED_ON_DATE)
  private LocalDate submittedOnDate;

  public static final String SERIALIZED_NAME_TRANSACTION_AMOUNT = "transactionAmount";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_AMOUNT)
  private BigDecimal transactionAmount;

  public static final String SERIALIZED_NAME_TRANSACTION_DATE = "transactionDate";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_DATE)
  private LocalDate transactionDate;

  public static final String SERIALIZED_NAME_TRANSACTION_RELATIONS = "transactionRelations";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_RELATIONS)
  private List<LoanTransactionRelationData> transactionRelations;

  public static final String SERIALIZED_NAME_TRANSACTION_TYPE = "transactionType";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_TYPE)
  private String transactionType;

  public static final String SERIALIZED_NAME_TRANSFER = "transfer";
  @SerializedName(SERIALIZED_NAME_TRANSFER)
  private AccountTransferData transfer;

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private LoanTransactionEnumData type;

  public static final String SERIALIZED_NAME_UNRECOGNIZED_INCOME_PORTION = "unrecognizedIncomePortion";
  @SerializedName(SERIALIZED_NAME_UNRECOGNIZED_INCOME_PORTION)
  private BigDecimal unrecognizedIncomePortion;

  public static final String SERIALIZED_NAME_WRITE_OFF_REASON_OPTIONS = "writeOffReasonOptions";
  @SerializedName(SERIALIZED_NAME_WRITE_OFF_REASON_OPTIONS)
  private List<CodeValueData> writeOffReasonOptions;

  public LoanTransactionData() {
  }

  public LoanTransactionData accountId(Long accountId) {
    
    this.accountId = accountId;
    return this;
  }

  /**
   * Get accountId
   * @return accountId
   */
  @javax.annotation.Nullable

  public Long getAccountId() {
    return accountId;
  }


  public void setAccountId(Long accountId) {
    this.accountId = accountId;
  }

  public LoanTransactionData accountNumber(String accountNumber) {
    
    this.accountNumber = accountNumber;
    return this;
  }

  /**
   * Get accountNumber
   * @return accountNumber
   */
  @javax.annotation.Nullable

  public String getAccountNumber() {
    return accountNumber;
  }


  public void setAccountNumber(String accountNumber) {
    this.accountNumber = accountNumber;
  }

  public LoanTransactionData amount(BigDecimal amount) {
    
    this.amount = amount;
    return this;
  }

  /**
   * Get amount
   * @return amount
   */
  @javax.annotation.Nullable

  public BigDecimal getAmount() {
    return amount;
  }


  public void setAmount(BigDecimal amount) {
    this.amount = amount;
  }

  public LoanTransactionData availableDisbursementAmountWithOverApplied(BigDecimal availableDisbursementAmountWithOverApplied) {
    
    this.availableDisbursementAmountWithOverApplied = availableDisbursementAmountWithOverApplied;
    return this;
  }

  /**
   * Get availableDisbursementAmountWithOverApplied
   * @return availableDisbursementAmountWithOverApplied
   */
  @javax.annotation.Nullable

  public BigDecimal getAvailableDisbursementAmountWithOverApplied() {
    return availableDisbursementAmountWithOverApplied;
  }


  public void setAvailableDisbursementAmountWithOverApplied(BigDecimal availableDisbursementAmountWithOverApplied) {
    this.availableDisbursementAmountWithOverApplied = availableDisbursementAmountWithOverApplied;
  }

  public LoanTransactionData bankNumber(Integer bankNumber) {
    
    this.bankNumber = bankNumber;
    return this;
  }

  /**
   * Get bankNumber
   * @return bankNumber
   */
  @javax.annotation.Nullable

  public Integer getBankNumber() {
    return bankNumber;
  }


  public void setBankNumber(Integer bankNumber) {
    this.bankNumber = bankNumber;
  }

  public LoanTransactionData chargeOffReasonOptions(List<CodeValueData> chargeOffReasonOptions) {
    
    this.chargeOffReasonOptions = chargeOffReasonOptions;
    return this;
  }

  public LoanTransactionData addChargeOffReasonOptionsItem(CodeValueData chargeOffReasonOptionsItem) {
    if (this.chargeOffReasonOptions == null) {
      this.chargeOffReasonOptions = new ArrayList<>();
    }
    this.chargeOffReasonOptions.add(chargeOffReasonOptionsItem);
    return this;
  }

  /**
   * Get chargeOffReasonOptions
   * @return chargeOffReasonOptions
   */
  @javax.annotation.Nullable

  public List<CodeValueData> getChargeOffReasonOptions() {
    return chargeOffReasonOptions;
  }


  public void setChargeOffReasonOptions(List<CodeValueData> chargeOffReasonOptions) {
    this.chargeOffReasonOptions = chargeOffReasonOptions;
  }

  public LoanTransactionData checkNumber(Integer checkNumber) {
    
    this.checkNumber = checkNumber;
    return this;
  }

  /**
   * Get checkNumber
   * @return checkNumber
   */
  @javax.annotation.Nullable

  public Integer getCheckNumber() {
    return checkNumber;
  }


  public void setCheckNumber(Integer checkNumber) {
    this.checkNumber = checkNumber;
  }

  public LoanTransactionData classification(CodeValueData classification) {
    
    this.classification = classification;
    return this;
  }

  /**
   * Get classification
   * @return classification
   */
  @javax.annotation.Nullable

  public CodeValueData getClassification() {
    return classification;
  }


  public void setClassification(CodeValueData classification) {
    this.classification = classification;
  }

  public LoanTransactionData classificationOptions(List<CodeValueData> classificationOptions) {
    
    this.classificationOptions = classificationOptions;
    return this;
  }

  public LoanTransactionData addClassificationOptionsItem(CodeValueData classificationOptionsItem) {
    if (this.classificationOptions == null) {
      this.classificationOptions = new ArrayList<>();
    }
    this.classificationOptions.add(classificationOptionsItem);
    return this;
  }

  /**
   * Get classificationOptions
   * @return classificationOptions
   */
  @javax.annotation.Nullable

  public List<CodeValueData> getClassificationOptions() {
    return classificationOptions;
  }


  public void setClassificationOptions(List<CodeValueData> classificationOptions) {
    this.classificationOptions = classificationOptions;
  }

  public LoanTransactionData currency(CurrencyData currency) {
    
    this.currency = currency;
    return this;
  }

  /**
   * Get currency
   * @return currency
   */
  @javax.annotation.Nullable

  public CurrencyData getCurrency() {
    return currency;
  }


  public void setCurrency(CurrencyData currency) {
    this.currency = currency;
  }

  public LoanTransactionData date(LocalDate date) {
    
    this.date = date;
    return this;
  }

  /**
   * Get date
   * @return date
   */
  @javax.annotation.Nullable

  public LocalDate getDate() {
    return date;
  }


  public void setDate(LocalDate date) {
    this.date = date;
  }

  public LoanTransactionData dateFormat(String dateFormat) {
    
    this.dateFormat = dateFormat;
    return this;
  }

  /**
   * Get dateFormat
   * @return dateFormat
   */
  @javax.annotation.Nullable

  public String getDateFormat() {
    return dateFormat;
  }


  public void setDateFormat(String dateFormat) {
    this.dateFormat = dateFormat;
  }

  public LoanTransactionData externalId(ExternalId externalId) {
    
    this.externalId = externalId;
    return this;
  }

  /**
   * Get externalId
   * @return externalId
   */
  @javax.annotation.Nullable

  public ExternalId getExternalId() {
    return externalId;
  }


  public void setExternalId(ExternalId externalId) {
    this.externalId = externalId;
  }

  public LoanTransactionData externalLoanId(ExternalId externalLoanId) {
    
    this.externalLoanId = externalLoanId;
    return this;
  }

  /**
   * Get externalLoanId
   * @return externalLoanId
   */
  @javax.annotation.Nullable

  public ExternalId getExternalLoanId() {
    return externalLoanId;
  }


  public void setExternalLoanId(ExternalId externalLoanId) {
    this.externalLoanId = externalLoanId;
  }

  public LoanTransactionData feeChargesPortion(BigDecimal feeChargesPortion) {
    
    this.feeChargesPortion = feeChargesPortion;
    return this;
  }

  /**
   * Get feeChargesPortion
   * @return feeChargesPortion
   */
  @javax.annotation.Nullable

  public BigDecimal getFeeChargesPortion() {
    return feeChargesPortion;
  }


  public void setFeeChargesPortion(BigDecimal feeChargesPortion) {
    this.feeChargesPortion = feeChargesPortion;
  }

  public LoanTransactionData fixedEmiAmount(BigDecimal fixedEmiAmount) {
    
    this.fixedEmiAmount = fixedEmiAmount;
    return this;
  }

  /**
   * Get fixedEmiAmount
   * @return fixedEmiAmount
   */
  @javax.annotation.Nullable

  public BigDecimal getFixedEmiAmount() {
    return fixedEmiAmount;
  }


  public void setFixedEmiAmount(BigDecimal fixedEmiAmount) {
    this.fixedEmiAmount = fixedEmiAmount;
  }

  public LoanTransactionData id(Long id) {
    
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   */
  @javax.annotation.Nullable

  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }

  public LoanTransactionData interestPortion(BigDecimal interestPortion) {
    
    this.interestPortion = interestPortion;
    return this;
  }

  /**
   * Get interestPortion
   * @return interestPortion
   */
  @javax.annotation.Nullable

  public BigDecimal getInterestPortion() {
    return interestPortion;
  }


  public void setInterestPortion(BigDecimal interestPortion) {
    this.interestPortion = interestPortion;
  }

  public LoanTransactionData loanChargePaidByList(List<LoanChargePaidByData> loanChargePaidByList) {
    
    this.loanChargePaidByList = loanChargePaidByList;
    return this;
  }

  public LoanTransactionData addLoanChargePaidByListItem(LoanChargePaidByData loanChargePaidByListItem) {
    if (this.loanChargePaidByList == null) {
      this.loanChargePaidByList = new ArrayList<>();
    }
    this.loanChargePaidByList.add(loanChargePaidByListItem);
    return this;
  }

  /**
   * Get loanChargePaidByList
   * @return loanChargePaidByList
   */
  @javax.annotation.Nullable

  public List<LoanChargePaidByData> getLoanChargePaidByList() {
    return loanChargePaidByList;
  }


  public void setLoanChargePaidByList(List<LoanChargePaidByData> loanChargePaidByList) {
    this.loanChargePaidByList = loanChargePaidByList;
  }

  public LoanTransactionData loanId(Long loanId) {
    
    this.loanId = loanId;
    return this;
  }

  /**
   * Get loanId
   * @return loanId
   */
  @javax.annotation.Nullable

  public Long getLoanId() {
    return loanId;
  }


  public void setLoanId(Long loanId) {
    this.loanId = loanId;
  }

  public LoanTransactionData loanRepaymentScheduleInstallments(List<LoanRepaymentScheduleInstallmentData> loanRepaymentScheduleInstallments) {
    
    this.loanRepaymentScheduleInstallments = loanRepaymentScheduleInstallments;
    return this;
  }

  public LoanTransactionData addLoanRepaymentScheduleInstallmentsItem(LoanRepaymentScheduleInstallmentData loanRepaymentScheduleInstallmentsItem) {
    if (this.loanRepaymentScheduleInstallments == null) {
      this.loanRepaymentScheduleInstallments = new ArrayList<>();
    }
    this.loanRepaymentScheduleInstallments.add(loanRepaymentScheduleInstallmentsItem);
    return this;
  }

  /**
   * Get loanRepaymentScheduleInstallments
   * @return loanRepaymentScheduleInstallments
   */
  @javax.annotation.Nullable

  public List<LoanRepaymentScheduleInstallmentData> getLoanRepaymentScheduleInstallments() {
    return loanRepaymentScheduleInstallments;
  }


  public void setLoanRepaymentScheduleInstallments(List<LoanRepaymentScheduleInstallmentData> loanRepaymentScheduleInstallments) {
    this.loanRepaymentScheduleInstallments = loanRepaymentScheduleInstallments;
  }

  public LoanTransactionData locale(String locale) {
    
    this.locale = locale;
    return this;
  }

  /**
   * Get locale
   * @return locale
   */
  @javax.annotation.Nullable

  public String getLocale() {
    return locale;
  }


  public void setLocale(String locale) {
    this.locale = locale;
  }

  public LoanTransactionData manuallyReversed(Boolean manuallyReversed) {
    
    this.manuallyReversed = manuallyReversed;
    return this;
  }

  /**
   * Get manuallyReversed
   * @return manuallyReversed
   */
  @javax.annotation.Nullable

  public Boolean getManuallyReversed() {
    return manuallyReversed;
  }


  public void setManuallyReversed(Boolean manuallyReversed) {
    this.manuallyReversed = manuallyReversed;
  }

  public LoanTransactionData netDisbursalAmount(BigDecimal netDisbursalAmount) {
    
    this.netDisbursalAmount = netDisbursalAmount;
    return this;
  }

  /**
   * Get netDisbursalAmount
   * @return netDisbursalAmount
   */
  @javax.annotation.Nullable

  public BigDecimal getNetDisbursalAmount() {
    return netDisbursalAmount;
  }


  public void setNetDisbursalAmount(BigDecimal netDisbursalAmount) {
    this.netDisbursalAmount = netDisbursalAmount;
  }

  public LoanTransactionData numberOfRepayments(Integer numberOfRepayments) {
    
    this.numberOfRepayments = numberOfRepayments;
    return this;
  }

  /**
   * Get numberOfRepayments
   * @return numberOfRepayments
   */
  @javax.annotation.Nullable

  public Integer getNumberOfRepayments() {
    return numberOfRepayments;
  }


  public void setNumberOfRepayments(Integer numberOfRepayments) {
    this.numberOfRepayments = numberOfRepayments;
  }

  public LoanTransactionData officeId(Long officeId) {
    
    this.officeId = officeId;
    return this;
  }

  /**
   * Get officeId
   * @return officeId
   */
  @javax.annotation.Nullable

  public Long getOfficeId() {
    return officeId;
  }


  public void setOfficeId(Long officeId) {
    this.officeId = officeId;
  }

  public LoanTransactionData officeName(String officeName) {
    
    this.officeName = officeName;
    return this;
  }

  /**
   * Get officeName
   * @return officeName
   */
  @javax.annotation.Nullable

  public String getOfficeName() {
    return officeName;
  }


  public void setOfficeName(String officeName) {
    this.officeName = officeName;
  }

  public LoanTransactionData outstandingLoanBalance(BigDecimal outstandingLoanBalance) {
    
    this.outstandingLoanBalance = outstandingLoanBalance;
    return this;
  }

  /**
   * Get outstandingLoanBalance
   * @return outstandingLoanBalance
   */
  @javax.annotation.Nullable

  public BigDecimal getOutstandingLoanBalance() {
    return outstandingLoanBalance;
  }


  public void setOutstandingLoanBalance(BigDecimal outstandingLoanBalance) {
    this.outstandingLoanBalance = outstandingLoanBalance;
  }

  public LoanTransactionData overpaymentPortion(BigDecimal overpaymentPortion) {
    
    this.overpaymentPortion = overpaymentPortion;
    return this;
  }

  /**
   * Get overpaymentPortion
   * @return overpaymentPortion
   */
  @javax.annotation.Nullable

  public BigDecimal getOverpaymentPortion() {
    return overpaymentPortion;
  }


  public void setOverpaymentPortion(BigDecimal overpaymentPortion) {
    this.overpaymentPortion = overpaymentPortion;
  }

  public LoanTransactionData paymentDetailData(PaymentDetailData paymentDetailData) {
    
    this.paymentDetailData = paymentDetailData;
    return this;
  }

  /**
   * Get paymentDetailData
   * @return paymentDetailData
   */
  @javax.annotation.Nullable

  public PaymentDetailData getPaymentDetailData() {
    return paymentDetailData;
  }


  public void setPaymentDetailData(PaymentDetailData paymentDetailData) {
    this.paymentDetailData = paymentDetailData;
  }

  public LoanTransactionData paymentTypeId(Long paymentTypeId) {
    
    this.paymentTypeId = paymentTypeId;
    return this;
  }

  /**
   * Get paymentTypeId
   * @return paymentTypeId
   */
  @javax.annotation.Nullable

  public Long getPaymentTypeId() {
    return paymentTypeId;
  }


  public void setPaymentTypeId(Long paymentTypeId) {
    this.paymentTypeId = paymentTypeId;
  }

  public LoanTransactionData paymentTypeOptions(List<PaymentTypeData> paymentTypeOptions) {
    
    this.paymentTypeOptions = paymentTypeOptions;
    return this;
  }

  public LoanTransactionData addPaymentTypeOptionsItem(PaymentTypeData paymentTypeOptionsItem) {
    if (this.paymentTypeOptions == null) {
      this.paymentTypeOptions = new ArrayList<>();
    }
    this.paymentTypeOptions.add(paymentTypeOptionsItem);
    return this;
  }

  /**
   * Get paymentTypeOptions
   * @return paymentTypeOptions
   */
  @javax.annotation.Nullable

  public List<PaymentTypeData> getPaymentTypeOptions() {
    return paymentTypeOptions;
  }


  public void setPaymentTypeOptions(List<PaymentTypeData> paymentTypeOptions) {
    this.paymentTypeOptions = paymentTypeOptions;
  }

  public LoanTransactionData penaltyChargesPortion(BigDecimal penaltyChargesPortion) {
    
    this.penaltyChargesPortion = penaltyChargesPortion;
    return this;
  }

  /**
   * Get penaltyChargesPortion
   * @return penaltyChargesPortion
   */
  @javax.annotation.Nullable

  public BigDecimal getPenaltyChargesPortion() {
    return penaltyChargesPortion;
  }


  public void setPenaltyChargesPortion(BigDecimal penaltyChargesPortion) {
    this.penaltyChargesPortion = penaltyChargesPortion;
  }

  public LoanTransactionData possibleNextRepaymentDate(LocalDate possibleNextRepaymentDate) {
    
    this.possibleNextRepaymentDate = possibleNextRepaymentDate;
    return this;
  }

  /**
   * Get possibleNextRepaymentDate
   * @return possibleNextRepaymentDate
   */
  @javax.annotation.Nullable

  public LocalDate getPossibleNextRepaymentDate() {
    return possibleNextRepaymentDate;
  }


  public void setPossibleNextRepaymentDate(LocalDate possibleNextRepaymentDate) {
    this.possibleNextRepaymentDate = possibleNextRepaymentDate;
  }

  public LoanTransactionData principalPortion(BigDecimal principalPortion) {
    
    this.principalPortion = principalPortion;
    return this;
  }

  /**
   * Get principalPortion
   * @return principalPortion
   */
  @javax.annotation.Nullable

  public BigDecimal getPrincipalPortion() {
    return principalPortion;
  }


  public void setPrincipalPortion(BigDecimal principalPortion) {
    this.principalPortion = principalPortion;
  }

  public LoanTransactionData receiptNumber(Integer receiptNumber) {
    
    this.receiptNumber = receiptNumber;
    return this;
  }

  /**
   * Get receiptNumber
   * @return receiptNumber
   */
  @javax.annotation.Nullable

  public Integer getReceiptNumber() {
    return receiptNumber;
  }


  public void setReceiptNumber(Integer receiptNumber) {
    this.receiptNumber = receiptNumber;
  }

  public LoanTransactionData reversalExternalId(ExternalId reversalExternalId) {
    
    this.reversalExternalId = reversalExternalId;
    return this;
  }

  /**
   * Get reversalExternalId
   * @return reversalExternalId
   */
  @javax.annotation.Nullable

  public ExternalId getReversalExternalId() {
    return reversalExternalId;
  }


  public void setReversalExternalId(ExternalId reversalExternalId) {
    this.reversalExternalId = reversalExternalId;
  }

  public LoanTransactionData reversedOnDate(LocalDate reversedOnDate) {
    
    this.reversedOnDate = reversedOnDate;
    return this;
  }

  /**
   * Get reversedOnDate
   * @return reversedOnDate
   */
  @javax.annotation.Nullable

  public LocalDate getReversedOnDate() {
    return reversedOnDate;
  }


  public void setReversedOnDate(LocalDate reversedOnDate) {
    this.reversedOnDate = reversedOnDate;
  }

  public LoanTransactionData routingCode(Integer routingCode) {
    
    this.routingCode = routingCode;
    return this;
  }

  /**
   * Get routingCode
   * @return routingCode
   */
  @javax.annotation.Nullable

  public Integer getRoutingCode() {
    return routingCode;
  }


  public void setRoutingCode(Integer routingCode) {
    this.routingCode = routingCode;
  }

  public LoanTransactionData rowIndex(Integer rowIndex) {
    
    this.rowIndex = rowIndex;
    return this;
  }

  /**
   * Get rowIndex
   * @return rowIndex
   */
  @javax.annotation.Nullable

  public Integer getRowIndex() {
    return rowIndex;
  }


  public void setRowIndex(Integer rowIndex) {
    this.rowIndex = rowIndex;
  }

  public LoanTransactionData submittedOnDate(LocalDate submittedOnDate) {
    
    this.submittedOnDate = submittedOnDate;
    return this;
  }

  /**
   * Get submittedOnDate
   * @return submittedOnDate
   */
  @javax.annotation.Nullable

  public LocalDate getSubmittedOnDate() {
    return submittedOnDate;
  }


  public void setSubmittedOnDate(LocalDate submittedOnDate) {
    this.submittedOnDate = submittedOnDate;
  }

  public LoanTransactionData transactionAmount(BigDecimal transactionAmount) {
    
    this.transactionAmount = transactionAmount;
    return this;
  }

  /**
   * Get transactionAmount
   * @return transactionAmount
   */
  @javax.annotation.Nullable

  public BigDecimal getTransactionAmount() {
    return transactionAmount;
  }


  public void setTransactionAmount(BigDecimal transactionAmount) {
    this.transactionAmount = transactionAmount;
  }

  public LoanTransactionData transactionDate(LocalDate transactionDate) {
    
    this.transactionDate = transactionDate;
    return this;
  }

  /**
   * Get transactionDate
   * @return transactionDate
   */
  @javax.annotation.Nullable

  public LocalDate getTransactionDate() {
    return transactionDate;
  }


  public void setTransactionDate(LocalDate transactionDate) {
    this.transactionDate = transactionDate;
  }

  public LoanTransactionData transactionRelations(List<LoanTransactionRelationData> transactionRelations) {
    
    this.transactionRelations = transactionRelations;
    return this;
  }

  public LoanTransactionData addTransactionRelationsItem(LoanTransactionRelationData transactionRelationsItem) {
    if (this.transactionRelations == null) {
      this.transactionRelations = new ArrayList<>();
    }
    this.transactionRelations.add(transactionRelationsItem);
    return this;
  }

  /**
   * Get transactionRelations
   * @return transactionRelations
   */
  @javax.annotation.Nullable

  public List<LoanTransactionRelationData> getTransactionRelations() {
    return transactionRelations;
  }


  public void setTransactionRelations(List<LoanTransactionRelationData> transactionRelations) {
    this.transactionRelations = transactionRelations;
  }

  public LoanTransactionData transactionType(String transactionType) {
    
    this.transactionType = transactionType;
    return this;
  }

  /**
   * Get transactionType
   * @return transactionType
   */
  @javax.annotation.Nullable

  public String getTransactionType() {
    return transactionType;
  }


  public void setTransactionType(String transactionType) {
    this.transactionType = transactionType;
  }

  public LoanTransactionData transfer(AccountTransferData transfer) {
    
    this.transfer = transfer;
    return this;
  }

  /**
   * Get transfer
   * @return transfer
   */
  @javax.annotation.Nullable

  public AccountTransferData getTransfer() {
    return transfer;
  }


  public void setTransfer(AccountTransferData transfer) {
    this.transfer = transfer;
  }

  public LoanTransactionData type(LoanTransactionEnumData type) {
    
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
   */
  @javax.annotation.Nullable

  public LoanTransactionEnumData getType() {
    return type;
  }


  public void setType(LoanTransactionEnumData type) {
    this.type = type;
  }

  public LoanTransactionData unrecognizedIncomePortion(BigDecimal unrecognizedIncomePortion) {
    
    this.unrecognizedIncomePortion = unrecognizedIncomePortion;
    return this;
  }

  /**
   * Get unrecognizedIncomePortion
   * @return unrecognizedIncomePortion
   */
  @javax.annotation.Nullable

  public BigDecimal getUnrecognizedIncomePortion() {
    return unrecognizedIncomePortion;
  }


  public void setUnrecognizedIncomePortion(BigDecimal unrecognizedIncomePortion) {
    this.unrecognizedIncomePortion = unrecognizedIncomePortion;
  }

  public LoanTransactionData writeOffReasonOptions(List<CodeValueData> writeOffReasonOptions) {
    
    this.writeOffReasonOptions = writeOffReasonOptions;
    return this;
  }

  public LoanTransactionData addWriteOffReasonOptionsItem(CodeValueData writeOffReasonOptionsItem) {
    if (this.writeOffReasonOptions == null) {
      this.writeOffReasonOptions = new ArrayList<>();
    }
    this.writeOffReasonOptions.add(writeOffReasonOptionsItem);
    return this;
  }

  /**
   * Get writeOffReasonOptions
   * @return writeOffReasonOptions
   */
  @javax.annotation.Nullable

  public List<CodeValueData> getWriteOffReasonOptions() {
    return writeOffReasonOptions;
  }


  public void setWriteOffReasonOptions(List<CodeValueData> writeOffReasonOptions) {
    this.writeOffReasonOptions = writeOffReasonOptions;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LoanTransactionData loanTransactionData = (LoanTransactionData) o;
    return Objects.equals(this.accountId, loanTransactionData.accountId) &&
        Objects.equals(this.accountNumber, loanTransactionData.accountNumber) &&
        Objects.equals(this.amount, loanTransactionData.amount) &&
        Objects.equals(this.availableDisbursementAmountWithOverApplied, loanTransactionData.availableDisbursementAmountWithOverApplied) &&
        Objects.equals(this.bankNumber, loanTransactionData.bankNumber) &&
        Objects.equals(this.chargeOffReasonOptions, loanTransactionData.chargeOffReasonOptions) &&
        Objects.equals(this.checkNumber, loanTransactionData.checkNumber) &&
        Objects.equals(this.classification, loanTransactionData.classification) &&
        Objects.equals(this.classificationOptions, loanTransactionData.classificationOptions) &&
        Objects.equals(this.currency, loanTransactionData.currency) &&
        Objects.equals(this.date, loanTransactionData.date) &&
        Objects.equals(this.dateFormat, loanTransactionData.dateFormat) &&
        Objects.equals(this.externalId, loanTransactionData.externalId) &&
        Objects.equals(this.externalLoanId, loanTransactionData.externalLoanId) &&
        Objects.equals(this.feeChargesPortion, loanTransactionData.feeChargesPortion) &&
        Objects.equals(this.fixedEmiAmount, loanTransactionData.fixedEmiAmount) &&
        Objects.equals(this.id, loanTransactionData.id) &&
        Objects.equals(this.interestPortion, loanTransactionData.interestPortion) &&
        Objects.equals(this.loanChargePaidByList, loanTransactionData.loanChargePaidByList) &&
        Objects.equals(this.loanId, loanTransactionData.loanId) &&
        Objects.equals(this.loanRepaymentScheduleInstallments, loanTransactionData.loanRepaymentScheduleInstallments) &&
        Objects.equals(this.locale, loanTransactionData.locale) &&
        Objects.equals(this.manuallyReversed, loanTransactionData.manuallyReversed) &&
        Objects.equals(this.netDisbursalAmount, loanTransactionData.netDisbursalAmount) &&
        Objects.equals(this.numberOfRepayments, loanTransactionData.numberOfRepayments) &&
        Objects.equals(this.officeId, loanTransactionData.officeId) &&
        Objects.equals(this.officeName, loanTransactionData.officeName) &&
        Objects.equals(this.outstandingLoanBalance, loanTransactionData.outstandingLoanBalance) &&
        Objects.equals(this.overpaymentPortion, loanTransactionData.overpaymentPortion) &&
        Objects.equals(this.paymentDetailData, loanTransactionData.paymentDetailData) &&
        Objects.equals(this.paymentTypeId, loanTransactionData.paymentTypeId) &&
        Objects.equals(this.paymentTypeOptions, loanTransactionData.paymentTypeOptions) &&
        Objects.equals(this.penaltyChargesPortion, loanTransactionData.penaltyChargesPortion) &&
        Objects.equals(this.possibleNextRepaymentDate, loanTransactionData.possibleNextRepaymentDate) &&
        Objects.equals(this.principalPortion, loanTransactionData.principalPortion) &&
        Objects.equals(this.receiptNumber, loanTransactionData.receiptNumber) &&
        Objects.equals(this.reversalExternalId, loanTransactionData.reversalExternalId) &&
        Objects.equals(this.reversedOnDate, loanTransactionData.reversedOnDate) &&
        Objects.equals(this.routingCode, loanTransactionData.routingCode) &&
        Objects.equals(this.rowIndex, loanTransactionData.rowIndex) &&
        Objects.equals(this.submittedOnDate, loanTransactionData.submittedOnDate) &&
        Objects.equals(this.transactionAmount, loanTransactionData.transactionAmount) &&
        Objects.equals(this.transactionDate, loanTransactionData.transactionDate) &&
        Objects.equals(this.transactionRelations, loanTransactionData.transactionRelations) &&
        Objects.equals(this.transactionType, loanTransactionData.transactionType) &&
        Objects.equals(this.transfer, loanTransactionData.transfer) &&
        Objects.equals(this.type, loanTransactionData.type) &&
        Objects.equals(this.unrecognizedIncomePortion, loanTransactionData.unrecognizedIncomePortion) &&
        Objects.equals(this.writeOffReasonOptions, loanTransactionData.writeOffReasonOptions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountId, accountNumber, amount, availableDisbursementAmountWithOverApplied, bankNumber, chargeOffReasonOptions, checkNumber, classification, classificationOptions, currency, date, dateFormat, externalId, externalLoanId, feeChargesPortion, fixedEmiAmount, id, interestPortion, loanChargePaidByList, loanId, loanRepaymentScheduleInstallments, locale, manuallyReversed, netDisbursalAmount, numberOfRepayments, officeId, officeName, outstandingLoanBalance, overpaymentPortion, paymentDetailData, paymentTypeId, paymentTypeOptions, penaltyChargesPortion, possibleNextRepaymentDate, principalPortion, receiptNumber, reversalExternalId, reversedOnDate, routingCode, rowIndex, submittedOnDate, transactionAmount, transactionDate, transactionRelations, transactionType, transfer, type, unrecognizedIncomePortion, writeOffReasonOptions);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LoanTransactionData {\n");
    sb.append("    accountId: ").append(toIndentedString(accountId)).append("\n");
    sb.append("    accountNumber: ").append(toIndentedString(accountNumber)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    availableDisbursementAmountWithOverApplied: ").append(toIndentedString(availableDisbursementAmountWithOverApplied)).append("\n");
    sb.append("    bankNumber: ").append(toIndentedString(bankNumber)).append("\n");
    sb.append("    chargeOffReasonOptions: ").append(toIndentedString(chargeOffReasonOptions)).append("\n");
    sb.append("    checkNumber: ").append(toIndentedString(checkNumber)).append("\n");
    sb.append("    classification: ").append(toIndentedString(classification)).append("\n");
    sb.append("    classificationOptions: ").append(toIndentedString(classificationOptions)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    dateFormat: ").append(toIndentedString(dateFormat)).append("\n");
    sb.append("    externalId: ").append(toIndentedString(externalId)).append("\n");
    sb.append("    externalLoanId: ").append(toIndentedString(externalLoanId)).append("\n");
    sb.append("    feeChargesPortion: ").append(toIndentedString(feeChargesPortion)).append("\n");
    sb.append("    fixedEmiAmount: ").append(toIndentedString(fixedEmiAmount)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    interestPortion: ").append(toIndentedString(interestPortion)).append("\n");
    sb.append("    loanChargePaidByList: ").append(toIndentedString(loanChargePaidByList)).append("\n");
    sb.append("    loanId: ").append(toIndentedString(loanId)).append("\n");
    sb.append("    loanRepaymentScheduleInstallments: ").append(toIndentedString(loanRepaymentScheduleInstallments)).append("\n");
    sb.append("    locale: ").append(toIndentedString(locale)).append("\n");
    sb.append("    manuallyReversed: ").append(toIndentedString(manuallyReversed)).append("\n");
    sb.append("    netDisbursalAmount: ").append(toIndentedString(netDisbursalAmount)).append("\n");
    sb.append("    numberOfRepayments: ").append(toIndentedString(numberOfRepayments)).append("\n");
    sb.append("    officeId: ").append(toIndentedString(officeId)).append("\n");
    sb.append("    officeName: ").append(toIndentedString(officeName)).append("\n");
    sb.append("    outstandingLoanBalance: ").append(toIndentedString(outstandingLoanBalance)).append("\n");
    sb.append("    overpaymentPortion: ").append(toIndentedString(overpaymentPortion)).append("\n");
    sb.append("    paymentDetailData: ").append(toIndentedString(paymentDetailData)).append("\n");
    sb.append("    paymentTypeId: ").append(toIndentedString(paymentTypeId)).append("\n");
    sb.append("    paymentTypeOptions: ").append(toIndentedString(paymentTypeOptions)).append("\n");
    sb.append("    penaltyChargesPortion: ").append(toIndentedString(penaltyChargesPortion)).append("\n");
    sb.append("    possibleNextRepaymentDate: ").append(toIndentedString(possibleNextRepaymentDate)).append("\n");
    sb.append("    principalPortion: ").append(toIndentedString(principalPortion)).append("\n");
    sb.append("    receiptNumber: ").append(toIndentedString(receiptNumber)).append("\n");
    sb.append("    reversalExternalId: ").append(toIndentedString(reversalExternalId)).append("\n");
    sb.append("    reversedOnDate: ").append(toIndentedString(reversedOnDate)).append("\n");
    sb.append("    routingCode: ").append(toIndentedString(routingCode)).append("\n");
    sb.append("    rowIndex: ").append(toIndentedString(rowIndex)).append("\n");
    sb.append("    submittedOnDate: ").append(toIndentedString(submittedOnDate)).append("\n");
    sb.append("    transactionAmount: ").append(toIndentedString(transactionAmount)).append("\n");
    sb.append("    transactionDate: ").append(toIndentedString(transactionDate)).append("\n");
    sb.append("    transactionRelations: ").append(toIndentedString(transactionRelations)).append("\n");
    sb.append("    transactionType: ").append(toIndentedString(transactionType)).append("\n");
    sb.append("    transfer: ").append(toIndentedString(transfer)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    unrecognizedIncomePortion: ").append(toIndentedString(unrecognizedIncomePortion)).append("\n");
    sb.append("    writeOffReasonOptions: ").append(toIndentedString(writeOffReasonOptions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

