/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.13.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.fineract.client.models.ChargeData;
import org.apache.fineract.client.models.ChargeFeeOnMonthDay;
import org.apache.fineract.client.models.CurrencyData;
import org.apache.fineract.client.models.EnumOptionData;

/**
 * SavingsAccountChargeData
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class SavingsAccountChargeData {
  public static final String SERIALIZED_NAME_ACCOUNT_ID = "accountId";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_ID)
  private Long accountId;

  public static final String SERIALIZED_NAME_AMOUNT = "amount";
  @SerializedName(SERIALIZED_NAME_AMOUNT)
  private BigDecimal amount;

  public static final String SERIALIZED_NAME_AMOUNT_OR_PERCENTAGE = "amountOrPercentage";
  @SerializedName(SERIALIZED_NAME_AMOUNT_OR_PERCENTAGE)
  private BigDecimal amountOrPercentage;

  public static final String SERIALIZED_NAME_AMOUNT_OUTSTANDING = "amountOutstanding";
  @SerializedName(SERIALIZED_NAME_AMOUNT_OUTSTANDING)
  private BigDecimal amountOutstanding;

  public static final String SERIALIZED_NAME_AMOUNT_PAID = "amountPaid";
  @SerializedName(SERIALIZED_NAME_AMOUNT_PAID)
  private BigDecimal amountPaid;

  public static final String SERIALIZED_NAME_AMOUNT_PERCENTAGE_APPLIED_TO = "amountPercentageAppliedTo";
  @SerializedName(SERIALIZED_NAME_AMOUNT_PERCENTAGE_APPLIED_TO)
  private BigDecimal amountPercentageAppliedTo;

  public static final String SERIALIZED_NAME_AMOUNT_WAIVED = "amountWaived";
  @SerializedName(SERIALIZED_NAME_AMOUNT_WAIVED)
  private BigDecimal amountWaived;

  public static final String SERIALIZED_NAME_AMOUNT_WRITTEN_OFF = "amountWrittenOff";
  @SerializedName(SERIALIZED_NAME_AMOUNT_WRITTEN_OFF)
  private BigDecimal amountWrittenOff;

  public static final String SERIALIZED_NAME_ANNUAL_FEE = "annualFee";
  @SerializedName(SERIALIZED_NAME_ANNUAL_FEE)
  private Boolean annualFee;

  public static final String SERIALIZED_NAME_CHARGE_CALCULATION_TYPE = "chargeCalculationType";
  @SerializedName(SERIALIZED_NAME_CHARGE_CALCULATION_TYPE)
  private EnumOptionData chargeCalculationType;

  public static final String SERIALIZED_NAME_CHARGE_DATA = "chargeData";
  @SerializedName(SERIALIZED_NAME_CHARGE_DATA)
  private ChargeData chargeData;

  public static final String SERIALIZED_NAME_CHARGE_ID = "chargeId";
  @SerializedName(SERIALIZED_NAME_CHARGE_ID)
  private Long chargeId;

  public static final String SERIALIZED_NAME_CHARGE_OPTIONS = "chargeOptions";
  @SerializedName(SERIALIZED_NAME_CHARGE_OPTIONS)
  private List<ChargeData> chargeOptions;

  public static final String SERIALIZED_NAME_CHARGE_TIME_TYPE = "chargeTimeType";
  @SerializedName(SERIALIZED_NAME_CHARGE_TIME_TYPE)
  private EnumOptionData chargeTimeType;

  public static final String SERIALIZED_NAME_CURRENCY = "currency";
  @SerializedName(SERIALIZED_NAME_CURRENCY)
  private CurrencyData currency;

  public static final String SERIALIZED_NAME_DUE_DATE = "dueDate";
  @SerializedName(SERIALIZED_NAME_DUE_DATE)
  private LocalDate dueDate;

  public static final String SERIALIZED_NAME_FEE_CHARGE = "feeCharge";
  @SerializedName(SERIALIZED_NAME_FEE_CHARGE)
  private Boolean feeCharge;

  public static final String SERIALIZED_NAME_FEE_INTERVAL = "feeInterval";
  @SerializedName(SERIALIZED_NAME_FEE_INTERVAL)
  private Integer feeInterval;

  public static final String SERIALIZED_NAME_FEE_ON_MONTH_DAY = "feeOnMonthDay";
  @SerializedName(SERIALIZED_NAME_FEE_ON_MONTH_DAY)
  private ChargeFeeOnMonthDay feeOnMonthDay;

  public static final String SERIALIZED_NAME_FREE_WITHDRAWAL_CHARGE_FREQUENCY = "freeWithdrawalChargeFrequency";
  @SerializedName(SERIALIZED_NAME_FREE_WITHDRAWAL_CHARGE_FREQUENCY)
  private Integer freeWithdrawalChargeFrequency;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Long id;

  public static final String SERIALIZED_NAME_INACTIVATION_DATE = "inactivationDate";
  @SerializedName(SERIALIZED_NAME_INACTIVATION_DATE)
  private LocalDate inactivationDate;

  public static final String SERIALIZED_NAME_IS_ACTIVE = "isActive";
  @SerializedName(SERIALIZED_NAME_IS_ACTIVE)
  private Boolean isActive;

  public static final String SERIALIZED_NAME_IS_FREE_WITHDRAWAL = "isFreeWithdrawal";
  @SerializedName(SERIALIZED_NAME_IS_FREE_WITHDRAWAL)
  private Boolean isFreeWithdrawal;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_PENALTY = "penalty";
  @SerializedName(SERIALIZED_NAME_PENALTY)
  private Boolean penalty;

  public static final String SERIALIZED_NAME_PERCENTAGE = "percentage";
  @SerializedName(SERIALIZED_NAME_PERCENTAGE)
  private BigDecimal percentage;

  public static final String SERIALIZED_NAME_RESTART_FREQUENCY = "restartFrequency";
  @SerializedName(SERIALIZED_NAME_RESTART_FREQUENCY)
  private Integer restartFrequency;

  public static final String SERIALIZED_NAME_RESTART_FREQUENCY_ENUM = "restartFrequencyEnum";
  @SerializedName(SERIALIZED_NAME_RESTART_FREQUENCY_ENUM)
  private Integer restartFrequencyEnum;

  public static final String SERIALIZED_NAME_SAVINGS_ACTIVATION = "savingsActivation";
  @SerializedName(SERIALIZED_NAME_SAVINGS_ACTIVATION)
  private Boolean savingsActivation;

  public static final String SERIALIZED_NAME_WITHDRAWAL_FEE = "withdrawalFee";
  @SerializedName(SERIALIZED_NAME_WITHDRAWAL_FEE)
  private Boolean withdrawalFee;

  public SavingsAccountChargeData() {
  }

  public SavingsAccountChargeData accountId(Long accountId) {
    
    this.accountId = accountId;
    return this;
  }

  /**
   * Get accountId
   * @return accountId
   */
  @javax.annotation.Nullable

  public Long getAccountId() {
    return accountId;
  }


  public void setAccountId(Long accountId) {
    this.accountId = accountId;
  }

  public SavingsAccountChargeData amount(BigDecimal amount) {
    
    this.amount = amount;
    return this;
  }

  /**
   * Get amount
   * @return amount
   */
  @javax.annotation.Nullable

  public BigDecimal getAmount() {
    return amount;
  }


  public void setAmount(BigDecimal amount) {
    this.amount = amount;
  }

  public SavingsAccountChargeData amountOrPercentage(BigDecimal amountOrPercentage) {
    
    this.amountOrPercentage = amountOrPercentage;
    return this;
  }

  /**
   * Get amountOrPercentage
   * @return amountOrPercentage
   */
  @javax.annotation.Nullable

  public BigDecimal getAmountOrPercentage() {
    return amountOrPercentage;
  }


  public void setAmountOrPercentage(BigDecimal amountOrPercentage) {
    this.amountOrPercentage = amountOrPercentage;
  }

  public SavingsAccountChargeData amountOutstanding(BigDecimal amountOutstanding) {
    
    this.amountOutstanding = amountOutstanding;
    return this;
  }

  /**
   * Get amountOutstanding
   * @return amountOutstanding
   */
  @javax.annotation.Nullable

  public BigDecimal getAmountOutstanding() {
    return amountOutstanding;
  }


  public void setAmountOutstanding(BigDecimal amountOutstanding) {
    this.amountOutstanding = amountOutstanding;
  }

  public SavingsAccountChargeData amountPaid(BigDecimal amountPaid) {
    
    this.amountPaid = amountPaid;
    return this;
  }

  /**
   * Get amountPaid
   * @return amountPaid
   */
  @javax.annotation.Nullable

  public BigDecimal getAmountPaid() {
    return amountPaid;
  }


  public void setAmountPaid(BigDecimal amountPaid) {
    this.amountPaid = amountPaid;
  }

  public SavingsAccountChargeData amountPercentageAppliedTo(BigDecimal amountPercentageAppliedTo) {
    
    this.amountPercentageAppliedTo = amountPercentageAppliedTo;
    return this;
  }

  /**
   * Get amountPercentageAppliedTo
   * @return amountPercentageAppliedTo
   */
  @javax.annotation.Nullable

  public BigDecimal getAmountPercentageAppliedTo() {
    return amountPercentageAppliedTo;
  }


  public void setAmountPercentageAppliedTo(BigDecimal amountPercentageAppliedTo) {
    this.amountPercentageAppliedTo = amountPercentageAppliedTo;
  }

  public SavingsAccountChargeData amountWaived(BigDecimal amountWaived) {
    
    this.amountWaived = amountWaived;
    return this;
  }

  /**
   * Get amountWaived
   * @return amountWaived
   */
  @javax.annotation.Nullable

  public BigDecimal getAmountWaived() {
    return amountWaived;
  }


  public void setAmountWaived(BigDecimal amountWaived) {
    this.amountWaived = amountWaived;
  }

  public SavingsAccountChargeData amountWrittenOff(BigDecimal amountWrittenOff) {
    
    this.amountWrittenOff = amountWrittenOff;
    return this;
  }

  /**
   * Get amountWrittenOff
   * @return amountWrittenOff
   */
  @javax.annotation.Nullable

  public BigDecimal getAmountWrittenOff() {
    return amountWrittenOff;
  }


  public void setAmountWrittenOff(BigDecimal amountWrittenOff) {
    this.amountWrittenOff = amountWrittenOff;
  }

  public SavingsAccountChargeData annualFee(Boolean annualFee) {
    
    this.annualFee = annualFee;
    return this;
  }

  /**
   * Get annualFee
   * @return annualFee
   */
  @javax.annotation.Nullable

  public Boolean getAnnualFee() {
    return annualFee;
  }


  public void setAnnualFee(Boolean annualFee) {
    this.annualFee = annualFee;
  }

  public SavingsAccountChargeData chargeCalculationType(EnumOptionData chargeCalculationType) {
    
    this.chargeCalculationType = chargeCalculationType;
    return this;
  }

  /**
   * Get chargeCalculationType
   * @return chargeCalculationType
   */
  @javax.annotation.Nullable

  public EnumOptionData getChargeCalculationType() {
    return chargeCalculationType;
  }


  public void setChargeCalculationType(EnumOptionData chargeCalculationType) {
    this.chargeCalculationType = chargeCalculationType;
  }

  public SavingsAccountChargeData chargeData(ChargeData chargeData) {
    
    this.chargeData = chargeData;
    return this;
  }

  /**
   * Get chargeData
   * @return chargeData
   */
  @javax.annotation.Nullable

  public ChargeData getChargeData() {
    return chargeData;
  }


  public void setChargeData(ChargeData chargeData) {
    this.chargeData = chargeData;
  }

  public SavingsAccountChargeData chargeId(Long chargeId) {
    
    this.chargeId = chargeId;
    return this;
  }

  /**
   * Get chargeId
   * @return chargeId
   */
  @javax.annotation.Nullable

  public Long getChargeId() {
    return chargeId;
  }


  public void setChargeId(Long chargeId) {
    this.chargeId = chargeId;
  }

  public SavingsAccountChargeData chargeOptions(List<ChargeData> chargeOptions) {
    
    this.chargeOptions = chargeOptions;
    return this;
  }

  public SavingsAccountChargeData addChargeOptionsItem(ChargeData chargeOptionsItem) {
    if (this.chargeOptions == null) {
      this.chargeOptions = new ArrayList<>();
    }
    this.chargeOptions.add(chargeOptionsItem);
    return this;
  }

  /**
   * Get chargeOptions
   * @return chargeOptions
   */
  @javax.annotation.Nullable

  public List<ChargeData> getChargeOptions() {
    return chargeOptions;
  }


  public void setChargeOptions(List<ChargeData> chargeOptions) {
    this.chargeOptions = chargeOptions;
  }

  public SavingsAccountChargeData chargeTimeType(EnumOptionData chargeTimeType) {
    
    this.chargeTimeType = chargeTimeType;
    return this;
  }

  /**
   * Get chargeTimeType
   * @return chargeTimeType
   */
  @javax.annotation.Nullable

  public EnumOptionData getChargeTimeType() {
    return chargeTimeType;
  }


  public void setChargeTimeType(EnumOptionData chargeTimeType) {
    this.chargeTimeType = chargeTimeType;
  }

  public SavingsAccountChargeData currency(CurrencyData currency) {
    
    this.currency = currency;
    return this;
  }

  /**
   * Get currency
   * @return currency
   */
  @javax.annotation.Nullable

  public CurrencyData getCurrency() {
    return currency;
  }


  public void setCurrency(CurrencyData currency) {
    this.currency = currency;
  }

  public SavingsAccountChargeData dueDate(LocalDate dueDate) {
    
    this.dueDate = dueDate;
    return this;
  }

  /**
   * Get dueDate
   * @return dueDate
   */
  @javax.annotation.Nullable

  public LocalDate getDueDate() {
    return dueDate;
  }


  public void setDueDate(LocalDate dueDate) {
    this.dueDate = dueDate;
  }

  public SavingsAccountChargeData feeCharge(Boolean feeCharge) {
    
    this.feeCharge = feeCharge;
    return this;
  }

  /**
   * Get feeCharge
   * @return feeCharge
   */
  @javax.annotation.Nullable

  public Boolean getFeeCharge() {
    return feeCharge;
  }


  public void setFeeCharge(Boolean feeCharge) {
    this.feeCharge = feeCharge;
  }

  public SavingsAccountChargeData feeInterval(Integer feeInterval) {
    
    this.feeInterval = feeInterval;
    return this;
  }

  /**
   * Get feeInterval
   * @return feeInterval
   */
  @javax.annotation.Nullable

  public Integer getFeeInterval() {
    return feeInterval;
  }


  public void setFeeInterval(Integer feeInterval) {
    this.feeInterval = feeInterval;
  }

  public SavingsAccountChargeData feeOnMonthDay(ChargeFeeOnMonthDay feeOnMonthDay) {
    
    this.feeOnMonthDay = feeOnMonthDay;
    return this;
  }

  /**
   * Get feeOnMonthDay
   * @return feeOnMonthDay
   */
  @javax.annotation.Nullable

  public ChargeFeeOnMonthDay getFeeOnMonthDay() {
    return feeOnMonthDay;
  }


  public void setFeeOnMonthDay(ChargeFeeOnMonthDay feeOnMonthDay) {
    this.feeOnMonthDay = feeOnMonthDay;
  }

  public SavingsAccountChargeData freeWithdrawalChargeFrequency(Integer freeWithdrawalChargeFrequency) {
    
    this.freeWithdrawalChargeFrequency = freeWithdrawalChargeFrequency;
    return this;
  }

  /**
   * Get freeWithdrawalChargeFrequency
   * @return freeWithdrawalChargeFrequency
   */
  @javax.annotation.Nullable

  public Integer getFreeWithdrawalChargeFrequency() {
    return freeWithdrawalChargeFrequency;
  }


  public void setFreeWithdrawalChargeFrequency(Integer freeWithdrawalChargeFrequency) {
    this.freeWithdrawalChargeFrequency = freeWithdrawalChargeFrequency;
  }

  public SavingsAccountChargeData id(Long id) {
    
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   */
  @javax.annotation.Nullable

  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }

  public SavingsAccountChargeData inactivationDate(LocalDate inactivationDate) {
    
    this.inactivationDate = inactivationDate;
    return this;
  }

  /**
   * Get inactivationDate
   * @return inactivationDate
   */
  @javax.annotation.Nullable

  public LocalDate getInactivationDate() {
    return inactivationDate;
  }


  public void setInactivationDate(LocalDate inactivationDate) {
    this.inactivationDate = inactivationDate;
  }

  public SavingsAccountChargeData isActive(Boolean isActive) {
    
    this.isActive = isActive;
    return this;
  }

  /**
   * Get isActive
   * @return isActive
   */
  @javax.annotation.Nullable

  public Boolean getIsActive() {
    return isActive;
  }


  public void setIsActive(Boolean isActive) {
    this.isActive = isActive;
  }

  public SavingsAccountChargeData isFreeWithdrawal(Boolean isFreeWithdrawal) {
    
    this.isFreeWithdrawal = isFreeWithdrawal;
    return this;
  }

  /**
   * Get isFreeWithdrawal
   * @return isFreeWithdrawal
   */
  @javax.annotation.Nullable

  public Boolean getIsFreeWithdrawal() {
    return isFreeWithdrawal;
  }


  public void setIsFreeWithdrawal(Boolean isFreeWithdrawal) {
    this.isFreeWithdrawal = isFreeWithdrawal;
  }

  public SavingsAccountChargeData name(String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
   */
  @javax.annotation.Nullable

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }

  public SavingsAccountChargeData penalty(Boolean penalty) {
    
    this.penalty = penalty;
    return this;
  }

  /**
   * Get penalty
   * @return penalty
   */
  @javax.annotation.Nullable

  public Boolean getPenalty() {
    return penalty;
  }


  public void setPenalty(Boolean penalty) {
    this.penalty = penalty;
  }

  public SavingsAccountChargeData percentage(BigDecimal percentage) {
    
    this.percentage = percentage;
    return this;
  }

  /**
   * Get percentage
   * @return percentage
   */
  @javax.annotation.Nullable

  public BigDecimal getPercentage() {
    return percentage;
  }


  public void setPercentage(BigDecimal percentage) {
    this.percentage = percentage;
  }

  public SavingsAccountChargeData restartFrequency(Integer restartFrequency) {
    
    this.restartFrequency = restartFrequency;
    return this;
  }

  /**
   * Get restartFrequency
   * @return restartFrequency
   */
  @javax.annotation.Nullable

  public Integer getRestartFrequency() {
    return restartFrequency;
  }


  public void setRestartFrequency(Integer restartFrequency) {
    this.restartFrequency = restartFrequency;
  }

  public SavingsAccountChargeData restartFrequencyEnum(Integer restartFrequencyEnum) {
    
    this.restartFrequencyEnum = restartFrequencyEnum;
    return this;
  }

  /**
   * Get restartFrequencyEnum
   * @return restartFrequencyEnum
   */
  @javax.annotation.Nullable

  public Integer getRestartFrequencyEnum() {
    return restartFrequencyEnum;
  }


  public void setRestartFrequencyEnum(Integer restartFrequencyEnum) {
    this.restartFrequencyEnum = restartFrequencyEnum;
  }

  public SavingsAccountChargeData savingsActivation(Boolean savingsActivation) {
    
    this.savingsActivation = savingsActivation;
    return this;
  }

  /**
   * Get savingsActivation
   * @return savingsActivation
   */
  @javax.annotation.Nullable

  public Boolean getSavingsActivation() {
    return savingsActivation;
  }


  public void setSavingsActivation(Boolean savingsActivation) {
    this.savingsActivation = savingsActivation;
  }

  public SavingsAccountChargeData withdrawalFee(Boolean withdrawalFee) {
    
    this.withdrawalFee = withdrawalFee;
    return this;
  }

  /**
   * Get withdrawalFee
   * @return withdrawalFee
   */
  @javax.annotation.Nullable

  public Boolean getWithdrawalFee() {
    return withdrawalFee;
  }


  public void setWithdrawalFee(Boolean withdrawalFee) {
    this.withdrawalFee = withdrawalFee;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SavingsAccountChargeData savingsAccountChargeData = (SavingsAccountChargeData) o;
    return Objects.equals(this.accountId, savingsAccountChargeData.accountId) &&
        Objects.equals(this.amount, savingsAccountChargeData.amount) &&
        Objects.equals(this.amountOrPercentage, savingsAccountChargeData.amountOrPercentage) &&
        Objects.equals(this.amountOutstanding, savingsAccountChargeData.amountOutstanding) &&
        Objects.equals(this.amountPaid, savingsAccountChargeData.amountPaid) &&
        Objects.equals(this.amountPercentageAppliedTo, savingsAccountChargeData.amountPercentageAppliedTo) &&
        Objects.equals(this.amountWaived, savingsAccountChargeData.amountWaived) &&
        Objects.equals(this.amountWrittenOff, savingsAccountChargeData.amountWrittenOff) &&
        Objects.equals(this.annualFee, savingsAccountChargeData.annualFee) &&
        Objects.equals(this.chargeCalculationType, savingsAccountChargeData.chargeCalculationType) &&
        Objects.equals(this.chargeData, savingsAccountChargeData.chargeData) &&
        Objects.equals(this.chargeId, savingsAccountChargeData.chargeId) &&
        Objects.equals(this.chargeOptions, savingsAccountChargeData.chargeOptions) &&
        Objects.equals(this.chargeTimeType, savingsAccountChargeData.chargeTimeType) &&
        Objects.equals(this.currency, savingsAccountChargeData.currency) &&
        Objects.equals(this.dueDate, savingsAccountChargeData.dueDate) &&
        Objects.equals(this.feeCharge, savingsAccountChargeData.feeCharge) &&
        Objects.equals(this.feeInterval, savingsAccountChargeData.feeInterval) &&
        Objects.equals(this.feeOnMonthDay, savingsAccountChargeData.feeOnMonthDay) &&
        Objects.equals(this.freeWithdrawalChargeFrequency, savingsAccountChargeData.freeWithdrawalChargeFrequency) &&
        Objects.equals(this.id, savingsAccountChargeData.id) &&
        Objects.equals(this.inactivationDate, savingsAccountChargeData.inactivationDate) &&
        Objects.equals(this.isActive, savingsAccountChargeData.isActive) &&
        Objects.equals(this.isFreeWithdrawal, savingsAccountChargeData.isFreeWithdrawal) &&
        Objects.equals(this.name, savingsAccountChargeData.name) &&
        Objects.equals(this.penalty, savingsAccountChargeData.penalty) &&
        Objects.equals(this.percentage, savingsAccountChargeData.percentage) &&
        Objects.equals(this.restartFrequency, savingsAccountChargeData.restartFrequency) &&
        Objects.equals(this.restartFrequencyEnum, savingsAccountChargeData.restartFrequencyEnum) &&
        Objects.equals(this.savingsActivation, savingsAccountChargeData.savingsActivation) &&
        Objects.equals(this.withdrawalFee, savingsAccountChargeData.withdrawalFee);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountId, amount, amountOrPercentage, amountOutstanding, amountPaid, amountPercentageAppliedTo, amountWaived, amountWrittenOff, annualFee, chargeCalculationType, chargeData, chargeId, chargeOptions, chargeTimeType, currency, dueDate, feeCharge, feeInterval, feeOnMonthDay, freeWithdrawalChargeFrequency, id, inactivationDate, isActive, isFreeWithdrawal, name, penalty, percentage, restartFrequency, restartFrequencyEnum, savingsActivation, withdrawalFee);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SavingsAccountChargeData {\n");
    sb.append("    accountId: ").append(toIndentedString(accountId)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    amountOrPercentage: ").append(toIndentedString(amountOrPercentage)).append("\n");
    sb.append("    amountOutstanding: ").append(toIndentedString(amountOutstanding)).append("\n");
    sb.append("    amountPaid: ").append(toIndentedString(amountPaid)).append("\n");
    sb.append("    amountPercentageAppliedTo: ").append(toIndentedString(amountPercentageAppliedTo)).append("\n");
    sb.append("    amountWaived: ").append(toIndentedString(amountWaived)).append("\n");
    sb.append("    amountWrittenOff: ").append(toIndentedString(amountWrittenOff)).append("\n");
    sb.append("    annualFee: ").append(toIndentedString(annualFee)).append("\n");
    sb.append("    chargeCalculationType: ").append(toIndentedString(chargeCalculationType)).append("\n");
    sb.append("    chargeData: ").append(toIndentedString(chargeData)).append("\n");
    sb.append("    chargeId: ").append(toIndentedString(chargeId)).append("\n");
    sb.append("    chargeOptions: ").append(toIndentedString(chargeOptions)).append("\n");
    sb.append("    chargeTimeType: ").append(toIndentedString(chargeTimeType)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    dueDate: ").append(toIndentedString(dueDate)).append("\n");
    sb.append("    feeCharge: ").append(toIndentedString(feeCharge)).append("\n");
    sb.append("    feeInterval: ").append(toIndentedString(feeInterval)).append("\n");
    sb.append("    feeOnMonthDay: ").append(toIndentedString(feeOnMonthDay)).append("\n");
    sb.append("    freeWithdrawalChargeFrequency: ").append(toIndentedString(freeWithdrawalChargeFrequency)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    inactivationDate: ").append(toIndentedString(inactivationDate)).append("\n");
    sb.append("    isActive: ").append(toIndentedString(isActive)).append("\n");
    sb.append("    isFreeWithdrawal: ").append(toIndentedString(isFreeWithdrawal)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    penalty: ").append(toIndentedString(penalty)).append("\n");
    sb.append("    percentage: ").append(toIndentedString(percentage)).append("\n");
    sb.append("    restartFrequency: ").append(toIndentedString(restartFrequency)).append("\n");
    sb.append("    restartFrequencyEnum: ").append(toIndentedString(restartFrequencyEnum)).append("\n");
    sb.append("    savingsActivation: ").append(toIndentedString(savingsActivation)).append("\n");
    sb.append("    withdrawalFee: ").append(toIndentedString(withdrawalFee)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

