package org.apache.fineract.client.services;

import org.apache.fineract.client.CollectionFormats.*;

    import retrofit2.Call;
import retrofit2.http.*;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.MultipartBody;

import org.apache.fineract.client.models.AdHocData;
import org.apache.fineract.client.models.AdHocRequest;
import org.apache.fineract.client.models.CommandProcessingResult;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface AdhocQueryApiApi {
    /**
    * 
    * 
        * @param adHocRequest  (optional)
    * @return Call&lt;CommandProcessingResult&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/adhocquery")
    Call<CommandProcessingResult> createAdHocQuery(@retrofit2.http.Body AdHocRequest adHocRequest);

    /**
    * 
    * 
        * @param adHocId adHocId (required)
    * @return Call&lt;CommandProcessingResult&gt;
    */
    @DELETE("v1/adhocquery/{adHocId}")
    Call<CommandProcessingResult> deleteAdHocQuery(@retrofit2.http.Path("adHocId") Long adHocId);

    /**
    * 
    * 
        * @param adHocId adHocId (required)
    * @return Call&lt;AdHocData&gt;
    */
    @GET("v1/adhocquery/{adHocId}")
    Call<AdHocData> retrieveAdHocQuery(@retrofit2.http.Path("adHocId") Long adHocId);

    /**
    * 
    * 
    * @return Call&lt;List&lt;AdHocData&gt;&gt;
    */
    @GET("v1/adhocquery")
    Call<List<AdHocData>> retrieveAll2();

    /**
    * 
    * 
    * @return Call&lt;AdHocData&gt;
    */
    @GET("v1/adhocquery/template")
    Call<AdHocData> template();

    /**
    * 
    * 
        * @param adHocId adHocId (required)
        * @param adHocRequest  (optional)
    * @return Call&lt;CommandProcessingResult&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/adhocquery/{adHocId}")
    Call<CommandProcessingResult> update(@retrofit2.http.Path("adHocId") Long adHocId, @retrofit2.http.Body AdHocRequest adHocRequest);


        /**
        * 
        * 
            * @param adHocRequest  (optional)
        * @return Call&lt;CommandProcessingResult&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/adhocquery")
    Call<CommandProcessingResult> createAdHocQuery();
        /**
        * 
        * 
            * @param adHocId adHocId (required)
            * @param adHocRequest  (optional)
        * @return Call&lt;CommandProcessingResult&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/adhocquery/{adHocId}")
    Call<CommandProcessingResult> update(@retrofit2.http.Path("adHocId") Long adHocId);

        /**
        * 
        * 
            * @param adHocRequest  (optional)
        * @return Call&lt;CommandProcessingResult&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/adhocquery")
    Call<CommandProcessingResult> createAdHocQuery(@retrofit2.http.Body AdHocRequest adHocRequest, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param adHocId adHocId (required)
        * @return Call&lt;CommandProcessingResult&gt;
        */
    @DELETE("v1/adhocquery/{adHocId}")
    Call<CommandProcessingResult> deleteAdHocQuery(@retrofit2.http.Path("adHocId") Long adHocId, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param adHocId adHocId (required)
        * @return Call&lt;AdHocData&gt;
        */
    @GET("v1/adhocquery/{adHocId}")
    Call<AdHocData> retrieveAdHocQuery(@retrofit2.http.Path("adHocId") Long adHocId, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
        * @return Call&lt;List&lt;AdHocData&gt;&gt;
        */
    @GET("v1/adhocquery")
    Call<List<AdHocData>> retrieveAll2(@HeaderMap Map<String, String> headers);

        /**
        * 
        * 
        * @return Call&lt;AdHocData&gt;
        */
    @GET("v1/adhocquery/template")
    Call<AdHocData> template(@HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param adHocId adHocId (required)
            * @param adHocRequest  (optional)
        * @return Call&lt;CommandProcessingResult&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/adhocquery/{adHocId}")
    Call<CommandProcessingResult> update(@retrofit2.http.Path("adHocId") Long adHocId, @retrofit2.http.Body AdHocRequest adHocRequest, @HeaderMap Map<String, String> headers);


        /**
        * 
        * 
            * @param adHocRequest  (optional)
        * @return Call&lt;CommandProcessingResult&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/adhocquery")
    Call<CommandProcessingResult> createAdHocQuery(@HeaderMap Map<String, String> headers);
        /**
        * 
        * 
            * @param adHocId adHocId (required)
            * @param adHocRequest  (optional)
        * @return Call&lt;CommandProcessingResult&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/adhocquery/{adHocId}")
    Call<CommandProcessingResult> update(@retrofit2.http.Path("adHocId") Long adHocId, @HeaderMap Map<String, String> headers);
}
