/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.fineract.portfolio.self.shareaccounts.service;

import lombok.RequiredArgsConstructor;
import org.springframework.jdbc.core.JdbcTemplate;

@RequiredArgsConstructor
public class AppUserShareAccountsMapperReadPlatformServiceImpl implements AppUserShareAccountsMapperReadPlatformService {

    private final JdbcTemplate jdbcTemplate;

    @Override
    public Boolean isShareAccountsMappedToUser(Long accountId, Long appUserId) {
        return this.jdbcTemplate.queryForObject("select case when (count(*) > 0) then true else false end "
                + " from m_selfservice_user_client_mapping as m "
                + " left join m_share_account as shares on shares.client_id = m.client_id  " + " where shares.id = ? and m.appuser_id = ? ",
                Boolean.class, accountId, appUserId);
    }

}
