/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.select;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Scanner;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStreamBuilder;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FutureDataInputStreamBuilder;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.impl.FutureIOSupport;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.s3guard.S3GuardTool;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.util.DurationInfo;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.OperationDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectTool
extends S3GuardTool {
    private static final Logger LOG = LoggerFactory.getLogger(SelectTool.class);
    public static final String NAME = "select";
    public static final String PURPOSE = "make an S3 Select call";
    private static final String USAGE = "select [OPTIONS] [-limit rows] [-header (use|none|ignore)] [-out path] [-expected rows] [-compression (gzip|bzip2|none)] [-inputformat csv] [-outputformat csv] <PATH> <SELECT QUERY>\n\tmake an S3 Select call\n\n";
    public static final String OPT_COMPRESSION = "compression";
    public static final String OPT_EXPECTED = "expected";
    public static final String OPT_HEADER = "header";
    public static final String OPT_INPUTFORMAT = "inputformat";
    public static final String OPT_LIMIT = "limit";
    public static final String OPT_OUTPUT = "out";
    public static final String OPT_OUTPUTFORMAT = "inputformat";
    static final String TOO_FEW_ARGUMENTS = "Too few arguments";
    static final String SELECT_IS_DISABLED = "S3 Select is disabled";
    private OperationDuration selectDuration;
    private long bytesRead;
    private long linesRead;

    public SelectTool(Configuration conf) {
        super(conf, new String[0]);
        this.getCommandFormat().addOptionWithValue(OPT_COMPRESSION);
        this.getCommandFormat().addOptionWithValue(OPT_EXPECTED);
        this.getCommandFormat().addOptionWithValue(OPT_HEADER);
        this.getCommandFormat().addOptionWithValue("inputformat");
        this.getCommandFormat().addOptionWithValue(OPT_LIMIT);
        this.getCommandFormat().addOptionWithValue(OPT_OUTPUT);
        this.getCommandFormat().addOptionWithValue("inputformat");
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getUsage() {
        return USAGE;
    }

    public OperationDuration getSelectDuration() {
        return this.selectDuration;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public long getLinesRead() {
        return this.linesRead;
    }

    private int parseNaturalInt(String option, String value) {
        try {
            int r = Integer.parseInt(value);
            if (r < 0) {
                throw SelectTool.invalidArgs("Negative value for option %s : %s", option, value);
            }
            return r;
        }
        catch (NumberFormatException e) {
            throw SelectTool.invalidArgs("Invalid number for option %s : %s", option, value);
        }
    }

    private Optional<String> getOptValue(String key) {
        String value = this.getCommandFormat().getOptValue(key);
        return StringUtils.isNotEmpty(value) ? Optional.of(value) : Optional.empty();
    }

    private Optional<Integer> getIntValue(String key) {
        Optional<String> v = this.getOptValue(key);
        return v.map(i -> this.parseNaturalInt(key, (String)i));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(String[] args, PrintStream out) throws IOException, ExitUtil.ExitException {
        FSDataInputStream stream;
        Throwable throwable;
        DurationInfo ignored;
        S3AFileSystem fs;
        List<String> parsedArgs;
        try {
            parsedArgs = this.parseArgs(args);
        }
        catch (CommandFormat.UnknownOptionException e) {
            SelectTool.errorln(this.getUsage());
            throw new ExitUtil.ExitException(42, e.getMessage(), e);
        }
        if (parsedArgs.size() < 2) {
            SelectTool.errorln(this.getUsage());
            throw new ExitUtil.ExitException(42, TOO_FEW_ARGUMENTS);
        }
        String file = parsedArgs.get(0);
        Path path = new Path(file);
        String expression = parsedArgs.get(1);
        SelectTool.println(out, "selecting file %s with query %s", path, expression);
        Optional<String> header = this.getOptValue(OPT_HEADER);
        header.ifPresent(h2 -> SelectTool.println(out, "Using header option %s", h2));
        Path destPath = this.getOptValue(OPT_OUTPUT).map(output -> {
            SelectTool.println(out, "Saving output to %s", output);
            return new Path((String)output);
        }).orElse(null);
        boolean toConsole = destPath == null;
        Optional<Integer> expectedLines = toConsole ? this.getIntValue(OPT_EXPECTED) : Optional.empty();
        Optional<Integer> limit = this.getIntValue(OPT_LIMIT);
        if (limit.isPresent()) {
            int l2 = limit.get();
            SelectTool.println(out, "Using line limit %s", l2);
            if (expression.toLowerCase(Locale.ENGLISH).contains(" limit ")) {
                SelectTool.println(out, "line limit already specified in SELECT expression", new Object[0]);
            } else {
                expression = expression + " LIMIT " + l2;
            }
        }
        if (!((FileSystem)(fs = this.bindFilesystem(path.getFileSystem(this.getConf())))).hasPathCapability(path, "fs.s3a.capability.select.sql")) {
            throw new ExitUtil.ExitException(53, "S3 Select is disabled for " + file);
        }
        this.linesRead = 0L;
        this.selectDuration = new OperationDuration();
        FutureDataInputStreamBuilder builder = (FutureDataInputStreamBuilder)fs.openFile(path).must("fs.s3a.select.sql", expression);
        header.ifPresent(h2 -> {
            FutureDataInputStreamBuilder cfr_ignored_0 = (FutureDataInputStreamBuilder)builder.must("fs.s3a.select.input.csv.header", (String)h2);
        });
        this.getOptValue(OPT_COMPRESSION).ifPresent(compression -> {
            FutureDataInputStreamBuilder cfr_ignored_0 = (FutureDataInputStreamBuilder)builder.must("fs.s3a.select.input.compression", compression.toUpperCase(Locale.ENGLISH));
        });
        this.getOptValue("inputformat").ifPresent(opt -> {
            if (!"csv".equalsIgnoreCase((String)opt)) {
                throw SelectTool.invalidArgs("Unsupported input format %s", opt);
            }
        });
        this.getOptValue("inputformat").ifPresent(opt -> {
            if (!"csv".equalsIgnoreCase((String)opt)) {
                throw SelectTool.invalidArgs("Unsupported output format %s", opt);
            }
        });
        builder.opt("fs.s3a.select.errors.include.sql", true);
        try {
            ignored = new DurationInfo(LOG, "Selecting stream", new Object[0]);
            throwable = null;
            try {
                stream = (FSDataInputStream)FutureIOSupport.awaitFuture(builder.build());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ignored != null) {
                    if (throwable != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ignored.close();
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            throw SelectTool.storeNotFound(e);
        }
        try {
            if (toConsole) {
                this.bytesRead = 0L;
                Scanner scanner = new Scanner(new BufferedReader(new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8)));
                scanner.useDelimiter("\n");
                while (scanner.hasNextLine()) {
                    ++this.linesRead;
                    String l3 = scanner.nextLine();
                    this.bytesRead += (long)(l3.length() + 1);
                    SelectTool.println(out, "%s", l3);
                }
            } else {
                FileSystem destFS = destPath.getFileSystem(this.getConf());
                try (DurationInfo ignored2 = new DurationInfo(LOG, "Copying File", new Object[0]);
                     Object destStream = ((FSDataOutputStreamBuilder)destFS.createFile(destPath).overwrite(true)).build();){
                    this.bytesRead = IOUtils.copy((InputStream)stream, (OutputStream)destStream);
                }
            }
            ignored = new DurationInfo(LOG, "Closing stream", new Object[0]);
            throwable = null;
            try {
                stream.close();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (ignored != null) {
                    if (throwable != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ignored.close();
                    }
                }
            }
            String result = toConsole ? String.format("%s lines", this.linesRead) : String.format("%s bytes", this.bytesRead);
            this.selectDuration.finished();
            SelectTool.println(out, "Read %s in time %s", result, this.selectDuration.getDurationString());
            SelectTool.println(out, "Bytes Read: %,d bytes", this.bytesRead);
            SelectTool.println(out, "Bandwidth: %,.1f MiB/s", SelectTool.bandwidthMBs(this.bytesRead, this.selectDuration.value()));
        }
        catch (Throwable throwable6) {
            org.apache.hadoop.io.IOUtils.cleanupWithLogger(LOG, stream);
            throw throwable6;
        }
        org.apache.hadoop.io.IOUtils.cleanupWithLogger(LOG, stream);
        LOG.debug("Statistics {}", (Object)stream);
        expectedLines.ifPresent(l -> {
            if ((long)l.intValue() != this.linesRead) {
                throw SelectTool.exitException(-1, "Expected %d rows but the operation returned %d", l, this.linesRead);
            }
        });
        out.flush();
        return 0;
    }

    public static double bandwidthMBs(long bytes, long durationMillisNS) {
        return durationMillisNS > 0L ? (double)bytes / 1048576.0 * 1000.0 / (double)durationMillisNS : 0.0;
    }
}

