/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.hint;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelHomogeneousShuttle;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.hint.HintStrategyTable;
import org.apache.calcite.rel.hint.Hintable;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.table.planner.hint.FlinkHints;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil;

public class ClearQueryHintsOnUnmatchedNodesShuttle
extends RelHomogeneousShuttle {
    private final HintStrategyTable hintStrategyTable;

    public ClearQueryHintsOnUnmatchedNodesShuttle(HintStrategyTable hintStrategyTable) {
        this.hintStrategyTable = hintStrategyTable;
    }

    @Override
    public RelNode visit(RelNode other) {
        if (FlinkRelOptUtil.containsSubQuery(other)) {
            other = FlinkHints.resolveSubQuery(other, relNode -> relNode.accept(this));
        }
        if (other instanceof Hintable) {
            ImmutableList<RelHint> originHints = ((Hintable)((Object)other)).getHints();
            List<RelHint> queryHints = originHints.stream().filter(h2 -> FlinkHints.isQueryHint(h2.hintName)).collect(Collectors.toList());
            ArrayList<RelHint> remainHints = new ArrayList<RelHint>(originHints);
            remainHints.removeAll(queryHints);
            List<RelHint> hintsCanApply = this.hintStrategyTable.apply(queryHints, other);
            if (hintsCanApply.size() != queryHints.size()) {
                hintsCanApply.addAll(remainHints);
                other = ((Hintable)((Object)other)).withHints(hintsCanApply);
            }
        }
        return super.visit(other);
    }
}

