/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.common;

import java.util.List;
import java.util.Optional;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.source.ParallelSourceFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.operators.StreamSource;
import org.apache.flink.streaming.api.transformations.LegacySourceTransformation;
import org.apache.flink.streaming.api.transformations.PartitionTransformation;
import org.apache.flink.streaming.api.transformations.SourceTransformationWrapper;
import org.apache.flink.streaming.runtime.partitioner.KeyGroupStreamPartitioner;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.ParallelismProvider;
import org.apache.flink.table.connector.ProviderContext;
import org.apache.flink.table.connector.source.DataStreamScanProvider;
import org.apache.flink.table.connector.source.InputFormatProvider;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceFunctionProvider;
import org.apache.flink.table.connector.source.SourceProvider;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.connectors.TransformationScanProvider;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.MultipleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.spec.DynamicTableSourceSpec;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.TransformationMetadata;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.runtime.connector.source.ScanRuntimeProviderContext;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.RowKind;

public abstract class CommonExecTableSourceScan
extends ExecNodeBase<RowData>
implements MultipleTransformationTranslator<RowData> {
    public static final String SOURCE_TRANSFORMATION = "source";
    public static final String FIELD_NAME_SCAN_TABLE_SOURCE = "scanTableSource";
    @JsonProperty(value="scanTableSource")
    private final DynamicTableSourceSpec tableSourceSpec;

    protected CommonExecTableSourceScan(int id, ExecNodeContext context, ReadableConfig persistedConfig, DynamicTableSourceSpec tableSourceSpec, List<InputProperty> inputProperties, LogicalType outputType, String description) {
        super(id, context, persistedConfig, inputProperties, outputType, description);
        this.tableSourceSpec = tableSourceSpec;
    }

    @Override
    public String getSimplifiedName() {
        return this.tableSourceSpec.getContextResolvedTable().getIdentifier().getObjectName();
    }

    public DynamicTableSourceSpec getTableSourceSpec() {
        return this.tableSourceSpec;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        Transformation<RowData> sourceTransform;
        StreamExecutionEnvironment env = planner.getExecEnv();
        TransformationMetadata meta = this.createTransformationMeta(SOURCE_TRANSFORMATION, config);
        InternalTypeInfo outputTypeInfo = InternalTypeInfo.of((RowType)((RowType)this.getOutputType()));
        ScanTableSource tableSource = this.tableSourceSpec.getScanTableSource(planner.getFlinkContext(), ShortcutUtils.unwrapTypeFactory(planner));
        ScanTableSource.ScanRuntimeProvider provider = tableSource.getScanRuntimeProvider((ScanTableSource.ScanContext)ScanRuntimeProviderContext.INSTANCE);
        int sourceParallelism = this.deriveSourceParallelism(provider);
        boolean sourceParallelismConfigured = this.isParallelismConfigured(provider);
        if (provider instanceof SourceFunctionProvider) {
            SourceFunctionProvider sourceFunctionProvider = (SourceFunctionProvider)provider;
            SourceFunction function = sourceFunctionProvider.createSourceFunction();
            Transformation<RowData> sourceTransform2 = this.createSourceFunctionTransformation(env, (SourceFunction<RowData>)function, sourceFunctionProvider.isBounded(), meta.getName(), (TypeInformation<RowData>)outputTypeInfo, sourceParallelism, sourceParallelismConfigured);
            if (function instanceof ParallelSourceFunction && sourceParallelismConfigured) {
                meta.fill(sourceTransform2);
                return new SourceTransformationWrapper(sourceTransform2);
            }
            return meta.fill(sourceTransform2);
        }
        if (provider instanceof InputFormatProvider) {
            InputFormat inputFormat = ((InputFormatProvider)provider).createInputFormat();
            sourceTransform = this.createInputFormatTransformation(env, inputFormat, (InternalTypeInfo<RowData>)outputTypeInfo, meta.getName());
            meta.fill(sourceTransform);
        } else if (provider instanceof SourceProvider) {
            Source source = ((SourceProvider)provider).createSource();
            sourceTransform = env.fromSource(source, WatermarkStrategy.noWatermarks(), meta.getName(), (TypeInformation)outputTypeInfo).getTransformation();
            meta.fill(sourceTransform);
        } else if (provider instanceof DataStreamScanProvider) {
            sourceTransform = ((DataStreamScanProvider)provider).produceDataStream(this.createProviderContext(config), env).getTransformation();
            meta.fill(sourceTransform);
            sourceTransform.setOutputType((TypeInformation)outputTypeInfo);
        } else if (provider instanceof TransformationScanProvider) {
            sourceTransform = ((TransformationScanProvider)provider).createTransformation(this.createProviderContext(config));
            meta.fill(sourceTransform);
            sourceTransform.setOutputType((TypeInformation)outputTypeInfo);
        } else {
            throw new UnsupportedOperationException(provider.getClass().getSimpleName() + " is unsupported now.");
        }
        if (sourceParallelismConfigured) {
            return this.applySourceTransformationWrapper(sourceTransform, planner.getFlinkContext().getClassLoader(), (InternalTypeInfo<RowData>)outputTypeInfo, config, tableSource.getChangelogMode(), sourceParallelism);
        }
        return sourceTransform;
    }

    private boolean isParallelismConfigured(ScanTableSource.ScanRuntimeProvider runtimeProvider) {
        return runtimeProvider instanceof ParallelismProvider && ((ParallelismProvider)runtimeProvider).getParallelism().isPresent();
    }

    private int deriveSourceParallelism(ScanTableSource.ScanRuntimeProvider runtimeProvider) {
        if (this.isParallelismConfigured(runtimeProvider)) {
            int sourceParallelism = (Integer)((ParallelismProvider)runtimeProvider).getParallelism().get();
            if (sourceParallelism <= 0) {
                throw new TableException(String.format("Invalid configured parallelism %s for table '%s'.", sourceParallelism, this.tableSourceSpec.getContextResolvedTable().getIdentifier().asSummaryString()));
            }
            return sourceParallelism;
        }
        return -1;
    }

    protected RowType getPhysicalRowType(ResolvedSchema schema) {
        return (RowType)schema.toPhysicalRowDataType().getLogicalType();
    }

    protected int[] getPrimaryKeyIndices(RowType sourceRowType, ResolvedSchema schema) {
        return schema.getPrimaryKey().map(k -> k.getColumns().stream().mapToInt(arg_0 -> ((RowType)sourceRowType).getFieldIndex(arg_0)).toArray()).orElse(new int[0]);
    }

    private Transformation<RowData> applySourceTransformationWrapper(Transformation<RowData> sourceTransform, ClassLoader classLoader, InternalTypeInfo<RowData> outputTypeInfo, ExecNodeConfig config, ChangelogMode changelogMode, int sourceParallelism) {
        sourceTransform.setParallelism(sourceParallelism, true);
        SourceTransformationWrapper sourceTransformationWrapper = new SourceTransformationWrapper(sourceTransform);
        if (!changelogMode.containsOnly(RowKind.INSERT)) {
            boolean hasPk;
            ResolvedSchema schema = this.tableSourceSpec.getContextResolvedTable().getResolvedSchema();
            RowType physicalRowType = this.getPhysicalRowType(schema);
            int[] primaryKeys = this.getPrimaryKeyIndices(physicalRowType, schema);
            boolean bl = hasPk = primaryKeys.length > 0;
            if (!hasPk) {
                throw new TableException(String.format("Configured parallelism %s for upsert table '%s' while can not find primary key field. This is a bug, please file an issue.", sourceParallelism, this.tableSourceSpec.getContextResolvedTable().getIdentifier().asSummaryString()));
            }
            RowDataKeySelector selector = KeySelectorUtil.getRowDataSelector(classLoader, primaryKeys, outputTypeInfo);
            KeyGroupStreamPartitioner partitioner = new KeyGroupStreamPartitioner((KeySelector)selector, 128);
            PartitionTransformation partitionedTransform = new PartitionTransformation((Transformation)sourceTransformationWrapper, (StreamPartitioner)partitioner);
            this.createTransformationMeta("partitioner", "Partitioner", "Partitioner", config).fill(partitionedTransform);
            return partitionedTransform;
        }
        return sourceTransformationWrapper;
    }

    private ProviderContext createProviderContext(ExecNodeConfig config) {
        return name -> {
            if (this instanceof StreamExecNode && config.shouldSetUid()) {
                return Optional.of(this.createTransformationUid(name, config));
            }
            return Optional.empty();
        };
    }

    @Deprecated
    protected Transformation<RowData> createSourceFunctionTransformation(StreamExecutionEnvironment env, SourceFunction<RowData> function, boolean isBounded, String operatorName, TypeInformation<RowData> outputTypeInfo, int sourceParallelism, boolean sourceParallelismConfigured) {
        int parallelism;
        env.clean(function);
        if (function instanceof ParallelSourceFunction) {
            parallelism = sourceParallelismConfigured ? sourceParallelism : env.getParallelism();
        } else {
            parallelism = 1;
            sourceParallelismConfigured = true;
        }
        Boundedness boundedness = isBounded ? Boundedness.BOUNDED : Boundedness.CONTINUOUS_UNBOUNDED;
        StreamSource sourceOperator = new StreamSource(function, !isBounded);
        return new LegacySourceTransformation(operatorName, sourceOperator, outputTypeInfo, parallelism, boundedness, sourceParallelismConfigured);
    }

    protected abstract Transformation<RowData> createInputFormatTransformation(StreamExecutionEnvironment var1, InputFormat<RowData, ?> var2, InternalTypeInfo<RowData> var3, String var4);
}

