/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.base.Preconditions;

final class ReferenceCounted<T> {
    private final T instance;
    private int refs;

    private ReferenceCounted(T instance) {
        this.instance = instance;
    }

    static <T> ReferenceCounted<T> wrap(T instance) {
        Preconditions.checkNotNull(instance, "instance");
        return new ReferenceCounted<T>(instance);
    }

    void retain() {
        ++this.refs;
    }

    void release() {
        Preconditions.checkState(this.refs > 0, "reference reached 0");
        --this.refs;
    }

    int getReferenceCount() {
        return this.refs;
    }

    T get() {
        return this.instance;
    }
}

