/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.lookup;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.AsyncLookupFunction;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.runtime.operators.join.lookup.ResultRetryStrategy;
import org.apache.flink.util.Preconditions;

public class RetryableAsyncLookupFunctionDelegator
extends AsyncLookupFunction {
    private final AsyncLookupFunction userLookupFunction;
    private final ResultRetryStrategy retryStrategy;
    private final boolean retryEnabled;
    private transient Predicate<Collection<RowData>> retryResultPredicate;

    public RetryableAsyncLookupFunctionDelegator(@Nonnull AsyncLookupFunction userLookupFunction, @Nonnull ResultRetryStrategy retryStrategy) {
        this.userLookupFunction = (AsyncLookupFunction)Preconditions.checkNotNull((Object)userLookupFunction);
        this.retryStrategy = (ResultRetryStrategy)Preconditions.checkNotNull((Object)retryStrategy);
        this.retryEnabled = retryStrategy.getRetryPredicate().resultPredicate().isPresent();
    }

    public void open(FunctionContext context) throws Exception {
        super.open(context);
        this.userLookupFunction.open(context);
        this.retryResultPredicate = this.retryStrategy.getRetryPredicate().resultPredicate().orElse(ignore -> false);
    }

    public CompletableFuture<Collection<RowData>> asyncLookup(RowData keyRow) {
        if (!this.retryEnabled) {
            return this.userLookupFunction.asyncLookup(keyRow);
        }
        CompletableFuture<Collection<RowData>> resultFuture = new CompletableFuture<Collection<RowData>>();
        this.lookupWithRetry(resultFuture, 1, keyRow);
        return resultFuture;
    }

    private void lookupWithRetry(CompletableFuture<Collection<RowData>> resultFuture, int currentAttempts, RowData keyRow) {
        CompletableFuture lookupFuture = this.userLookupFunction.asyncLookup(keyRow);
        lookupFuture.whenCompleteAsync((result, throwable) -> {
            if (this.retryResultPredicate.test((Collection<RowData>)result) && this.retryStrategy.canRetry(currentAttempts)) {
                long backoff = this.retryStrategy.getBackoffTimeMillis(currentAttempts);
                try {
                    Thread.sleep(backoff);
                }
                catch (InterruptedException e) {
                    resultFuture.complete((Collection<RowData>)result);
                    return;
                }
                this.lookupWithRetry(resultFuture, currentAttempts + 1, keyRow);
            } else {
                resultFuture.complete((Collection<RowData>)result);
            }
        });
    }

    public void close() throws Exception {
        this.userLookupFunction.close();
        super.close();
    }
}

