/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.flume.ChannelException;
import org.apache.flume.Context;
import org.apache.flume.CounterGroup;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.FlumeException;
import org.apache.flume.PollableSource;
import org.apache.flume.conf.BatchSizeSupported;
import org.apache.flume.conf.Configurable;
import org.apache.flume.event.EventBuilder;
import org.apache.flume.source.AbstractPollableSource;
import org.apache.flume.source.shaded.guava.RateLimiter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StressSource
extends AbstractPollableSource
implements Configurable,
BatchSizeSupported {
    private static final Logger logger = LoggerFactory.getLogger(StressSource.class);
    private CounterGroup counterGroup = new CounterGroup();
    private byte[] buffer;
    private long maxTotalEvents;
    private long maxSuccessfulEvents;
    private int batchSize;
    private long lastSent = 0L;
    private Event event;
    private List<Event> eventBatchList;
    private List<Event> eventBatchListToProcess;
    private RateLimiter limiter;

    @Override
    protected void doConfigure(Context context) throws FlumeException {
        this.maxTotalEvents = context.getLong("maxTotalEvents", Long.valueOf(-1L));
        this.maxSuccessfulEvents = context.getLong("maxSuccessfulEvents", Long.valueOf(-1L));
        this.batchSize = context.getInteger("batchSize", Integer.valueOf(1));
        int size = context.getInteger("size", Integer.valueOf(500));
        int rateLimit = context.getInteger("maxEventsPerSecond", Integer.valueOf(0));
        this.limiter = rateLimit > 0 ? RateLimiter.create(rateLimit) : null;
        this.prepEventData(size);
    }

    private void prepEventData(int bufferSize) {
        this.buffer = new byte[bufferSize];
        Arrays.fill(this.buffer, (byte)127);
        if (this.batchSize > 1) {
            this.eventBatchList = new ArrayList<Event>();
            for (int i = 0; i < this.batchSize; ++i) {
                this.eventBatchList.add(EventBuilder.withBody((byte[])this.buffer));
            }
        } else {
            this.event = EventBuilder.withBody((byte[])this.buffer);
        }
    }

    @Override
    protected PollableSource.Status doProcess() throws EventDeliveryException {
        long totalEventSent = this.counterGroup.addAndGet("events.total", this.lastSent);
        if (this.maxTotalEvents >= 0L && totalEventSent >= this.maxTotalEvents || this.maxSuccessfulEvents >= 0L && this.counterGroup.get("events.successful") >= this.maxSuccessfulEvents) {
            return PollableSource.Status.BACKOFF;
        }
        try {
            this.lastSent = this.batchSize;
            if (this.batchSize == 1) {
                if (this.limiter != null) {
                    this.limiter.acquire();
                }
                this.getChannelProcessor().processEvent(this.event);
            } else {
                long eventsLeft = this.maxTotalEvents - totalEventSent;
                this.eventBatchListToProcess = this.maxTotalEvents >= 0L && eventsLeft < (long)this.batchSize ? this.eventBatchList.subList(0, (int)eventsLeft) : this.eventBatchList;
                this.lastSent = this.eventBatchListToProcess.size();
                if (this.limiter != null) {
                    this.limiter.acquire((int)this.lastSent);
                }
                this.getChannelProcessor().processEventBatch(this.eventBatchListToProcess);
            }
            this.counterGroup.addAndGet("events.successful", this.lastSent);
        }
        catch (ChannelException ex) {
            this.counterGroup.addAndGet("events.failed", this.lastSent);
            return PollableSource.Status.BACKOFF;
        }
        return PollableSource.Status.READY;
    }

    @Override
    protected void doStart() throws FlumeException {
        logger.info("Stress source doStart finished");
    }

    @Override
    protected void doStop() throws FlumeException {
        logger.info("Stress source do stop. Metrics:{}", (Object)this.counterGroup);
    }

    @Override
    public long getBatchSize() {
        return this.batchSize;
    }
}

