/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.Properties;
import kafka.admin.AdminOperationException;
import kafka.admin.DeleteRecordsCommand;
import kafka.common.AdminCommandFailedException;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeLong$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonValue;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.DeleteRecordsResult;
import org.apache.kafka.clients.admin.DeletedRecords;
import org.apache.kafka.clients.admin.RecordsToDelete;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class DeleteRecordsCommand$ {
    public static final DeleteRecordsCommand$ MODULE$ = new DeleteRecordsCommand$();
    private static final int EarliestVersion = 1;

    public int EarliestVersion() {
        return EarliestVersion;
    }

    public void main(String[] args) {
        this.execute(args, System.out);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Seq<Tuple2<TopicPartition, Object>> parseOffsetJsonStringWithoutDedup(String jsonData) {
        Option<JsonValue> option = Json$.MODULE$.parseFull(jsonData);
        if (option instanceof Some) {
            int n;
            JsonValue js = (JsonValue)((Some)option).value();
            Option<JsonValue> option2 = js.asJsonObject().get("version");
            if (option2 instanceof Some) {
                n = BoxesRunTime.unboxToInt((Object)((JsonValue)((Some)option2).value()).to(DecodeJson$DecodeInt$.MODULE$));
                return this.parseJsonData(n, js);
            } else {
                if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                n = this.EarliestVersion();
            }
            return this.parseJsonData(n, js);
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        throw new AdminOperationException("The input string is not a valid JSON");
    }

    public Seq<Tuple2<TopicPartition, Object>> parseJsonData(int version, JsonValue js) {
        switch (version) {
            case 1: {
                Buffer buffer;
                Iterator iterator;
                Option<JsonValue> option = js.asJsonObject().get("partitions");
                if (option instanceof Some) {
                    iterator = ((JsonValue)((Some)option).value()).asJsonArray().iterator().map((Function1 & Serializable)x$1 -> x$1.asJsonObject()).map((Function1 & Serializable)partitionJs -> {
                        void $minus$greater$extension_y;
                        Long l;
                        String topic = partitionJs.apply("topic").to(DecodeJson$DecodeString$.MODULE$);
                        int partition = BoxesRunTime.unboxToInt((Object)partitionJs.apply("partition").to(DecodeJson$DecodeInt$.MODULE$));
                        long offset = BoxesRunTime.unboxToLong((Object)partitionJs.apply("offset").to(DecodeJson$DecodeLong$.MODULE$));
                        Long l2 = l = Long.valueOf(offset);
                        l = null;
                        Long l3 = l2;
                        TopicPartition $minus$greater$extension_$this = new TopicPartition(topic, partition);
                        return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                    });
                    if (iterator == null) {
                        throw null;
                    }
                } else {
                    throw new AdminOperationException("Missing partitions field");
                }
                Iterator toBuffer_this = iterator;
                Buffer buffer2 = buffer = (Buffer)Buffer$.MODULE$.from((IterableOnce)toBuffer_this);
                Object var5_4 = null;
                buffer = null;
                Buffer buffer3 = buffer2;
                return buffer3;
            }
        }
        throw new AdminOperationException(new StringBuilder(34).append("Not supported version field value ").append(version).toString());
    }

    public void execute(String[] args, PrintStream out) {
        DeleteRecordsCommand.DeleteRecordsCommandOptions opts = new DeleteRecordsCommand.DeleteRecordsCommandOptions(args);
        Admin adminClient = this.createAdminClient(opts);
        String offsetJsonString = Utils.readFileAsString((String)((String)opts.options().valueOf(opts.offsetJsonFileOpt())));
        Seq<Tuple2<TopicPartition, Object>> offsetSeq = this.parseOffsetJsonStringWithoutDedup(offsetJsonString);
        Iterable duplicatePartitions = CoreUtils$.MODULE$.duplicates((Iterable)offsetSeq.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            return topicPartition;
        }));
        if (duplicatePartitions.nonEmpty()) {
            Object[] objectArray = new Object[1];
            String mkString_sep = ",";
            Object var10_8 = null;
            objectArray[0] = duplicatePartitions.mkString("", mkString_sep, "");
            throw new AdminCommandFailedException(StringOps$.MODULE$.format$extension("Offset json file contains duplicate topic partitions: %s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray)));
        }
        java.util.Map recordsToDelete = AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)((IterableOnceOps)offsetSeq.map((Function1 & Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            TopicPartition topicPartition = (TopicPartition)x0$2._1();
            long offset = x0$2._2$mcJ$sp();
            Tuple2 tuple2 = new Tuple2((Object)topicPartition, (Object)RecordsToDelete.beforeOffset((long)offset));
            return tuple2;
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
        out.println("Executing records delete operation");
        DeleteRecordsResult deleteRecordsResult = adminClient.deleteRecords(recordsToDelete);
        out.println("Records delete operation completed:");
        deleteRecordsResult.lowWatermarks().forEach((tp, partitionResult) -> {
            try {
                out.println(new StringBuilder(27).append("partition: ").append(tp).append("\tlow_watermark: ").append(((DeletedRecords)partitionResult.get()).lowWatermark()).toString());
                return;
            }
            catch (Exception e) {
                out.println(new StringBuilder(19).append("partition: ").append(tp).append("\terror: ").append(e.getMessage()).toString());
                return;
            }
        });
        adminClient.close();
    }

    private Admin createAdminClient(DeleteRecordsCommand.DeleteRecordsCommandOptions opts) {
        Properties props = opts.options().has(opts.commandConfigOpt()) ? Utils.loadProps((String)((String)opts.options().valueOf(opts.commandConfigOpt())), null) : new Properties();
        props.put("bootstrap.servers", opts.options().valueOf(opts.bootstrapServerOpt()));
        return Admin.create((Properties)props);
    }

    private DeleteRecordsCommand$() {
    }
}

