/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import org.hbase.async.HBaseRpc;
import org.hbase.async.RegionInfo;
import org.hbase.async.RowLock;
import org.jboss.netty.buffer.ChannelBuffer;

public final class RowLockRequest
extends HBaseRpc
implements HBaseRpc.HasTable,
HBaseRpc.HasKey {
    private static final byte[] LOCK_ROW = new byte[]{108, 111, 99, 107, 82, 111, 119};

    public RowLockRequest(byte[] table, byte[] key) {
        super(table, key);
    }

    public RowLockRequest(String table, String key) {
        this(table.getBytes(), key.getBytes());
    }

    @Override
    byte[] method(byte unused_server_version) {
        return LOCK_ROW;
    }

    @Override
    public byte[] table() {
        return this.table;
    }

    @Override
    public byte[] key() {
        return this.key;
    }

    private int predictSerializedSize() {
        int size = 0;
        size += 4;
        ++size;
        size += 3;
        size += this.region.name().length;
        ++size;
        size += 3;
        return size += this.key.length;
    }

    @Override
    ChannelBuffer serialize(byte server_version) {
        if (server_version >= 95) {
            throw new UnsupportedOperationException("Row locks are not supported with this version of HBase (" + server_version + ").");
        }
        ChannelBuffer buf = this.newBuffer(server_version, this.predictSerializedSize());
        buf.writeInt(2);
        RowLockRequest.writeHBaseByteArray(buf, this.region.name());
        RowLockRequest.writeHBaseByteArray(buf, this.key);
        return buf;
    }

    @Override
    Object deserialize(ChannelBuffer buf, int cell_size) {
        throw new AssertionError((Object)"Should never be here.");
    }

    static final class ReleaseRequest
    extends HBaseRpc {
        private static final byte[] UNLOCK_ROW = new byte[]{117, 110, 108, 111, 99, 107, 82, 111, 119};
        private final RowLock lock;

        ReleaseRequest(RowLock lock, RegionInfo region) {
            super(region.table(), region.stopKey());
            this.lock = lock;
        }

        @Override
        byte[] method(byte unused_server_version) {
            return UNLOCK_ROW;
        }

        @Override
        ChannelBuffer serialize(byte server_version) {
            ChannelBuffer buf = this.newBuffer(server_version, 8 + this.region.name().length + 1 + 8);
            buf.writeInt(2);
            ReleaseRequest.writeHBaseByteArray(buf, this.region.name());
            ReleaseRequest.writeHBaseLong(buf, this.lock.id());
            return buf;
        }

        @Override
        Object deserialize(ChannelBuffer buf, int cell_size) {
            throw new AssertionError((Object)"Should never be here.");
        }
    }
}

