/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.api;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.callback.CallbackHandler;
import org.apache.flume.FlumeException;
import org.apache.flume.api.ThriftRpcClient;
import org.apache.flume.auth.FlumeAuthenticationUtil;
import org.apache.flume.auth.FlumeAuthenticator;
import org.apache.flume.auth.PrivilegedExecutor;
import org.apache.thrift.transport.TSaslClientTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class SecureThriftRpcClient
extends ThriftRpcClient {
    private static final String CLIENT_PRINCIPAL = "client-principal";
    private static final String CLIENT_KEYTAB = "client-keytab";
    private static final String SERVER_PRINCIPAL = "server-principal";
    private String serverPrincipal;
    private FlumeAuthenticator privilegedExecutor;

    protected void configure(Properties properties) throws FlumeException {
        super.configure(properties);
        this.serverPrincipal = properties.getProperty(SERVER_PRINCIPAL);
        if (this.serverPrincipal == null || this.serverPrincipal.isEmpty()) {
            throw new IllegalArgumentException("Flume in secure mode, but Flume config doesn't specify a server principal to use for Kerberos auth.");
        }
        String clientPrincipal = properties.getProperty(CLIENT_PRINCIPAL);
        String keytab = properties.getProperty(CLIENT_KEYTAB);
        this.privilegedExecutor = FlumeAuthenticationUtil.getAuthenticator(clientPrincipal, keytab);
        if (!this.privilegedExecutor.isAuthenticated()) {
            throw new FlumeException("Authentication failed in Kerberos mode for principal " + clientPrincipal + " keytab " + keytab);
        }
    }

    protected TTransport getTransport(TSocket tsocket) throws Exception {
        String[] names;
        HashMap<String, String> saslProperties = new HashMap<String, String>();
        saslProperties.put("javax.security.sasl.qop", "auth");
        try {
            names = FlumeAuthenticationUtil.splitKerberosName(this.serverPrincipal);
        }
        catch (IOException e) {
            throw new FlumeException("Error while trying to resolve Principal name - " + this.serverPrincipal, (Throwable)e);
        }
        return new UgiSaslClientTransport("GSSAPI", null, names[0], names[1], saslProperties, null, (TTransport)tsocket, this.privilegedExecutor);
    }

    public static class UgiSaslClientTransport
    extends TSaslClientTransport {
        PrivilegedExecutor privilegedExecutor;

        public UgiSaslClientTransport(String mechanism, String authorizationId, String protocol, String serverName, Map<String, String> props, CallbackHandler cbh, TTransport transport, PrivilegedExecutor privilegedExecutor) throws IOException, TTransportException {
            super(mechanism, authorizationId, protocol, serverName, props, cbh, transport);
            this.privilegedExecutor = privilegedExecutor;
        }

        public void open() throws FlumeException {
            try {
                this.privilegedExecutor.execute(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws FlumeException {
                        this.callSuperClassOpen();
                        return null;
                    }
                });
            }
            catch (InterruptedException e) {
                throw new FlumeException("Interrupted while opening underlying transport", (Throwable)e);
            }
            catch (Exception e) {
                throw new FlumeException("Failed to open SASL transport", (Throwable)e);
            }
        }

        private void callSuperClassOpen() throws FlumeException {
            try {
                super.open();
            }
            catch (TTransportException e) {
                throw new FlumeException("Failed to open SASL transport", (Throwable)e);
            }
        }
    }
}

