/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.kafka;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChannelRebalanceListener
implements ConsumerRebalanceListener {
    private static final Logger log = LoggerFactory.getLogger(ChannelRebalanceListener.class);
    private AtomicBoolean rebalanceFlag;

    public ChannelRebalanceListener(AtomicBoolean rebalanceFlag) {
        this.rebalanceFlag = rebalanceFlag;
    }

    public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
        for (TopicPartition partition : partitions) {
            log.info("topic {} - partition {} revoked.", (Object)partition.topic(), (Object)partition.partition());
            this.rebalanceFlag.set(true);
        }
    }

    public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
        for (TopicPartition partition : partitions) {
            log.info("topic {} - partition {} assigned.", (Object)partition.topic(), (Object)partition.partition());
        }
    }
}

