/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.webapp.resources;

import java.util.List;
import java.util.Map;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.PropertyKey;
import org.apache.helix.ZNRecord;
import org.apache.helix.manager.zk.ZkClient;
import org.apache.helix.manager.zk.client.HelixZkClient;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.TaskDriver;
import org.apache.helix.task.TaskUtil;
import org.apache.helix.task.Workflow;
import org.apache.helix.task.WorkflowContext;
import org.apache.helix.webapp.resources.ClusterRepresentationUtil;
import org.apache.helix.webapp.resources.JsonParameters;
import org.apache.helix.webapp.resources.ResourceUtil;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.resource.ServerResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobQueueResource
extends ServerResource {
    private static final Logger LOG = LoggerFactory.getLogger(JobQueueResource.class);

    public JobQueueResource() {
        this.getVariants().add(new Variant(MediaType.TEXT_PLAIN));
        this.getVariants().add(new Variant(MediaType.APPLICATION_JSON));
        this.setNegotiated(false);
    }

    public Representation get() {
        StringRepresentation presentation;
        try {
            String clusterName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.CLUSTER_NAME);
            String jobQueueName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.JOB_QUEUE);
            presentation = this.getHostedEntitiesRepresentation(clusterName, jobQueueName);
        }
        catch (Exception e) {
            String error = ClusterRepresentationUtil.getErrorAsJsonStringFromException(e);
            presentation = new StringRepresentation((CharSequence)error, MediaType.APPLICATION_JSON);
            LOG.error("Fail to get job queue", (Throwable)e);
        }
        return presentation;
    }

    StringRepresentation getHostedEntitiesRepresentation(String clusterName, String jobQueueName) throws Exception {
        ZkClient zkClient = ResourceUtil.getAttributeFromCtx(this.getContext(), ResourceUtil.ContextKey.ZKCLIENT);
        HelixDataAccessor accessor = ClusterRepresentationUtil.getClusterDataAccessor(zkClient, clusterName);
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        TaskDriver taskDriver = new TaskDriver((HelixZkClient)zkClient, clusterName);
        ResourceConfig jobQueueConfig = (ResourceConfig)accessor.getProperty(keyBuilder.resourceConfig(jobQueueName));
        WorkflowContext ctx = taskDriver.getWorkflowContext(jobQueueName);
        ZNRecord hostedEntitiesRecord = new ZNRecord(jobQueueName);
        if (jobQueueConfig != null) {
            hostedEntitiesRecord.merge(jobQueueConfig.getRecord());
        }
        if (ctx != null) {
            hostedEntitiesRecord.merge(ctx.getRecord());
        }
        StringRepresentation representation = new StringRepresentation((CharSequence)ClusterRepresentationUtil.ZNRecordToJson(hostedEntitiesRecord), MediaType.APPLICATION_JSON);
        return representation;
    }

    public Representation post(Representation entity) {
        String clusterName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.CLUSTER_NAME);
        String jobQueueName = ResourceUtil.getAttributeFromRequest(this.getRequest(), ResourceUtil.RequestKey.JOB_QUEUE);
        ZkClient zkClient = ResourceUtil.getAttributeFromCtx(this.getContext(), ResourceUtil.ContextKey.ZKCLIENT);
        try {
            TaskDriver driver = new TaskDriver((HelixZkClient)zkClient, clusterName);
            Form form = new Form(entity);
            JsonParameters jsonParameters = new JsonParameters(form);
            TaskDriver.DriverCommand cmd = TaskDriver.DriverCommand.valueOf((String)jsonParameters.getCommand());
            switch (cmd) {
                case start: {
                    String yamlPayload = ResourceUtil.getYamlParameters(form, ResourceUtil.YamlParamKey.NEW_JOB);
                    if (yamlPayload == null) {
                        throw new HelixException("Yaml job config is required!");
                    }
                    Workflow workflow = Workflow.parse((String)yamlPayload);
                    for (String jobName : workflow.getJobConfigs().keySet()) {
                        Map jobCfgMap = (Map)workflow.getJobConfigs().get(jobName);
                        JobConfig.Builder jobCfgBuilder = JobConfig.Builder.fromMap((Map)jobCfgMap);
                        if (workflow.getTaskConfigs() != null && workflow.getTaskConfigs().containsKey(jobName)) {
                            jobCfgBuilder.addTaskConfigs((List)workflow.getTaskConfigs().get(jobName));
                        }
                        driver.enqueueJob(jobQueueName, TaskUtil.getDenamespacedJobName((String)jobQueueName, (String)jobName), jobCfgBuilder);
                    }
                    break;
                }
                case stop: {
                    driver.stop(jobQueueName);
                    break;
                }
                case resume: {
                    driver.resume(jobQueueName);
                    break;
                }
                case flush: {
                    driver.flushQueue(jobQueueName);
                    break;
                }
                case delete: {
                    driver.delete(jobQueueName);
                    break;
                }
                case clean: {
                    driver.cleanupQueue(jobQueueName);
                    break;
                }
                default: {
                    throw new HelixException("Unsupported job queue command: " + cmd);
                }
            }
            this.getResponse().setEntity((Representation)this.getHostedEntitiesRepresentation(clusterName, jobQueueName));
            this.getResponse().setStatus(Status.SUCCESS_OK);
        }
        catch (Exception e) {
            this.getResponse().setEntity(ClusterRepresentationUtil.getErrorAsJsonStringFromException(e), MediaType.APPLICATION_JSON);
            this.getResponse().setStatus(Status.SUCCESS_OK);
            LOG.error("Error in posting job queue: " + entity, (Throwable)e);
        }
        return null;
    }
}

