/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jetty;

import java.util.logging.Level;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.restlet.Server;
import org.restlet.data.Protocol;
import org.restlet.engine.RestletHelper;
import org.restlet.engine.ssl.SslUtils;
import org.restlet.ext.jetty.JettyServerHelper;
import org.restlet.ext.jetty.internal.RestletSslContextFactory;

public class HttpsServerHelper
extends JettyServerHelper {
    public HttpsServerHelper(Server server) {
        super(server);
        this.getProtocols().add(Protocol.HTTPS);
    }

    @Override
    protected AbstractConnector createConnector() {
        SslSelectChannelConnector result = null;
        RestletSslContextFactory sslContextFactory = null;
        try {
            sslContextFactory = new RestletSslContextFactory(SslUtils.getSslContextFactory((RestletHelper)this));
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Unable to create the Jetty SSL context factory", e);
        }
        if (sslContextFactory != null) {
            switch (this.getType()) {
                case 1: {
                    result = new SslSelectChannelConnector((SslContextFactory)sslContextFactory);
                    break;
                }
                case 2: {
                    result = new SslSocketConnector((SslContextFactory)sslContextFactory);
                }
            }
        }
        return result;
    }

    public int getType() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("type", "2"));
    }
}

