/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.util;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.PropertyType;
import org.apache.helix.controller.dataproviders.ResourceControllerDataProvider;
import org.apache.helix.controller.rebalancer.AbstractRebalancer;
import org.apache.helix.controller.rebalancer.strategy.RebalanceStrategy;
import org.apache.helix.model.BuiltInStateModelDefinitions;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.Message;
import org.apache.helix.model.StateModelDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HelixUtil {
    private static Logger LOG = LoggerFactory.getLogger(HelixUtil.class);

    private HelixUtil() {
    }

    public static String getInstanceNameFromPath(String path) {
        String[] split;
        if (path.contains("/" + (Object)((Object)PropertyType.INSTANCES) + "/") && (split = path.split("\\/")).length > 3) {
            return split[3];
        }
        return null;
    }

    public static String getZkParentPath(String path) {
        if (path.equals("/")) {
            return null;
        }
        int idx = path.lastIndexOf(47);
        return idx == 0 ? "/" : path.substring(0, idx);
    }

    public static String getZkName(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    public static String serializeByComma(List<String> objects) {
        return Joiner.on((String)",").join(objects);
    }

    public static List<String> deserializeByComma(String object) {
        if (object.length() == 0) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(object.split(","));
    }

    public static Map<String, String> parseCsvFormatedKeyValuePairs(String keyValuePairs) {
        String[] pairs = keyValuePairs.split("[\\s,]");
        TreeMap<String, String> keyValueMap = new TreeMap<String, String>();
        for (String pair : pairs) {
            int idx = pair.indexOf(61);
            if (idx == -1) {
                LOG.error("Invalid key-value pair: " + pair + ". Igonore it.");
                continue;
            }
            String key = pair.substring(0, idx);
            String value = pair.substring(idx + 1);
            keyValueMap.put(key, value);
        }
        return keyValueMap;
    }

    public static <T> Class<?> loadClass(Class<T> clazz, String className) throws ClassNotFoundException {
        try {
            return clazz.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            if (Thread.currentThread().getContextClassLoader() != null) {
                return Thread.currentThread().getContextClassLoader().loadClass(className);
            }
            throw ex;
        }
    }

    public static Map<String, Map<String, String>> getIdealAssignmentForFullAuto(ClusterConfig clusterConfig, List<InstanceConfig> instanceConfigs, List<String> liveInstances, IdealState idealState, List<String> partitions, String strategyClassName) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        ArrayList<String> allNodes = new ArrayList<String>();
        HashMap<String, InstanceConfig> instanceConfigMap = new HashMap<String, InstanceConfig>();
        for (InstanceConfig instanceConfig : instanceConfigs) {
            allNodes.add(instanceConfig.getInstanceName());
            instanceConfigMap.put(instanceConfig.getInstanceName(), instanceConfig);
        }
        ResourceControllerDataProvider cache = new ResourceControllerDataProvider();
        cache.setClusterConfig(clusterConfig);
        cache.setInstanceConfigMap(instanceConfigMap);
        StateModelDefinition stateModelDefinition = BuiltInStateModelDefinitions.valueOf(idealState.getStateModelDefRef()).getStateModelDefinition();
        RebalanceStrategy strategy = (RebalanceStrategy)RebalanceStrategy.class.cast(HelixUtil.loadClass(HelixUtil.class, strategyClassName).newInstance());
        strategy.init(idealState.getResourceName(), partitions, stateModelDefinition.getStateCountMap(liveInstances.size(), Integer.parseInt(idealState.getReplicas())), idealState.getMaxPartitionsPerInstance());
        List disabledInstance = instanceConfigs.stream().filter(enabled -> !enabled.getInstanceEnabled()).map(InstanceConfig::getInstanceName).collect(Collectors.toList());
        liveInstances.removeAll(disabledInstance);
        Map<String, List<String>> preferenceLists = strategy.computePartitionAssignment(allNodes, liveInstances, new HashMap<String, Map<String, String>>(), cache).getListFields();
        HashMap<String, Map<String, String>> idealStateMapping = new HashMap<String, Map<String, String>>();
        HashSet<String> liveInstanceSet = new HashSet<String>(liveInstances);
        for (String partitionName : preferenceLists.keySet()) {
            idealStateMapping.put(partitionName, HelixUtil.computeIdealMapping(preferenceLists.get(partitionName), stateModelDefinition, liveInstanceSet));
        }
        return idealStateMapping;
    }

    public static Map<String, String> computeIdealMapping(List<String> preferenceList, StateModelDefinition stateModelDef, Set<String> liveAndEnabled) {
        HashMap<String, String> idealStateMap = new HashMap<String, String>();
        if (preferenceList == null) {
            return idealStateMap;
        }
        List<String> statesPriorityList = stateModelDef.getStatesPriorityList();
        HashSet<String> assigned = new HashSet<String>();
        block0: for (String state : statesPriorityList) {
            int stateCount = AbstractRebalancer.getStateCount(state, stateModelDef, liveAndEnabled.size(), preferenceList.size());
            for (String instance : preferenceList) {
                if (stateCount <= 0) continue block0;
                if (assigned.contains(instance)) continue;
                idealStateMap.put(instance, state);
                assigned.add(instance);
                --stateCount;
            }
        }
        return idealStateMap;
    }

    public static boolean removeMessageFromZK(HelixDataAccessor accessor, Message msg, String instanceName) {
        try {
            return accessor.removeProperty(msg.getKey(accessor.keyBuilder(), instanceName));
        }
        catch (Exception e) {
            LOG.error("Caught exception while removing message {}.", (Object)msg, (Object)e);
            return false;
        }
    }

    public static int getSystemPropertyAsInt(String propertyKey, int propertyDefaultValue) {
        String valueString = System.getProperty(propertyKey, "" + propertyDefaultValue);
        try {
            int value = Integer.parseInt(valueString);
            if (value > 0) {
                return value;
            }
        }
        catch (NumberFormatException e) {
            LOG.warn("Exception while parsing property: " + propertyKey + ", string: " + valueString + ", using default value: " + propertyDefaultValue);
        }
        return propertyDefaultValue;
    }

    public static long getSystemPropertyAsLong(String propertyKey, long propertyDefaultValue) {
        String valueString = System.getProperty(propertyKey, "" + propertyDefaultValue);
        try {
            long value = Long.parseLong(valueString);
            if (value > 0L) {
                return value;
            }
        }
        catch (NumberFormatException e) {
            LOG.warn("Exception while parsing property: " + propertyKey + ", string: " + valueString + ", using default value: " + propertyDefaultValue);
        }
        return propertyDefaultValue;
    }
}

