/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.mbeans.dynamicMBeans;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Snapshot;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.DynamicMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistogramDynamicMetric
extends DynamicMetric<Histogram, Long> {
    private static final Logger _logger = LoggerFactory.getLogger(HistogramDynamicMetric.class);
    private final Set<String> _attributeNameSet = new HashSet<String>();

    public HistogramDynamicMetric(String metricName, Histogram metricObject) {
        super(metricName, metricObject);
        for (MBeanAttributeInfo attributeInfo : this.getAttributeInfos()) {
            this._attributeNameSet.add(attributeInfo.getName());
        }
    }

    @Override
    public Number getAttributeValue(String attributeName) {
        if (!this._attributeNameSet.contains(attributeName)) {
            return null;
        }
        String[] attributeNameParts = attributeName.split("\\.");
        if (attributeNameParts.length == 2) {
            try {
                SnapshotAttribute snapshotAttribute = SnapshotAttribute.valueOf(attributeNameParts[1]);
                Method getMethod = Snapshot.class.getMethod(snapshotAttribute._getMethodName, new Class[0]);
                Snapshot snapshot = ((Histogram)this.getMetricObject()).getSnapshot();
                if (snapshot != null) {
                    return (Number)getMethod.invoke((Object)snapshot, new Object[0]);
                }
            }
            catch (Exception ex) {
                _logger.error(String.format("Failed to get Snapshot value for attribute: %s", attributeName), (Throwable)ex);
            }
        } else {
            _logger.error(String.format("Invalid attribute name format: %s", attributeName));
        }
        return null;
    }

    @Override
    public void updateValue(Long value) {
        ((Histogram)this.getMetricObject()).update(value.longValue());
    }

    @Override
    protected Set<MBeanAttributeInfo> generateAttributeInfos(String metricName, Histogram metricObject) {
        HashSet<MBeanAttributeInfo> attributeInfoSet = new HashSet<MBeanAttributeInfo>();
        for (SnapshotAttribute snapshotAttribute : SnapshotAttribute.values()) {
            try {
                Method getMethod = Snapshot.class.getMethod(snapshotAttribute._getMethodName, new Class[0]);
                attributeInfoSet.add(new MBeanAttributeInfo(this.getSnapshotAttributeName(metricName, snapshotAttribute.name()), getMethod.getReturnType().getName(), "Attribute exposed for management", true, false, false));
            }
            catch (NoSuchMethodException e) {
                _logger.error("Cannot generate AttributeInfo for Attribute: " + snapshotAttribute._attributeName, (Throwable)e);
            }
        }
        return attributeInfoSet;
    }

    private String getSnapshotAttributeName(String metricName, String snapshotAttribute) {
        return String.format("%s.%s", metricName, snapshotAttribute);
    }

    static enum SnapshotAttribute {
        Pct75th("get75thPercentile", "75Pct"),
        Pct95th("get95thPercentile", "95Pct"),
        Pct99th("get99thPercentile", "99Pct"),
        Max("getMax", "Max"),
        Mean("getMean", "Mean"),
        StdDev("getStdDev", "StdDev");

        final String _getMethodName;
        final String _attributeName;

        private SnapshotAttribute(String getMethodName, String attributeName) {
            this._getMethodName = getMethodName;
            this._attributeName = attributeName;
        }
    }
}

