/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.zookeeper.routing;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.helix.msdcommon.datamodel.MetadataStoreRoutingData;
import org.apache.helix.msdcommon.datamodel.TrieRoutingData;
import org.apache.helix.msdcommon.exception.InvalidRoutingDataException;
import org.apache.helix.zookeeper.constant.RoutingDataReaderType;
import org.apache.helix.zookeeper.exception.MultiZkException;
import org.apache.helix.zookeeper.routing.RoutingDataReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingDataManager {
    private static Logger LOG = LoggerFactory.getLogger(RoutingDataManager.class);
    private String _defaultMsdsEndpoint = System.getProperty("metadataStoreDirectoryServerEndpoint");
    private final Map<String, Map<String, List<String>>> _rawRoutingDataMap = new ConcurrentHashMap<String, Map<String, List<String>>>();
    private final Map<String, MetadataStoreRoutingData> _metadataStoreRoutingDataMap = new ConcurrentHashMap<String, MetadataStoreRoutingData>();
    private volatile long _lastResetTimestamp;
    private static RoutingDataManager _instance;

    private RoutingDataManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RoutingDataManager getInstance() {
        if (_instance != null) return _instance;
        Class<RoutingDataManager> clazz = RoutingDataManager.class;
        synchronized (RoutingDataManager.class) {
            if (_instance != null) return _instance;
            _instance = new RoutingDataManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    public Map<String, List<String>> getRawRoutingData() {
        if (this._defaultMsdsEndpoint == null || this._defaultMsdsEndpoint.isEmpty()) {
            throw new IllegalStateException("HttpRoutingDataReader was unable to find a valid MSDS endpoint String in System Properties!");
        }
        return this.getRawRoutingData(RoutingDataReaderType.HTTP, this._defaultMsdsEndpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, List<String>> getRawRoutingData(RoutingDataReaderType routingDataReaderType, String endpoint) {
        String routingDataCacheKey = this.getRoutingDataCacheKey(routingDataReaderType, endpoint);
        Map<String, List<String>> rawRoutingData = this._rawRoutingDataMap.get(routingDataCacheKey);
        if (rawRoutingData != null) return rawRoutingData;
        Class<RoutingDataManager> clazz = RoutingDataManager.class;
        synchronized (RoutingDataManager.class) {
            rawRoutingData = this._rawRoutingDataMap.get(routingDataCacheKey);
            if (rawRoutingData != null) return rawRoutingData;
            RoutingDataReader reader = this.resolveRoutingDataReader(routingDataReaderType);
            rawRoutingData = reader.getRawRoutingData(endpoint);
            this._rawRoutingDataMap.put(routingDataCacheKey, rawRoutingData);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return rawRoutingData;
        }
    }

    public MetadataStoreRoutingData getMetadataStoreRoutingData() throws InvalidRoutingDataException {
        if (this._defaultMsdsEndpoint == null || this._defaultMsdsEndpoint.isEmpty()) {
            throw new IllegalStateException("HttpRoutingDataReader was unable to find a valid MSDS endpoint String in System Properties!");
        }
        return this.getMetadataStoreRoutingData(RoutingDataReaderType.HTTP, this._defaultMsdsEndpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MetadataStoreRoutingData getMetadataStoreRoutingData(RoutingDataReaderType routingDataReaderType, String endpoint) throws InvalidRoutingDataException {
        String routingDataCacheKey = this.getRoutingDataCacheKey(routingDataReaderType, endpoint);
        MetadataStoreRoutingData metadataStoreRoutingData = this._metadataStoreRoutingDataMap.get(routingDataCacheKey);
        if (metadataStoreRoutingData != null) return metadataStoreRoutingData;
        Class<RoutingDataManager> clazz = RoutingDataManager.class;
        synchronized (RoutingDataManager.class) {
            metadataStoreRoutingData = this._metadataStoreRoutingDataMap.get(routingDataCacheKey);
            if (metadataStoreRoutingData != null) return metadataStoreRoutingData;
            metadataStoreRoutingData = new TrieRoutingData(this.getRawRoutingData(routingDataReaderType, endpoint));
            this._metadataStoreRoutingDataMap.put(routingDataCacheKey, metadataStoreRoutingData);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return metadataStoreRoutingData;
        }
    }

    public synchronized void reset() {
        this._rawRoutingDataMap.clear();
        this._metadataStoreRoutingDataMap.clear();
        this._defaultMsdsEndpoint = System.getProperty("metadataStoreDirectoryServerEndpoint");
        this._lastResetTimestamp = System.currentTimeMillis();
    }

    public long getLastResetTimestamp() {
        return this._lastResetTimestamp;
    }

    private RoutingDataReader resolveRoutingDataReader(RoutingDataReaderType routingDataReaderType) {
        try {
            return (RoutingDataReader)Class.forName(routingDataReaderType.getClassName()).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            String errMsg = "RoutingDataManager::resolveRoutingDataReader: failed to instantiate RoutingDataReader! RoutingDataReaderType: " + (Object)((Object)routingDataReaderType);
            LOG.error(errMsg, (Throwable)e);
            throw new MultiZkException(errMsg, e);
        }
    }

    private String getRoutingDataCacheKey(RoutingDataReaderType routingDataReaderType, String endpoint) {
        if (routingDataReaderType == null) {
            throw new MultiZkException("RoutingDataManager: RoutingDataReaderType cannot be null!");
        }
        return routingDataReaderType.name() + "_" + endpoint;
    }
}

