/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.mbeans;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.SlidingTimeWindowArrayReservoir;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.management.JMException;
import org.apache.helix.HelixConstants;
import org.apache.helix.InstanceType;
import org.apache.helix.monitoring.mbeans.MonitorDomainNames;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.DynamicMBeanProvider;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.HistogramDynamicMetric;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.SimpleDynamicMetric;

public class HelixCallbackMonitor
extends DynamicMBeanProvider {
    public static final String MONITOR_TYPE = "Type";
    public static final String MONITOR_KEY = "Key";
    public static final String MONITOR_CHANGE_TYPE = "Change";
    private static final String MBEAN_DESCRIPTION = "Helix Callback Monitor";
    private final String _sensorName;
    private final HelixConstants.ChangeType _changeType;
    private final InstanceType _type;
    private final String _clusterName;
    private final String _instanceName;
    private SimpleDynamicMetric<Long> _counter;
    private SimpleDynamicMetric<Long> _unbatchedCounter;
    private SimpleDynamicMetric<Long> _totalLatencyCounter;
    private HistogramDynamicMetric _latencyGauge;

    public HelixCallbackMonitor(InstanceType type, String clusterName, String instanceName, HelixConstants.ChangeType changeType) throws JMException {
        this._changeType = changeType;
        this._type = type;
        this._clusterName = clusterName;
        this._instanceName = instanceName;
        this._sensorName = String.format("%s.%s.%s.%s", MonitorDomainNames.HelixCallback.name(), type.name(), clusterName, changeType.name());
        this._latencyGauge = new HistogramDynamicMetric("LatencyGauge", new Histogram((Reservoir)new SlidingTimeWindowArrayReservoir(this.getResetIntervalInMs().longValue(), TimeUnit.MILLISECONDS)));
        this._totalLatencyCounter = new SimpleDynamicMetric<Long>("LatencyCounter", 0L);
        this._unbatchedCounter = new SimpleDynamicMetric<Long>("UnbatchedCounter", 0L);
        this._counter = new SimpleDynamicMetric<Long>("Counter", 0L);
    }

    @Override
    public String getSensorName() {
        return this._sensorName;
    }

    public HelixConstants.ChangeType getChangeType() {
        return this._changeType;
    }

    public void increaseCallbackCounters(long time) {
        this._counter.updateValue(this._counter.getValue() + 1L);
        this._totalLatencyCounter.updateValue(this._totalLatencyCounter.getValue() + time);
        this._latencyGauge.updateValue(time);
    }

    public void increaseCallbackUnbatchedCounters() {
        this._unbatchedCounter.updateValue(this._unbatchedCounter.getValue() + 1L);
    }

    @Override
    public HelixCallbackMonitor register() throws JMException {
        ArrayList attributeList = new ArrayList();
        attributeList.add(this._counter);
        attributeList.add(this._unbatchedCounter);
        attributeList.add(this._totalLatencyCounter);
        attributeList.add(this._latencyGauge);
        this.doRegister(attributeList, MBEAN_DESCRIPTION, MonitorDomainNames.HelixCallback.name(), MONITOR_TYPE, this._type.name(), MONITOR_KEY, this._clusterName + (this._instanceName == null ? "" : "." + this._instanceName), MONITOR_CHANGE_TYPE, this._changeType.name());
        return this;
    }
}

