/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.spectator;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.helix.PropertyType;
import org.apache.helix.model.CustomizedView;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.spectator.RoutingTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomizedViewRoutingTable
extends RoutingTable {
    private static final Logger logger = LoggerFactory.getLogger(CustomizedViewRoutingTable.class);
    private final Collection<CustomizedView> _customizedViews;
    private final String _customizedStateType;

    public CustomizedViewRoutingTable(PropertyType propertyType, String customizedStateType) {
        this(Collections.emptyList(), propertyType, customizedStateType);
    }

    protected CustomizedViewRoutingTable(Collection<CustomizedView> customizedViews, PropertyType propertytype, String customizedStateType) {
        this(customizedViews, Collections.emptyList(), Collections.emptyList(), propertytype, customizedStateType);
    }

    protected CustomizedViewRoutingTable(Collection<CustomizedView> customizedViews, Collection<InstanceConfig> instanceConfigs, Collection<LiveInstance> liveInstances, PropertyType propertytype, String customizedStateType) {
        super(Collections.emptyList(), instanceConfigs, liveInstances, PropertyType.CUSTOMIZEDVIEW);
        this._customizedStateType = customizedStateType;
        this._customizedViews = new HashSet<CustomizedView>(customizedViews);
        this.refresh(this._customizedViews);
    }

    private void refresh(Collection<CustomizedView> customizedViewList) {
        HashMap<String, InstanceConfig> instanceConfigMap = new HashMap<String, InstanceConfig>();
        if (customizedViewList != null && !customizedViewList.isEmpty()) {
            for (InstanceConfig config : this._instanceConfigs) {
                instanceConfigMap.put(config.getId(), config);
            }
            for (CustomizedView customizeView : customizedViewList) {
                String resourceName = customizeView.getId();
                for (String partitionName : customizeView.getPartitionSet()) {
                    Map<String, String> stateMap = customizeView.getStateMap(partitionName);
                    for (String instanceName : stateMap.keySet()) {
                        String customizedState = stateMap.get(instanceName);
                        if (instanceConfigMap.containsKey(instanceName)) {
                            InstanceConfig instanceConfig = (InstanceConfig)instanceConfigMap.get(instanceName);
                            this.addEntry(resourceName, partitionName, customizedState, instanceConfig);
                            continue;
                        }
                        logger.warn("Participant {} is not found with proper configuration information. It might already be removed from the cluster. Skip recording partition assignment entry: Partition {}, Participant {}, State {}.", new Object[]{instanceName, partitionName, instanceName, stateMap.get(instanceName)});
                    }
                }
            }
        }
    }

    protected Collection<CustomizedView> geCustomizedViews() {
        return Collections.unmodifiableCollection(this._customizedViews);
    }

    @Override
    protected String getStateType() {
        return this._customizedStateType;
    }
}

