/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jetty.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.InputStreamContentProvider;
import org.eclipse.jetty.client.util.InputStreamResponseListener;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Uniform;
import org.restlet.data.Header;
import org.restlet.data.Protocol;
import org.restlet.data.Status;
import org.restlet.engine.adapter.ClientCall;
import org.restlet.ext.jetty.HttpClientHelper;
import org.restlet.representation.Representation;
import org.restlet.util.Series;

public class JettyClientCall
extends ClientCall {
    private final HttpClientHelper clientHelper;
    private final HttpRequest httpRequest;
    private volatile org.eclipse.jetty.client.api.Response httpResponse;
    private volatile InputStreamResponseListener inputStreamResponseListener;
    private volatile boolean responseHeadersAdded;

    public JettyClientCall(HttpClientHelper helper, String method, String requestUri) throws IOException {
        super((org.restlet.engine.adapter.HttpClientHelper)helper, method, requestUri);
        this.clientHelper = helper;
        if (!requestUri.startsWith("http")) {
            throw new IllegalArgumentException("Only HTTP or HTTPS resource URIs are allowed here");
        }
        this.httpRequest = (HttpRequest)helper.getHttpClient().newRequest(requestUri);
        this.httpRequest.method(method);
        this.setConfidential(this.httpRequest.getURI().getScheme().equalsIgnoreCase(Protocol.HTTPS.getSchemeName()));
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public org.eclipse.jetty.client.api.Response getHttpResponse() {
        return this.httpResponse;
    }

    public InputStreamResponseListener getInputStreamResponseListener() {
        return this.inputStreamResponseListener;
    }

    public String getReasonPhrase() {
        org.eclipse.jetty.client.api.Response httpResponse = this.getHttpResponse();
        return httpResponse == null ? null : httpResponse.getReason();
    }

    public WritableByteChannel getRequestEntityChannel() {
        return null;
    }

    public OutputStream getRequestEntityStream() {
        return null;
    }

    public OutputStream getRequestHeadStream() {
        return null;
    }

    public ReadableByteChannel getResponseEntityChannel(long size) {
        return null;
    }

    public InputStream getResponseEntityStream(long size) {
        InputStreamResponseListener inputStreamResponseListener = this.getInputStreamResponseListener();
        return inputStreamResponseListener == null ? null : inputStreamResponseListener.getInputStream();
    }

    public Representation getResponseEntity(Response response) {
        Representation responseEntity = super.getResponseEntity(response);
        if (responseEntity != null && !responseEntity.getEncodings().isEmpty()) {
            responseEntity.getEncodings().clear();
            responseEntity.setSize(-1L);
        }
        return responseEntity;
    }

    public Series<Header> getResponseHeaders() {
        Series result = super.getResponseHeaders();
        if (!this.responseHeadersAdded) {
            HttpFields headers;
            org.eclipse.jetty.client.api.Response httpResponse = this.getHttpResponse();
            if (httpResponse != null && (headers = httpResponse.getHeaders()) != null) {
                for (HttpField header : headers) {
                    result.add(header.getName(), header.getValue());
                }
            }
            this.responseHeadersAdded = true;
        }
        return result;
    }

    public String getServerAddress() {
        return this.httpRequest.getURI().getHost();
    }

    public int getStatusCode() {
        org.eclipse.jetty.client.api.Response httpResponse = this.getHttpResponse();
        return httpResponse == null ? null : Integer.valueOf(httpResponse.getStatus());
    }

    public Status sendRequest(Request request) {
        Status result = null;
        try {
            Representation entity = request.getEntity();
            if (entity != null && entity.isAvailable()) {
                this.httpRequest.content((ContentProvider)new InputStreamContentProvider(entity.getStream()));
            }
            block13: for (Header header : this.getRequestHeaders()) {
                String name;
                switch (name = header.getName()) {
                    case "Content-Length": {
                        continue block13;
                    }
                    case "User-Agent": {
                        this.httpRequest.agent(header.getValue());
                        continue block13;
                    }
                }
                this.httpRequest.header(name, header.getValue());
            }
            this.inputStreamResponseListener = new InputStreamResponseListener();
            this.httpRequest.send((Response.CompleteListener)this.inputStreamResponseListener);
            this.httpResponse = this.inputStreamResponseListener.get(this.clientHelper.getIdleTimeout(), TimeUnit.MILLISECONDS);
            result = new Status(this.getStatusCode(), this.getReasonPhrase());
        }
        catch (IOException e) {
            this.clientHelper.getLogger().log(Level.WARNING, "An error occurred while reading the request entity.", e);
            result = new Status(Status.CONNECTOR_ERROR_INTERNAL, (Throwable)e);
            this.getHttpRequest().abort((Throwable)e);
        }
        catch (TimeoutException e) {
            this.clientHelper.getLogger().log(Level.WARNING, "The HTTP request timed out.", e);
            result = new Status(Status.CONNECTOR_ERROR_COMMUNICATION, (Throwable)e);
            this.getHttpRequest().abort((Throwable)e);
        }
        catch (InterruptedException e) {
            this.clientHelper.getLogger().log(Level.WARNING, "The HTTP request thread was interrupted.", e);
            result = new Status(Status.CONNECTOR_ERROR_COMMUNICATION, (Throwable)e);
            this.getHttpRequest().abort((Throwable)e);
        }
        catch (ExecutionException e) {
            this.clientHelper.getLogger().log(Level.WARNING, "An error occurred while processing the HTTP request.", e);
            result = new Status(Status.CONNECTOR_ERROR_COMMUNICATION, (Throwable)e);
            this.getHttpRequest().abort((Throwable)e);
        }
        return result;
    }

    public void sendRequest(Request request, Response response, Uniform callback) throws Exception {
        this.sendRequest(request);
        Uniform getOnSent = request.getOnSent();
        if (getOnSent != null) {
            getOnSent.handle(request, response);
        }
        if (callback != null) {
            callback.handle(request, response);
        }
    }
}

