/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.tools;

import org.apache.helix.HelixManager;
import org.apache.helix.tools.TestTrigger;
import org.apache.helix.tools.ZnodeOpArg;

public class TestCommand {
    public TestTrigger _trigger;
    public CommandType _commandType;
    public ZnodeOpArg _znodeOpArg;
    public NodeOpArg _nodeOpArg;
    public long _startTimestamp;
    public long _finishTimestamp;

    public TestCommand(CommandType type, ZnodeOpArg arg) {
        this(type, new TestTrigger(), arg);
    }

    public TestCommand(CommandType type, TestTrigger trigger, ZnodeOpArg arg) {
        this._commandType = type;
        this._trigger = trigger;
        this._znodeOpArg = arg;
    }

    public TestCommand(CommandType type, TestTrigger trigger, NodeOpArg arg) {
        this._commandType = type;
        this._trigger = trigger;
        this._nodeOpArg = arg;
    }

    public String toString() {
        String ret = super.toString().substring(super.toString().lastIndexOf(".") + 1) + " ";
        if (this._finishTimestamp > 0L) {
            ret = ret + "FINISH@" + this._finishTimestamp + "-START@" + this._startTimestamp + "=" + (this._finishTimestamp - this._startTimestamp) + "ms ";
        }
        if (this._commandType == CommandType.MODIFY || this._commandType == CommandType.VERIFY) {
            ret = ret + this._commandType.toString() + "|" + this._trigger.toString() + "|" + this._znodeOpArg.toString();
        } else if (this._commandType == CommandType.START || this._commandType == CommandType.STOP) {
            ret = ret + this._commandType.toString() + "|" + this._trigger.toString() + "|" + this._nodeOpArg.toString();
        }
        return ret;
    }

    public static class NodeOpArg {
        public HelixManager _manager;
        public Thread _thread;

        public NodeOpArg(HelixManager manager, Thread thread) {
            this._manager = manager;
            this._thread = thread;
        }
    }

    public static enum CommandType {
        MODIFY,
        VERIFY,
        START,
        STOP;

    }
}

