/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.zookeeper.datamodel.serializer;

import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.helix.zookeeper.datamodel.serializer.PayloadSerializer;
import org.apache.helix.zookeeper.exception.ZkClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonPayloadSerializer
implements PayloadSerializer {
    private static Logger logger = LoggerFactory.getLogger(JacksonPayloadSerializer.class);

    @Override
    public <T> byte[] serialize(T data) {
        if (data == null) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        SerializationConfig serializationConfig = mapper.getSerializationConfig();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.enable(new MapperFeature[]{MapperFeature.AUTO_DETECT_FIELDS});
        mapper.enable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS});
        StringWriter sw = new StringWriter();
        try {
            mapper.writeValue((Writer)sw, data);
        }
        catch (Exception e) {
            logger.error("Exception during payload data serialization.", (Throwable)e);
            throw new ZkClientException(e);
        }
        return sw.toString().getBytes();
    }

    @Override
    public <T> T deserialize(Class<T> clazz, byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        DeserializationConfig deserializationConfig = mapper.getDeserializationConfig();
        mapper.enable(new MapperFeature[]{MapperFeature.AUTO_DETECT_FIELDS});
        mapper.enable(new MapperFeature[]{MapperFeature.AUTO_DETECT_SETTERS});
        mapper.enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        try {
            Object payload = mapper.readValue((InputStream)bais, clazz);
            return (T)payload;
        }
        catch (Exception e) {
            logger.error("Exception during deserialization of payload bytes: " + new String(bytes), (Throwable)e);
            return null;
        }
    }
}

