/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CloseListener;
import org.glassfish.grizzly.CloseType;
import org.glassfish.grizzly.Closeable;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.ConnectionProbe;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.ProcessorSelector;
import org.glassfish.grizzly.ReadResult;
import org.glassfish.grizzly.StandaloneProcessor;
import org.glassfish.grizzly.StandaloneProcessorSelector;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.asyncqueue.AsyncReadQueueRecord;
import org.glassfish.grizzly.asyncqueue.AsyncWriteQueueRecord;
import org.glassfish.grizzly.asyncqueue.PushBackHandler;
import org.glassfish.grizzly.asyncqueue.TaskQueue;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.attributes.IndexedAttributeHolder;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.monitoring.DefaultMonitoringConfig;
import org.glassfish.grizzly.monitoring.MonitoringConfig;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.nio.RegisterChannelResult;
import org.glassfish.grizzly.nio.SelectorHandler;
import org.glassfish.grizzly.nio.SelectorRunner;
import org.glassfish.grizzly.utils.CompletionHandlerAdapter;
import org.glassfish.grizzly.utils.DataStructures;
import org.glassfish.grizzly.utils.Futures;
import org.glassfish.grizzly.utils.NullaryFunction;

public abstract class NIOConnection
implements Connection<SocketAddress> {
    protected static final Object NOTIFICATION_INITIALIZED = Boolean.TRUE;
    protected static final Object NOTIFICATION_CLOSED_COMPLETE = Boolean.FALSE;
    private static final boolean WIN32 = "\\".equals(System.getProperty("file.separator"));
    private static final Logger LOGGER = Grizzly.logger(NIOConnection.class);
    private static final short MAX_ZERO_READ_COUNT = 100;
    protected final NIOTransport transport;
    protected volatile int maxAsyncWriteQueueSize;
    protected volatile long readTimeoutMillis = 30000L;
    protected volatile long writeTimeoutMillis = 30000L;
    protected volatile SelectableChannel channel;
    protected volatile SelectionKey selectionKey;
    protected volatile SelectorRunner selectorRunner;
    protected volatile Processor processor;
    protected volatile ProcessorSelector processorSelector;
    protected final AttributeHolder attributes;
    protected final TaskQueue<AsyncReadQueueRecord> asyncReadQueue;
    protected final TaskQueue<AsyncWriteQueueRecord> asyncWriteQueue;
    protected final AtomicReference<Object> connectCloseSemaphor = new AtomicReference();
    protected final AtomicReference<CloseType> closeTypeFlag = new AtomicReference();
    protected volatile boolean isBlocking;
    protected volatile boolean isStandalone;
    protected short zeroByteReadCount;
    private final Queue<CloseListener> closeListeners = new ConcurrentLinkedQueue<CloseListener>();
    private final ProcessorStatesMap processorStateStorage = new ProcessorStatesMap();
    protected final DefaultMonitoringConfig<ConnectionProbe> monitoringConfig = new DefaultMonitoringConfig<ConnectionProbe>(ConnectionProbe.class);
    Exception closeStackTrace;
    private final SelectorHandler.Task writeSimulatorRunnable = new SelectorHandler.Task(){

        @Override
        public boolean run() throws IOException {
            return NIOConnection.this.transport.getIOStrategy().executeIoEvent(NIOConnection.this, IOEvent.WRITE, false);
        }
    };
    private final SelectorHandler.Task readSimulatorRunnable = new SelectorHandler.Task(){

        @Override
        public boolean run() throws IOException {
            return NIOConnection.this.transport.getIOStrategy().executeIoEvent(NIOConnection.this, IOEvent.READ, false);
        }
    };

    public NIOConnection(NIOTransport transport) {
        this.transport = transport;
        this.asyncReadQueue = TaskQueue.createTaskQueue(null);
        this.asyncWriteQueue = TaskQueue.createTaskQueue(new TaskQueue.MutableMaxQueueSize(){

            @Override
            public int getMaxQueueSize() {
                return NIOConnection.this.maxAsyncWriteQueueSize;
            }
        });
        this.attributes = new IndexedAttributeHolder(transport.getAttributeBuilder());
    }

    @Override
    public void configureBlocking(boolean isBlocking) {
        this.isBlocking = isBlocking;
    }

    @Override
    public boolean isBlocking() {
        return this.isBlocking;
    }

    @Override
    public synchronized void configureStandalone(boolean isStandalone) {
        if (this.isStandalone != isStandalone) {
            this.isStandalone = isStandalone;
            if (isStandalone) {
                this.processor = StandaloneProcessor.INSTANCE;
                this.processorSelector = StandaloneProcessorSelector.INSTANCE;
            } else {
                this.processor = this.transport.getProcessor();
                this.processorSelector = this.transport.getProcessorSelector();
            }
        }
    }

    @Override
    public boolean isStandalone() {
        return this.isStandalone;
    }

    @Override
    public Transport getTransport() {
        return this.transport;
    }

    @Override
    public int getMaxAsyncWriteQueueSize() {
        return this.maxAsyncWriteQueueSize;
    }

    @Override
    public void setMaxAsyncWriteQueueSize(int maxAsyncWriteQueueSize) {
        this.maxAsyncWriteQueueSize = maxAsyncWriteQueueSize;
    }

    @Override
    public long getReadTimeout(TimeUnit timeUnit) {
        return timeUnit.convert(this.readTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void setReadTimeout(long timeout, TimeUnit timeUnit) {
        this.readTimeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
    }

    @Override
    public long getWriteTimeout(TimeUnit timeUnit) {
        return timeUnit.convert(this.writeTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void setWriteTimeout(long timeout, TimeUnit timeUnit) {
        this.writeTimeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
    }

    public SelectorRunner getSelectorRunner() {
        return this.selectorRunner;
    }

    protected void setSelectorRunner(SelectorRunner selectorRunner) {
        this.selectorRunner = selectorRunner;
    }

    public void attachToSelectorRunner(SelectorRunner selectorRunner) throws IOException {
        this.detachSelectorRunner();
        SelectorHandler selectorHandler = this.transport.getSelectorHandler();
        FutureImpl future = Futures.createSafeFuture();
        selectorHandler.registerChannelAsync(selectorRunner, this.channel, 0, this, Futures.toCompletionHandler(future));
        try {
            RegisterChannelResult result = (RegisterChannelResult)future.get(this.readTimeoutMillis, TimeUnit.MILLISECONDS);
            this.selectorRunner = selectorRunner;
            this.selectionKey = result.getSelectionKey();
        }
        catch (InterruptedException e) {
            throw new IOException("", e);
        }
        catch (ExecutionException e) {
            throw new IOException("", e.getCause());
        }
        catch (TimeoutException e) {
            throw new IOException("", e);
        }
    }

    public void detachSelectorRunner() throws IOException {
        SelectorRunner selectorRunnerLocal = this.selectorRunner;
        this.selectionKey = null;
        this.selectorRunner = null;
        if (selectorRunnerLocal != null) {
            this.transport.getSelectorHandler().deregisterChannel(selectorRunnerLocal, this.channel);
        }
    }

    public SelectableChannel getChannel() {
        return this.channel;
    }

    protected void setChannel(SelectableChannel channel) {
        this.channel = channel;
    }

    public SelectionKey getSelectionKey() {
        return this.selectionKey;
    }

    protected void setSelectionKey(SelectionKey selectionKey) {
        this.selectionKey = selectionKey;
        this.setChannel(selectionKey.channel());
    }

    @Override
    public Processor obtainProcessor(IOEvent ioEvent) {
        Processor selectedProcessor;
        if (this.processor == null && this.processorSelector == null) {
            return this.transport.obtainProcessor(ioEvent, this);
        }
        if (this.processor != null && this.processor.isInterested(ioEvent)) {
            return this.processor;
        }
        if (this.processorSelector != null && (selectedProcessor = this.processorSelector.select(ioEvent, this)) != null) {
            return selectedProcessor;
        }
        return null;
    }

    @Override
    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    public void setProcessor(Processor preferableProcessor) {
        this.processor = preferableProcessor;
    }

    @Override
    public ProcessorSelector getProcessorSelector() {
        return this.processorSelector;
    }

    @Override
    public void setProcessorSelector(ProcessorSelector preferableProcessorSelector) {
        this.processorSelector = preferableProcessorSelector;
    }

    @Override
    public <E> E obtainProcessorState(Processor processor, NullaryFunction<E> factory) {
        return this.processorStateStorage.getState(processor, factory);
    }

    public TaskQueue<AsyncReadQueueRecord> getAsyncReadQueue() {
        return this.asyncReadQueue;
    }

    public TaskQueue<AsyncWriteQueueRecord> getAsyncWriteQueue() {
        return this.asyncWriteQueue;
    }

    @Override
    public AttributeHolder getAttributes() {
        return this.attributes;
    }

    @Override
    public <M> GrizzlyFuture<ReadResult<M, SocketAddress>> read() {
        FutureImpl<ReadResult<M, SocketAddress>> future = Futures.createSafeFuture();
        this.read(Futures.toCompletionHandler(future));
        return future;
    }

    @Override
    public <M> void read(CompletionHandler<ReadResult<M, SocketAddress>> completionHandler) {
        Processor obtainedProcessor = this.obtainProcessor(IOEvent.READ);
        obtainedProcessor.read(this, completionHandler);
    }

    @Override
    public <M> GrizzlyFuture<WriteResult<M, SocketAddress>> write(M message) {
        FutureImpl<WriteResult<M, SocketAddress>> future = Futures.createSafeFuture();
        this.write(null, message, Futures.toCompletionHandler(future), null);
        return future;
    }

    @Override
    public <M> void write(M message, CompletionHandler<WriteResult<M, SocketAddress>> completionHandler) {
        this.write(null, message, completionHandler, null);
    }

    @Override
    @Deprecated
    public <M> void write(M message, CompletionHandler<WriteResult<M, SocketAddress>> completionHandler, PushBackHandler pushbackHandler) {
        this.write(null, message, completionHandler, pushbackHandler);
    }

    @Override
    public <M> void write(SocketAddress dstAddress, M message, CompletionHandler<WriteResult<M, SocketAddress>> completionHandler) {
        this.write(dstAddress, message, completionHandler, (PushBackHandler)null);
    }

    @Override
    @Deprecated
    public <M> void write(SocketAddress dstAddress, M message, CompletionHandler<WriteResult<M, SocketAddress>> completionHandler, PushBackHandler pushbackHandler) {
        Processor obtainedProcessor = this.obtainProcessor(IOEvent.WRITE);
        obtainedProcessor.write((Connection)this, (Object)dstAddress, message, completionHandler, pushbackHandler);
    }

    @Override
    public boolean isOpen() {
        return this.channel != null && this.channel.isOpen() && this.closeTypeFlag.get() == null;
    }

    @Override
    public GrizzlyFuture<Closeable> close() {
        FutureImpl<Closeable> future = Futures.createSafeFuture();
        this.close(Futures.toCompletionHandler(future));
        return future;
    }

    @Override
    public void close(CompletionHandler<Closeable> completionHandler) {
        this.close0(completionHandler, true);
    }

    @Override
    public final void closeSilently() {
        this.close(null);
    }

    protected void close0(CompletionHandler<Closeable> completionHandler, boolean isClosedLocally) {
        if (this.closeTypeFlag.compareAndSet(null, isClosedLocally ? CloseType.LOCALLY : CloseType.REMOTELY)) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                this.closeStackTrace = new Exception("Close stack trace");
            }
            this.preClose();
            this.notifyCloseListeners();
            NIOConnection.notifyProbesClose(this);
            this.transport.getSelectorHandler().execute(this.selectorRunner, new SelectorHandler.Task(){

                @Override
                public boolean run() {
                    try {
                        NIOConnection.this.transport.closeConnection(NIOConnection.this);
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.FINE, "Error during connection close", e);
                    }
                    return true;
                }
            }, (CompletionHandler<SelectorHandler.Task>)new CompletionHandlerAdapter<Closeable, SelectorHandler.Task>(null, completionHandler){

                @Override
                protected Connection adapt(SelectorHandler.Task result) {
                    return NIOConnection.this;
                }

                @Override
                public void failed(Throwable throwable) {
                    try {
                        NIOConnection.this.transport.closeConnection(NIOConnection.this);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.completed(null);
                }
            });
        } else {
            Futures.notifyResult(null, completionHandler, this);
        }
    }

    @Override
    public void addCloseListener(CloseListener closeListener) {
        CloseType closeType = this.closeTypeFlag.get();
        if (closeType == null) {
            this.closeListeners.add(closeListener);
            closeType = this.closeTypeFlag.get();
            if (closeType != null && this.closeListeners.remove(closeListener)) {
                this.invokeCloseListener(closeListener, closeType);
            }
        } else {
            this.invokeCloseListener(closeListener, closeType);
        }
    }

    @Override
    public boolean removeCloseListener(CloseListener closeListener) {
        return this.closeListeners.remove(closeListener);
    }

    @Override
    public void addCloseListener(Connection.CloseListener closeListener) {
        this.addCloseListener((CloseListener)closeListener);
    }

    @Override
    public boolean removeCloseListener(Connection.CloseListener closeListener) {
        return this.removeCloseListener((CloseListener)closeListener);
    }

    @Override
    public void notifyConnectionError(Throwable error) {
        NIOConnection.notifyProbesError(this, error);
    }

    @Override
    public final MonitoringConfig<ConnectionProbe> getMonitoringConfig() {
        return this.monitoringConfig;
    }

    protected static void notifyProbesBind(NIOConnection connection) {
        ConnectionProbe[] probes = connection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onBindEvent(connection);
            }
        }
    }

    protected static void notifyProbesAccept(NIOConnection serverConnection, NIOConnection clientConnection) {
        ConnectionProbe[] probes = serverConnection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onAcceptEvent(serverConnection, clientConnection);
            }
        }
    }

    protected static void notifyProbesConnect(NIOConnection connection) {
        ConnectionProbe[] probes = connection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onConnectEvent(connection);
            }
        }
    }

    protected static void notifyProbesRead(NIOConnection connection, Buffer data, int size) {
        ConnectionProbe[] probes = connection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onReadEvent(connection, data, size);
            }
        }
    }

    protected static void notifyProbesWrite(NIOConnection connection, Buffer data, long size) {
        ConnectionProbe[] probes = connection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onWriteEvent(connection, data, size);
            }
        }
    }

    protected static void notifyIOEventReady(NIOConnection connection, IOEvent ioEvent) {
        ConnectionProbe[] probes = connection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onIOEventReadyEvent(connection, ioEvent);
            }
        }
    }

    protected static void notifyIOEventEnabled(NIOConnection connection, IOEvent ioEvent) {
        ConnectionProbe[] probes = connection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onIOEventEnableEvent(connection, ioEvent);
            }
        }
    }

    protected static void notifyIOEventDisabled(NIOConnection connection, IOEvent ioEvent) {
        ConnectionProbe[] probes = connection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onIOEventDisableEvent(connection, ioEvent);
            }
        }
    }

    protected static void notifyProbesClose(NIOConnection connection) {
        ConnectionProbe[] probes = connection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onCloseEvent(connection);
            }
        }
    }

    protected static void notifyProbesError(NIOConnection connection, Throwable error) {
        ConnectionProbe[] probes = connection.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (ConnectionProbe probe : probes) {
                probe.onErrorEvent(connection, error);
            }
        }
    }

    private void notifyCloseListeners() {
        CloseListener closeListener;
        CloseType closeType = this.closeTypeFlag.get();
        while ((closeListener = this.closeListeners.poll()) != null) {
            this.invokeCloseListener(closeListener, closeType);
        }
    }

    protected void preClose() {
        if (this.connectCloseSemaphor.getAndSet(NOTIFICATION_CLOSED_COMPLETE) == NOTIFICATION_INITIALIZED) {
            this.transport.fireIOEvent(IOEvent.CLOSED, this, null);
        }
    }

    @Override
    public void simulateIOEvent(IOEvent ioEvent) throws IOException {
        SelectorHandler selectorHandler = this.transport.getSelectorHandler();
        switch (ioEvent) {
            case WRITE: {
                selectorHandler.enque(this.selectorRunner, this.writeSimulatorRunnable, null);
                break;
            }
            case READ: {
                selectorHandler.enque(this.selectorRunner, this.readSimulatorRunnable, null);
                break;
            }
            default: {
                throw new IllegalArgumentException("We support only READ and WRITE events. Got " + (Object)((Object)ioEvent));
            }
        }
    }

    @Override
    public final void enableIOEvent(IOEvent ioEvent) throws IOException {
        int interest = ioEvent.getSelectionKeyInterest();
        if (interest == 0 || !this.isOpen()) {
            return;
        }
        NIOConnection.notifyIOEventEnabled(this, ioEvent);
        SelectorHandler selectorHandler = this.transport.getSelectorHandler();
        selectorHandler.registerKeyInterest(this.selectorRunner, this.selectionKey, interest);
    }

    @Override
    public final void disableIOEvent(IOEvent ioEvent) throws IOException {
        int interest = ioEvent.getSelectionKeyInterest();
        if (interest == 0) {
            return;
        }
        NIOConnection.notifyIOEventDisabled(this, ioEvent);
        SelectorHandler selectorHandler = this.transport.getSelectorHandler();
        selectorHandler.deregisterKeyInterest(this.selectorRunner, this.selectionKey, interest);
    }

    protected final void checkEmptyRead(int size) {
        if (WIN32) {
            if (size == 0) {
                this.zeroByteReadCount = (short)(this.zeroByteReadCount + 1);
                short count = this.zeroByteReadCount;
                if (count >= 100) {
                    this.closeSilently();
                }
            } else {
                this.zeroByteReadCount = 0;
            }
        }
    }

    final void onSelectionKeyUpdated(SelectionKey newSelectionKey) {
        this.selectionKey = newSelectionKey;
    }

    private void invokeCloseListener(CloseListener closeListener, CloseType closeType) {
        try {
            if (closeListener instanceof Connection.CloseListener) {
                Connection.CloseType closeLocal = closeType == CloseType.LOCALLY ? Connection.CloseType.LOCALLY : Connection.CloseType.REMOTELY;
                ((Connection.CloseListener)closeListener).onClosed(this, closeLocal);
            } else {
                closeListener.onClosed(this, closeType);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void setMonitoringProbes(ConnectionProbe[] monitoringProbes) {
        this.monitoringConfig.addProbes((ConnectionProbe[])monitoringProbes);
    }

    private static final class ProcessorStatesMap {
        private volatile int volatileFlag;
        private ProcessorState singleProcessorState;
        private ConcurrentMap<Processor, Object> processorStatesMap;

        private ProcessorStatesMap() {
        }

        public <E> E getState(Processor processor, NullaryFunction<E> stateFactory) {
            int c = this.volatileFlag;
            if (c == 0) {
                return (E)this.getStateSync(processor, stateFactory);
            }
            ProcessorState localProcessorState = this.singleProcessorState;
            if (localProcessorState != null) {
                if (localProcessorState.processor.equals(processor)) {
                    return (E)localProcessorState.state;
                }
            } else {
                return (E)this.getStateSync(processor, stateFactory);
            }
            return (E)StaticMapAccessor.getFromMap(this, processor, stateFactory);
        }

        private synchronized <E> Object getStateSync(Processor processor, NullaryFunction<E> stateFactory) {
            if (this.volatileFlag == 0) {
                E state = stateFactory.evaluate();
                this.singleProcessorState = new ProcessorState(processor, state);
                ++this.volatileFlag;
                return state;
            }
            if (this.volatileFlag == 1 && this.singleProcessorState.processor.equals(processor)) {
                return this.singleProcessorState.state;
            }
            return StaticMapAccessor.getFromMapSync(this, processor, stateFactory);
        }

        private static final class StaticMapAccessor {
            private StaticMapAccessor() {
            }

            private static <E> Object getFromMap(ProcessorStatesMap storage, Processor processor, NullaryFunction<E> stateFactory) {
                Object state;
                ConcurrentMap localStateMap = storage.processorStatesMap;
                if (localStateMap != null && (state = storage.processorStatesMap.get(processor)) != null) {
                    return state;
                }
                return storage.getStateSync(processor, stateFactory);
            }

            private static <E> Object getFromMapSync(ProcessorStatesMap storage, Processor processor, NullaryFunction<E> stateFactory) {
                ConcurrentMap<Processor, E> localStatesMap = storage.processorStatesMap;
                if (localStatesMap != null) {
                    if (localStatesMap.containsKey(processor)) {
                        return localStatesMap.get(processor);
                    }
                    E state = stateFactory.evaluate();
                    localStatesMap.put(processor, state);
                    return state;
                }
                localStatesMap = DataStructures.getConcurrentMap(4);
                E state = stateFactory.evaluate();
                localStatesMap.put(processor, state);
                storage.processorStatesMap = localStatesMap;
                storage.volatileFlag++;
                return state;
            }

            static {
                Grizzly.logger(StaticMapAccessor.class).fine("Map is going to be used as Connection<->ProcessorState storage");
            }
        }

        private static final class ProcessorState {
            private final Processor processor;
            private final Object state;

            public ProcessorState(Processor processor, Object state) {
                this.processor = processor;
                this.state = state;
            }
        }
    }
}

